#include <ifractal.h>


unsigned char TIBBO_REQ_DATA[] = "X";
unsigned char FOSCAM_REQ_DATA[] = {0x4D, 0x4F, 0x5F, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

// //////////////////////////////////////////////////////////////////////
_PUBLIC int broadcast_recv(int sock, BROADCAST_RESPONSE_CALLBACK cb, void *user_data)
{
	struct sockaddr_in remote_addr;
	BROADCAST_DATA data;
	socklen_t addr_len;
	int port, n;

	addr_len = sizeof(remote_addr);
#ifdef WIN32
	n = recvfrom(sock, (char *) &data, sizeof(data), MSG_PEEK, (struct sockaddr *)&remote_addr, &addr_len);
	if (n == 0)
		return(n);

	if (n > 0)
		n = recvfrom(sock, (char *) &data, sizeof(data), 0, (struct sockaddr *)&remote_addr, &addr_len);
#else
	n = recvfrom(sock, &data, sizeof(data), MSG_DONTWAIT, (struct sockaddr *)&remote_addr, &addr_len);
#endif
	if (n < 0)
		return(n);

	port = ntohs(remote_addr.sin_port);
	cb(inet_ntoa(remote_addr.sin_addr), port, &data, n, user_data);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
_PRIVATE int broadcast_recv_timeout(int sock, BROADCAST_RESPONSE_CALLBACK cb, void *user_data, int timeout)
{
	time_t start = time(NULL);

	do
	{
		broadcast_recv(sock, cb, user_data);
		if_sleep(100);
	} while ((time(NULL) - start) < timeout);

	return(0);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
_PUBLIC BROADCAST_CONTEXT * broadcast_new(char *port, BROADCAST_RESPONSE_CALLBACK cb, void *user_data)
{
	BROADCAST_CONTEXT *bc;

	if (port == NULL)
		return(NULL);

	bc = if_malloc(sizeof(BROADCAST_CONTEXT));

	bc->sock = openServerUDP(port);
	strncpy(bc->port, port, sizeof(bc->port));
	bc->cb = cb;
	bc->user_data = user_data;

#ifdef WIN32
	unsigned long int nonBlockingMode = 1;
	ioctlsocket(bc->sock, FIONBIO, &nonBlockingMode);
#endif

	return(bc);
}
// //////////////////////////////////////////////////////////////////////
_PUBLIC void broadcast_free(BROADCAST_CONTEXT *bc)
{
	if (bc == NULL)
		return;

	if (bc->sock > 0)
		if_closesocket(bc->sock);

	if_free(bc);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PUBLIC int broadcast_events_pending(BROADCAST_CONTEXT *bc)
{
	if (bc == NULL)
		return(-1);

	return(broadcast_recv(bc->sock, bc->cb, bc->user_data));
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
_PRIVATE int broadcast_send_in(
	_IN char *port, 
	_IN unsigned char *data,
	_IN size_t size,
	_INOUT char *recvport) 
{
	struct sockaddr_in remote_addr;
	struct sockaddr_in local_addr;
	int n, sock, req_p, resp_p = 0;

	if ((data == NULL) || (size < 1))
		return(-1);

	req_p = atoi(port);
	if (req_p < 1)
		return(-2);

	for (n = 0 ; port[n] != 0 ; n++)
		if (port[n] == ':')
			resp_p = atoi(port + n + 1);

#ifdef WIN32
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(2,2), &wsa) != 0)
		return(-3);
#endif

	if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == -1)
		return(-4);

	int broadcast = 1;
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, (void *) &broadcast, sizeof(broadcast)) == -1) 
		return(-5);

	remote_addr.sin_addr.s_addr = INADDR_BROADCAST;

	if (resp_p > 0)
	{
		local_addr.sin_family = AF_INET;
		local_addr.sin_port = htons(resp_p);
		local_addr.sin_addr.s_addr = INADDR_ANY;
		memset(local_addr.sin_zero, 0, sizeof(local_addr.sin_zero));

		if (bind(sock, (struct sockaddr *) &local_addr, sizeof(local_addr)) == -1)
			return(-6);
	}

	remote_addr.sin_family = AF_INET;
	remote_addr.sin_port = htons(req_p);
	memset(&(remote_addr.sin_zero), 0, sizeof(remote_addr.sin_zero));
	
	n = sendto(sock, (char *) data, size, 0, (struct sockaddr *) &remote_addr, sizeof(struct sockaddr));
	if (n < 1) 
		return(-7);

	getsockname(sock, (struct sockaddr *) &local_addr, (socklen_t *) &n);

	if_closesocket(sock);

	snprintf(recvport, (size_t) sizeof(recvport), "%d", ntohs(local_addr.sin_port));

	return(0);
}
// //////////////////////////////////////////////////////////////////////
BROADCAST_CONTEXT * broadcast_send(
	char *port, 
	unsigned char *data,
	size_t size,
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data)
{
	BROADCAST_CONTEXT *ctx;
	char recvport[PORT_LEN];
	int r;

	r = broadcast_send_in(port, data, size, recvport);
	if (r)
	{
		verbose(stderr, "Erro ao tentar enviar broadcast: %d\n", r);
		return(NULL);
	}

	ctx = broadcast_new(recvport, cb, user_data);
	if (ctx == NULL)
		return(NULL);

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PUBLIC int broadcast_send_data(
	char *port, 
	unsigned char *data,
	size_t size,
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data, 
	unsigned int timeout)
{
	BROADCAST_CONTEXT *ctx = broadcast_send(port, data, size, cb, user_data);

	if (ctx == NULL)
		return(-1);

	broadcast_recv_timeout(ctx->sock, cb, user_data, timeout);

	broadcast_free(ctx);

	return(0);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
_PUBLIC int broadcast_send_foscam(
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data, 
	unsigned int timeout)
{
	return(broadcast_send_data(FOSCAM_PORT, FOSCAM_REQ_DATA, sizeof(FOSCAM_REQ_DATA), cb, user_data, timeout));
}
// //////////////////////////////////////////////////////////////////////
_PUBLIC int broadcast_send_tibbo(
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data, 
	unsigned int timeout)
{
	return(broadcast_send_data(TIBBO_PORT, TIBBO_REQ_DATA, 1, cb, user_data, timeout));
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
BROADCAST_CONTEXT * broadcast_send_foscam_async(
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data)
{
	BROADCAST_CONTEXT *ctx = broadcast_send(
		FOSCAM_PORT, 
		FOSCAM_REQ_DATA, 
		sizeof(FOSCAM_REQ_DATA),
		cb, 
		user_data);

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
BROADCAST_CONTEXT * broadcast_send_tibbo_async(
	BROADCAST_RESPONSE_CALLBACK cb, 
	void *user_data)
{
	BROADCAST_CONTEXT *ctx = broadcast_send(
		TIBBO_PORT, 
		TIBBO_REQ_DATA, 
		1,
		cb, 
		user_data);

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////


