#ifndef BROADCAST_H
#define BROADCAST_H

#include <ifractal.h>

#define FOSCAM_PORT		"10000"
#define TIBBO_PORT		"65535:1001"
#define UDP_SAFE_SIZE		512

typedef struct
{
	unsigned char header[4];
	unsigned char reserved1[19];
	char mac[13];
	char name[49];
	unsigned char port[2];
	unsigned char reserved3[1];
} BROADCAST_FOSCAM_DATA;

typedef union
{
	BROADCAST_FOSCAM_DATA foscam;
	unsigned char data[UDP_SAFE_SIZE];
} BROADCAST_DATA;


typedef struct _BROADCAST_CONTEXT BROADCAST_CONTEXT;

typedef int (*BROADCAST_RESPONSE_CALLBACK)(char *ip, int port, BROADCAST_DATA *, size_t len, void *user_data);

typedef BROADCAST_CONTEXT * (*BROADCAST_REQUEST_FUNC)(BROADCAST_RESPONSE_CALLBACK, void *user_data);

struct _BROADCAST_CONTEXT
{
	int sock;
	char port[PORT_LEN];
	BROADCAST_RESPONSE_CALLBACK cb;
	void *user_data;
};

BROADCAST_CONTEXT * broadcast_new(char *port, BROADCAST_RESPONSE_CALLBACK, void *user_data);
void broadcast_free(BROADCAST_CONTEXT *);
int broadcast_events_pending(BROADCAST_CONTEXT *);

int ping_perform_timeout(
	char *ip_dst, 
	unsigned char *data, 
	size_t datalen, 
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data, 
	int timeout);


BROADCAST_CONTEXT * broadcast_send(
	char *port, 
	unsigned char *data,
	size_t size,
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data);

BROADCAST_CONTEXT * broadcast_icmp(
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data);

BROADCAST_CONTEXT * broadcast_send_foscam_async(
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data);

BROADCAST_CONTEXT * broadcast_send_tibbo_async(
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data);

int broadcast_recv(int sock, BROADCAST_RESPONSE_CALLBACK, void *user_data);

int broadcast_send_data(
	char *port, 
	unsigned char *data,
	size_t size,
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data, 
	unsigned int timeout);

int broadcast_send_foscam(
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data, 
	unsigned int timeout);

int broadcast_send_tibbo(
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data, 
	unsigned int timeout);

BROADCAST_CONTEXT * tcp_portscam(
	char *src_ip,
	char *dst_ip,
	uint16_t ports[],	// vetor de portas terminado em 0.
	BROADCAST_RESPONSE_CALLBACK, 
	void *user_data);

#endif
