#include <stdio.h>
#include <stdlib.h>

#include <ifractal.h>


extern char **environ;

// ////////////////////////////////////////////////////////////////////////// //
char * query_decode(char *query)
{
	int i, j;
	char c;

	for (i = 0 ; query[i] != 0 ; i++)
	{
		if (query[i] == '%')
		{
			c = query[i + 1] - '0';
			if (c > 9)
				c = query[i + 1] - 'A' + 10;
			
			query[i] = query[i + 2] - '0';
			if (query[i] > 9)
				query[i] = query[i + 2] - 'A' + 10;

			query[i] += 16 * c;

			// Copia o resto da string por cima
			for (j = i + 1 ; (query[j] = query[j + 2]) ; j++)
				;

			query[j] = 0;

			continue;
		}
		
		if (query[i] == '+')
			query[i] = ' ';
	}

	return(query);
}
// ////////////////////////////////////////////////////////////
int cgi_get_content(_IN FILE *fd, _OUT char **ref)
{
	int size = BUFFER_LEN;
	int len, n;
	char *buf = if_malloc(size);
	char *p;

	if ((fd == NULL) || (ref == NULL))
		return(-1);

	for (p = buf, len = p - buf ; (n = fread(p, 1, size - len, fd)) > 0 ; )
	{
		p += n;
		len = p - buf;
		if (len > (size / 2))
		{
			size = 1 + (size * 2);
			buf = realloc(buf, size);
			p = buf + len;
		}
		*p = 0;
	}

	*ref = buf;
	return(len);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
char * cgi_get_queryString()
{
	int i;
	char qs[] = "QUERY_STRING=";
	int qs_len = strlen(qs);

	for (i = 0 ; environ[i] != NULL ; i++)
	{
		if (strncmp(qs, environ[i], qs_len))
			continue;

		return(environ[i] + qs_len);
	}

	return("");
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
_PUBLIC IF_CGI_PARAM * cgi_get_GET_params()
{
	char *query = cgi_get_queryString();

	if ((query == NULL) || (query[0] == 0))
		return(NULL);

	return(cgi_get_POST_params(query, strlen(query)));
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int cgi_get_contentLength()
{
	int i;
	char cl[] = "CONTENT_LENGTH=";
	int ct_len = strlen(cl);

	for (i = 0 ; environ[i] != NULL ; i++)
	{
		if (strncmp(cl, environ[i], ct_len))
			continue;

		return(atoi(environ[i] + ct_len));
	}

	return(-1);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
char * line_get_boundary(_IN char *line)
{
	char bd[] = "boundary=";
	int bd_len = strlen(bd);
	int k, len = strlen(line);
	
	for (k = 0 ; k < len ; k++)
	{
		if (strncmp(bd, line + k, bd_len))
			continue;

		if (strncmp(line + k + bd_len, "--", 2) == 0)
			return(if_strdup(line + k + bd_len + 2));
		else
			return(if_strdup(line + k + bd_len));
	}

	return(if_strdup(""));
}
// ////////////////////////////////////////////////////////////
char * cgi_get_boundary()
{
	char ct[] = "CONTENT_TYPE=";
	int i, ct_len = strlen(ct);

	for (i = 0 ; environ[i] != NULL ; i++)
	{
		if (strncmp(ct, environ[i], ct_len))
			continue;

		return(line_get_boundary(environ[i]));
	}

	return("");
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
IF_CGI_PARAM * cgi_param_new(char *name, char *filename)
{
	IF_CGI_PARAM *par =  if_malloc(sizeof(IF_CGI_PARAM));

	memset(par, 0, sizeof(IF_CGI_PARAM));
	par->name = name;
	par->filename = filename;
	par->next = NULL;

	return(par);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int cgi_getStartData(char *buf, int pos, int max)
{
#ifdef WIN32
	char start[] = "\n\n";
#else
	char start[] = "\r\n\r\n";
#endif

	int st_len = strlen(start);
	int i;

	for (i = pos ; i < max ; i++)
		if (!strncmp(start, buf + i, st_len))
			return(i + st_len);

	return(-1);
}
// ////////////////////////////////////////////////////////////
int cgi_getEndData(char *buf, int pos, int max, char *boundary)
{
	char end[PATH_LEN];
	int len, i;

#ifdef WIN32
	len = snprintf(end, PATH_LEN, "\n----%s", boundary);
#else
	len = snprintf(end, PATH_LEN, "\r\n----%s", boundary);
#endif

	for (i = pos ; i < max ; i++)
		if (!strncmp(end, buf + i, len))
			return(i);

	return(-1);
}
// ////////////////////////////////////////////////////////////
char * cgi_getParam(char *buf, char *param, int max)
{
	char pname[PATH_LEN];
	int pn_len, pos, pend;
	char *ret;

	pn_len = snprintf(pname, PATH_LEN, "%s=\"", param);
	for (pos = 0 ; pos < max ; pos++)
	{
		if (strncmp(pname, buf + pos, pn_len))
			continue;

		for (pend = pos + pn_len ; (buf[pend] != '\"') && (pend < max) ; pend++)
			;

		buf[pend] = 0;
		ret = if_strdup(buf + pos + pn_len);
		buf[pend] = '\"';
		return(ret);
	}

	return(if_strdup(""));
}
// ////////////////////////////////////////////////////////////
int cgi_getParamValue(
	_IN char *buf, 
	_IN int pos, 
	_IN int content_length, 
	_IN char *boundary, 
	_OUT int *start, 
	_OUT int *end)
{
	*start = cgi_getStartData(buf, pos, content_length);
	if (*start > 0)
	{
		*end = cgi_getEndData(buf, pos, content_length, boundary);
		if (*end < 1)
			return(-1);
	}
	else
		return(-2);

	return(0);
}
// ////////////////////////////////////////////////////////////
IF_CGI_PARAM * cgi_get_params(char *buf, char *boundary, int content_length)
{
	IF_CGI_PARAM *params = NULL;
	IF_CGI_PARAM *par;
	int bd_len = strlen(boundary);
	int pos, start, end, r;
	char prefixo[] = "----";
#ifdef WIN32
	int cr_lf = 1;
#else
	int cr_lf = 2;
#endif

	for (pos = 0 ; pos < content_length ; )
	{
		if (strncmp(prefixo, buf + pos, strlen(prefixo)))
		{
			fprintf(stdout, "Inicio invalido.\n");
			break;
		}
        
		pos += strlen(prefixo);
		if (strncmp(boundary, buf + pos, bd_len))
		{
			fprintf(stdout, "Boundary invalido. '%s'\n", boundary);
			break;
		}

		pos += bd_len;
		if (!strncmp("--", buf + pos, 2))
			break;

		pos += cr_lf;
		par = cgi_param_new(
			cgi_getParam(buf + pos, "name", content_length - pos),
			cgi_getParam(buf + pos, "filename", content_length - pos));

		par->next = params;
		params = par;

		if ((r = cgi_getParamValue(buf, pos, content_length, boundary, &start, &end)) != 0)
		{
			fprintf(stdout, "Erro ao tentar ler valor. (%d)\n", r);
			break;
		}

		par->length = end - start;
		par->value = if_malloc(par->length + 1);
		memcpy(par->value, buf + start, par->length);
		par->value[par->length] = 0;
		pos = end + cr_lf;
	}

	return(params);
}
// ////////////////////////////////////////////////////////////
void cgi_params_free(IF_CGI_PARAM *params)
{
	IF_CGI_PARAM *aux, *par = params;

	while (par != NULL)
	{
		aux = par;
		par = par->next;

		if_free(aux->name);
		if_free(aux->value);
		if_free(aux->filename);
		if_free(aux);
	}
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
IF_CGI_PARAM * cgi_get_param_n(_IN IF_CGI_PARAM *params, _IN char *name, int n)
{
	IF_CGI_PARAM *param = NULL;
	int i;

	if (name == NULL)
		return(NULL);

	for (i = 0, param = params ; param != NULL ; param = param->next)
		if (strcmp(param->name, name) == 0)
		{
			if (i == n)
				break;
			else
				i++;
		}

	return(param);
}
// ////////////////////////////////////////////////////////////
IF_CGI_PARAM * cgi_get_param(_IN IF_CGI_PARAM *params, _IN char *name)
{
	return(cgi_get_param_n(params, name, 0));
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
int cgi_params_count(_IN IF_CGI_PARAM *params)
{
	IF_CGI_PARAM *par;
	int qty;

	for (qty = 0, par = params ; par != NULL ; par = par->next, qty++)
		;

	return(qty);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int cgi_params_iter(_IN IF_CGI_PARAM *params, IF_CGI_PARAM_ITER func, void *user_data)
{
	IF_CGI_PARAM *par;
	int qty, r;

	for (qty = 0, par = params ; par != NULL ; par = par->next, qty++)
	{
		r = func(par, user_data);
		if (r != 0)
			break;
	}

	return(qty);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
int get_content_part(_IN int sock, _IN char *boundary, _IN int boundary_len, _OUT unsigned char **content)
{
	int n, len = 0;
	int term_len = 2 + boundary_len + 2;	// "--" + boundary_len + "\r\n"
	unsigned char *p, *q;

	*content = if_malloc(JPEG_MAX_LEN);
	p = *content;

	if (p == NULL)
		return(-1);

	while (((n = read_timeout(sock, p++, 1, 10)) > 0) && ((p - *content) < JPEG_MAX_LEN))
	{
		if (n < 1)
		{
			if_free(*content);
			return(-2);
		}

		if ((p - *content) < term_len)
			continue;

		q = p - term_len;
		if (	(strncmp((char *) q, "--", 2) == 0) &&
			(strncmp((char *) (q + 2), boundary, boundary_len) == 0) &&
			(strncmp((char *) (q + 2 + boundary_len), "\r\n", 2) == 0)
			)
		{
			len = (p - *content) - term_len;
			break;
		}
	}

	return(len);
}
// ////////////////////////////////////////////////////////////
int subheader_content_length(_IN int sock, _INOUT char *buf)
{
	int n, size = -1;

	while ((n = readln_timeout(sock, buf, BUFFER_LEN, 30)) > 0)
	{
		if (n < 4)
			break;

		if (strncmp(HTTP_HEADER_LENGTH, buf, strlen(HTTP_HEADER_LENGTH)) == 0)
			size = atoi(buf + strlen(HTTP_HEADER_LENGTH));
	}

	return(size);
}
// ////////////////////////////////////////////////////////////
void cgi_stream_recv(_INOUT char *buf, _IN int sock, IF_CGI_STREAM_CALLBACK cb, void *user_data)
{
	char content_multipart[] = "Content-Type: multipart";
	unsigned char *content;
	int n, bd_len, len, parts;
	char *boundary = "";

	// Recebe headers
	while ((n = readln_timeout(sock, buf, BUFFER_LEN, 10)) > 0)
	{
		if (strncmp(content_multipart, buf, strlen(content_multipart)) == 0)
		{
			boundary = line_get_boundary(buf);
			bd_len = strlen(boundary) - 2;
			boundary[bd_len] = 0;
		}
		
		if (n < 4)
			break;
	}

	if (boundary[0] == 0)
		return;

	for (parts = 0 ; ; parts++)
	{
		if ((len = subheader_content_length(sock, buf)) < 1)
		{
			len = get_content_part(sock, boundary, bd_len, &content);
			if (len == 0)
			{
				if_free(content);
				continue;
			}

			if (len < 1)
				break;
		}
		else
		{
			content = if_malloc(len + 1);
			n = read_bytes(sock, content, len, 15);
			if (n < len)
			{
				if_free(content);
				break;
			}
		}

		n = cb(content, len, user_data);
		if_free(content);
		if (n == 0)
			break;
	}

	if_free(boundary);
}
// ////////////////////////////////////////////////////////////
void cgi_stream(_IN char *host, _IN char *port, _IN char *path, IF_CGI_STREAM_CALLBACK cb, void *user_data)
{
	int sock, n;
	char *buf;

	sock = openTCP(host, port, 20);
	if (sock < 1)
	{
		verbose(stderr, "Erro ao tentar acessar: %s:%s\n", host, port);
		return;
	}

	buf = if_malloc(BUFFER_LEN);	

	// Envia headers
	n = snprintf(buf, BUFFER_LEN, HTTP_GET_HEADERS, path, host);
	send_bytes(sock, buf, n, 10);

	cgi_stream_recv(buf, sock, cb, user_data);
	if_closesocket(sock);

	if_free(buf);
}
// ////////////////////////////////////////////////////////////
void cgi_stream_auth(
	_IN char *host, 
	_IN char *port, 
	_IN char *path, 
	_IN IF_CGI_STREAM_CALLBACK cb, 
	_INOUT void *user_data, 
	_IN char *user, 
	_IN char *pass)
{
	char *auth, *buf, aux[PATH_LEN];
	int sock, n;

	sock = openTCP(host, port, 20);
	if (sock < 1)
	{
		verbose(stderr, "Erro ao tentar acessar: %s:%s\n", host, port);
		return;
	}

	buf = if_malloc(BUFFER_LEN);

	snprintf(aux, PATH_LEN, "%s:%s", user, pass);
	b64_encode((unsigned char *) aux, strlen(aux), &auth);

	// Envia headers
	n = snprintf(buf, BUFFER_LEN, HTTP_GET_HEADERS_AUTH, path, host, auth);
	send_bytes(sock, buf, n, 10);

	cgi_stream_recv(buf, sock, cb, user_data);
	if_closesocket(sock);

	if_free(auth);
	if_free(buf);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
IF_CGI_PARAM * cgi_get_POST_params(char *content, int content_length)
{
	IF_CGI_PARAM *param, *last = NULL;
	char *pairs[128];
	char *pair[3];
	int len, i, n;

	len = tokenizer('&', content, pairs, 128);

	for (i = 0 ; i < len ; i++)
	{
		n = tokenizer('=', pairs[i], pair, 3);
		if (n < 2)
			continue;

		param = malloc(sizeof(IF_CGI_PARAM));
		memset(param, 0, sizeof(IF_CGI_PARAM));

		param->next = last;
		last = param;

		param->length = 0;
		param->name = strdup(query_decode(pair[0]));
		param->value = strdup(query_decode(pair[1]));
		param->filename = strdup("");
	}

	return(param);
}
// ////////////////////////////////////////////////////////////

