#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <core.h>

#include "boleto_barras.h"


// ////////////////////////////////////////////////////////////
_PUBLIC char * param_get_value(JSON_VALUE *params, char *param_name)
{
	JSON_VALUE *param;
	char *name;
	int i;

	for (i = 0 ; i < json_array_length(params) ; i++)
	{
		param = json_array_index(params, i);
		name = json_get_string(json_object_find(param, "name"));

		if (strcmp(name, param_name) != 0)
			continue;

		return(json_get_string(json_object_find(param, "value")));
	}

	return("");
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
_PUBLIC int core_purge_spaces(char *data)
{
	char *p, *q;
	int i;

	for (i = 0 ; i < strlen(data) ; )
	{
		if ((data[i] == '.') || (data[i] == ' ') || (data[i] == '\t'))
		{
			// strcpy(data + i, data + i + 1);
			for (p = data + i, q = data + i + 1 ; (*p++ = *q++) ; )
				;

			continue;
		}

		i++;
	}

	return(i);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_integer(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char *p, *q;

	core_purge_spaces(data);

	for (p = data, q = p + 1 ; *p == '0' ; p = data, q = p + 1)
		while ((*p++ = *q++) != 0)
			;

	return(NULL);
}
// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_currency(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	int i, j, len, pos, v;

	parser_integer(data, NULL, NULL, NULL, NULL, NULL, NULL);

	len = strlen(data);
	if (len < 3)
	{
		v = atoi(data);

		if (v < 10)
			len = snprintf(data, PATH_LEN, "0,0%d", v);
		else
			len = snprintf(data, PATH_LEN, "0,%d", v);

		return(NULL);
	}

	// Acrescenta a virgula
	data[len + 1] = 0;
	data[len] = data[len - 1];
	data[len - 1] = data[len - 2];
	data[len - 2] = ',';

	// Acrescenta os pontos de milhar
	for (len = strlen(data), i = len - 4, pos = 1 ; i >= 0 ; pos++, i--)
	{
		if (((pos % 3) == 0) && (i > 0))
		{
			for (len = strlen(data), data[len + 1] = 0, j = len ; j > i ; j--)
				data[j] = data[j - 1];

			data[i] = '.';
		}
	}

	return(NULL);
}
// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_date(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char *from, *to, buf[PATH_LEN];

	from = param_get_value(params, "de");
	to = param_get_value(params, "para");

	if (strcmp(from, "DDMMAAAA") == 0)
	{
		snprintf(buf, PATH_LEN, "%c%c/%c%c/%s", 
			data[0], data[1], 
			data[2], data[3], 
			data + 4);
	} 
	else if (strcmp(from, "DDMMAA") == 0)
	{
		snprintf(buf, PATH_LEN, "%c%c/%c%c/20%c%c", 
			data[0], data[1], 
			data[2], data[3], 
			data[4], data[5]);
	}
	else if (strcmp(from, "AAAAMMDD") == 0)
	{
		snprintf(buf, PATH_LEN, "%c%c/%c%c/%c%c%c%c", 
			data[6], data[7], 
			data[4], data[5], 
			data[0], data[1], data[2], data[3]);
	} else if (strcmp(from, "DDMMAAAAHHMI") == 0)
	{
		snprintf(buf, PATH_LEN, "%c%c/%c%c/%c%c%c%c %c%c:%c%c", 
			data[0], data[1], 
			data[2], data[3], 
			data[4], data[5], data[6], data[7],
			data[8], data[9], 
			data[10], data[11]);
	}

	strcpy(data, buf);

	return(NULL);
}
// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_trim(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char *p, *q;
	int i;

	// limpa espacos no inicio
	for (i = 0 ; (data[i] == ' ') || (data[i] == '\t') ; i++)
		;

	//strcpy(data, data + i);
	for (p = data, q = data + i ; (*p++ = *q++) ; )
		;

	// limpa espacos no fim
	for (i = strlen(data) - 1 ; (i >= 0) && ((data[i] == ' ') || (data[i] == '\t')) ; i--)
		;

	data[i + 1] = 0;

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_primeira(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	int i;

	parser_trim(data, result, record, templ, data_source, token, params);

	// Procura primeiro espaco
	for (i = 0 ; data[i] != 0 ; i++)
	{
		if (data[i] == ' ')
		{
			data[i] = 0;
			break;
		}
	}

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_retira_acentos(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char acentos[] = "ãaàaáaâaäaåaçcèeéeêeëeìiíiîiïiñnòoóoôoõoöoùuüuúuÿyÀAÁAÂAÃAÄAÅAÇCÈEÉEÊEËEÌIÍIÎIÏIÑNÒOÓOÔOÕOÖOÙUÜUÚUŸY";
	char a;
	int i, j;

	for (i = 0 ; data[i] != 0 ; i++)
	{
		if (data[i] >= ' ')
			continue;

		for (j = 0 ; j < strlen(acentos) ; j += 3)
		{
			a = acentos[j + 1] + 0x40;
			if ((a != data[i]) || (acentos[j + 2] < ' '))
				continue;

			data[i] = acentos[j + 2];
			break;
		}

		if (acentos[j] == 0)
			data[i] = ' ';
	}

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_prefixo_sufixo(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char *prefixo, *sufixo, *buf;
	int len;

	prefixo = param_get_value(params, "prefixo");
	sufixo = param_get_value(params, "sufixo");

	if (strlen(data) == 0)
		return(NULL);

	len = strlen(prefixo) + strlen(data) + strlen(sufixo) + 1;
	buf = if_malloc(len);
	snprintf(buf, len, "%s%s%s", prefixo, data, sufixo);
	strncpy(data, buf, BUFFER_LEN);
	if_free(buf);

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
_PRIVATE void parser_substring_negativo(char *data, int datalen, int *i, int *len)
{
	*i = datalen + *i + 1;
	if (*i < 1)
	{
		*len = 0;
		return;
	}

	if (((*i - *len) < 0) || (*len < 1))
	{
		*len = *i;
		*i = 0;
	}
	else
		*i -= *len;
}
// ////////////////////////////////////////////////////////////
_PRIVATE void parser_substring_positivo(char *data, int datalen, _INOUT int *i, _INOUT int *len)
{
	if (*i > datalen)
	{
		*len = 0;
		return;
	}

	if (((*i + *len) > datalen) || (*len < 1))
		*len = datalen - *i + 1;

	*i -= 1;
}
// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_substring(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	int i, len, k, datalen;

	i = atoi(param_get_value(params, "inicio"));
	len = atoi(param_get_value(params, "tamanho"));

	if ((datalen = strlen(data)) == 0)
		return(NULL);

	if (i > 0)
		parser_substring_positivo(data, datalen, &i, &len);
	else if (i < 0)
		parser_substring_negativo(data, datalen, &i, &len);

	if (i < datalen)
		for (k = 0 ; k < len ; k++)
			data[k] = data[i + k];

	data[len] = 0;

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_purge_spaces(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	core_purge_spaces(data);

	return(NULL);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_se(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params)
{
	char *campo, *valor_campo, *chave, *valor, *text;
	char buf[PATH_LEN];
	JSON_VALUE *aux;
	int i;

	text = param_get_value(params, "default");

	aux = json_object_find(record, text);
	if (aux != NULL)
		text = json_get_string(aux);

	campo = param_get_value(params, "campo");
	aux = json_object_find(record, campo);
	if (aux != NULL)
		valor_campo = json_get_string(aux);
	else
		valor_campo = "";

	for (i = 0 ; ; i++)
	{
		snprintf(buf, PATH_LEN, "chave%d", i + 1);
		chave = param_get_value(params, buf);
        
		snprintf(buf, PATH_LEN, "valor%d", i + 1);
		valor = param_get_value(params, buf);

		if ((chave[0] == 0) && (valor[0] == 0))
			break;

		aux = json_object_find(record, valor);
		if (aux != NULL)
			valor = json_get_string(aux);

		if (strcmp(valor_campo, chave) == 0)
		{
			text = valor;
			break;
		}
	}

	strncpy(data, text, BUFFER_LEN);

	return(NULL);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
_PUBLIC int parser_get_lines(_INOUT char *content, _OUT char ***lines)
{
	char *p = content;
	int len, size = 2;
	char **tk;

	if ((content == NULL) || (lines == NULL))
		return(-1);

	tk = if_malloc(size * sizeof(char *));

	for (len = 1, tk[0] = p ; *p != 0 ; p++)
	{
		if (*p == '\r')
		{
			*p = 0;
			continue;
		}

		if (len >= (size / 2))
		{
			size *= 2;
			tk = realloc(tk, size * sizeof(char *));
		}

		if (*p == '\n')
		{
			*p = 0;
			tk[len++] = p + 1;
			tk[len] = NULL;
		}
	}

	*lines = tk;

	return(len);
} 
// ////////////////////////////////////////////////////////////
_PUBLIC void parser_lines_free(char **lines)
{
}
// ////////////////////////////////////////////////////////////



static IF_PARSER_FUNC_DEF funcs[] = {
	{
		"{'id':1, 'name':'aparar', 'description':'Retirar espacos no inicio e fim do texto.'}",
		parser_trim
	},
	{
		"{'id':2, 'name':'data', 'description':'Ajusta formato de data.', 'params':[{'name':'de', 'type':'string', 'default':'DDMMAAAA'},{'name':'para', 'default':'DD/MM/AAAA', 'options':['DD/MM/AAAA', 'DD/MM']}]}", 
		parser_date
	},
	{
		"{'id':3, 'name':'moeda', 'description':'Ajusta formato para MM.DDD,CC'}", 
		parser_currency
	},
	{
		"{'id':4, 'name':'numero', 'description':'Retira ZEROS a esquerda.'}", 
		parser_integer
	},
	{
		"{'id':5, 'name':'primeira', 'description':'Mantem somente a primeira palavra.'}", 
		parser_primeira
	},
	{
		"{'id':6, 'name':'retira_acentos', 'description':'Retira acentos.'}", 
		parser_retira_acentos
	},
	{
		"{'id':7, 'name':'prefixo_sufixo', 'description':'Acrescenta prefixo e sufixo.', \n" \
		"'params':[\n" \
		"{'name':'prefixo', 'type':'string', 'default':''},\n" \
		"{'name':'sufixo', 'type':'string', 'default':''}]}\n",
		parser_prefixo_sufixo
	},
	{
		"{'id':8, 'name':'substring', 'description':'Substring.', \n" \
		"'params':[\n" \
		"{'name':'inicio', 'type':'string', 'default':''},\n" \
		"{'name':'tamanho', 'type':'string', 'default':''}]}\n",
		parser_substring
	},
	{
		"{'id':9, 'name':'sem espaco', 'description':'Retira espacos e pontos em todo o conteudo.'}",
		parser_purge_spaces
	},
	{
		"{'id':10, 'name':'case..when', 'description':'Substitui conforme chave.', \n" \
		"'params':[\n" \
		"{'name':'campo', 'type':'string', 'default':''},\n" \
		"{'name':'chave1', 'type':'string', 'default':''},\n" \
		"{'name':'valor1', 'type':'string', 'default':''},\n" \
		"{'name':'default', 'type':'string', 'default':''}]}\n",
		parser_se
	},
	{
		"{'id':100, 'name':'bradesco', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'agencia', 'type':'string', 'default':''},\n" \
		"{'name':'conta', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_bradesco
	},
	{
		"{'id':101, 'name':'santander', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_santander
	},
	{
		"{'id':102, 'name':'bco_brasil', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_bb
	},
	{
		"{'id':103, 'name':'Linha2Barras', 'description':'Gera codigo de barras a partir da linha digitavel.', \n" \
		"'params':[\n" \
		"{'name':'codigo_barras', 'type':'string', 'default':''}]}\n",
		parser_linha2barras
	},
	{
		"{'id':104, 'name':'caixa', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'agencia', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_caixa
	},
	{
		"{'id':105, 'name':'itau', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'agencia', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_itau
	},
	{
		"{'id':106, 'name':'itau198', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'nro_documento', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_itau198
	},
	{
		"{'id':107, 'name':'panamericano', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'agencia', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_panamericano
	},
	{
		"{'id':108, 'name':'citibank', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_citi
	},
	{
		"{'id':109, 'name':'CEF sigcb', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_cef_sigcb
	},
	{
		"{'id':110, 'name':'Banco BGN', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'carteira', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_bgn
	},
	{
		"{'id':111, 'name':'Banco Real', 'description':'Gera linha digitavel e codigo de barras.', \n" \
		"'params':[\n" \
		"{'name':'agencia', 'type':'string', 'default':''},\n" \
		"{'name':'cod_cedente', 'type':'string', 'default':''},\n" \
		"{'name':'nosso_nro', 'type':'string', 'default':''},\n" \
		"{'name':'vencimento', 'type':'string', 'default':''},\n" \
		"{'name':'valor', 'type':'string', 'default':''},\n" \
		"{'name':'linha', 'type':'string', 'default':''}]}\n",
		parser_bgn
	},

	{NULL, NULL}
};


// ////////////////////////////////////////////////////////////
JSON_VALUE * parser_module_func_init()
{
	return(parser_compile_json_funcs(funcs));
}
// ////////////////////////////////////////////////////////////
void parser_module_func_finalize()
{
}
// ////////////////////////////////////////////////////////////



