#ifndef FILESYSTEM_H
#define FILESYSTEM_H

#include <ifractal.h>

#ifdef WIN32
#define PATH_SEPARATOR	'\\'
#else
#define PATH_SEPARATOR	'/'
#endif

typedef struct
{
	char path[BUFFER_LEN];
	DIR *dir;
} DIR_CONTEXT;


typedef enum
{
	FILE_TYPE_REGULAR,
	FILE_TYPE_DIR,
	FILE_TYPE_OTHER,
} FILE_TYPE;

typedef struct _FILE_CONTEXT FILE_CONTEXT;
struct _FILE_CONTEXT
{
	char *name;
	char *path;
	char *filename;
	time_t ctime;
	size_t size;
	FILE_TYPE type;
	FILE_CONTEXT *next;
};

FILE_CONTEXT * fs_file_new(char *path, char *name);
int fs_file_free(FILE_CONTEXT *);

int fs_file_get_content(FILE_CONTEXT *, _OUT uint8_t **content);
int fs_get_content(_IN FILE *, _OUT char **content);

int fs_file_check(FILE_CONTEXT *, _IN char *prefix, _IN char *suffix);

DIR_CONTEXT * fs_dir_new(char *path);
int fs_dir_free(DIR_CONTEXT *);

int fs_delete(char *filename);

typedef int (*FS_CALLBACK)(DIR_CONTEXT *, FILE_CONTEXT *, void *user_data);
int fs_dir_iter(DIR_CONTEXT *, FS_CALLBACK, void *user_data);


typedef int (*FS_SORT_CALLBACK)(FILE_CONTEXT *, FILE_CONTEXT *, void *user_data);
int fs_dir_sorted_iter(DIR_CONTEXT *, FS_CALLBACK, FS_SORT_CALLBACK, uint8_t descendent, void *user_data);

FILE_CONTEXT * fs_file_sort_context_new(FILE_CONTEXT *first, FILE_CONTEXT *current, FS_SORT_CALLBACK, uint8_t descendent, void *user_data);

int fs_dir_name_sorted_iter(DIR_CONTEXT *, FS_CALLBACK, uint8_t descendent, void *user_data);
int fs_dir_time_sorted_iter(DIR_CONTEXT *, FS_CALLBACK, uint8_t descendent, void *user_data);
int fs_dir_size_sorted_iter(DIR_CONTEXT *, FS_CALLBACK, uint8_t descendent, void *user_data);

typedef int (*PROC_LIST_CALLBACK)(char *name, int pid, int ppid, int qty_threads, void *user_data);
int fs_proc_iter(PROC_LIST_CALLBACK cb, void *user_data);

typedef enum
{
        MTAB_DEVICE,
        MTAB_DIRETORIO,
        MTAB_TIPO,
        MTAB_PERMISSOES,
        MTAB_LEN
} MTAB;

typedef int (*FS_HD_CALLBACK)(char *device, char *montagem, char *tipo, int total, int uso, int livre, void *user_data);
int fs_hd_iter(FS_HD_CALLBACK, void *user_data);

#endif
