#ifndef HENRY8X_H
#define HENRY8X_H

#include <ifractal.h>
#include <ifdevice.h>


// Codigo de evento /////////////////
#define IFDEVICE_AGUARDANDO		0
#define IFDEVICE_LIBERADO		1
#define IFDEVICE_GIRO			2
#define IFDEVICE_MASTER			3
#define IFDEVICE_ONLINE			4
#define IFDEVICE_ENTRADA		5
#define IFDEVICE_SAIDA			6

#define IFDEVICE_MENSAGEM		20
#define IFDEVICE_STATUS			21
#define IFDEVICE_VIOLACAO_INTERNA	22
#define IFDEVICE_VIOLACAO_EXTERNA	23

#define IFDEVICE_NEGADO			30
#define IFDEVICE_HORARIO_NEGADO		31
#define IFDEVICE_NEGADO_ACESSO		32
#define IFDEVICE_NEGADO_SENHA		33
#define IFDEVICE_NEGADO_SEQUENCIA	34
#define IFDEVICE_NEGADO_VALIDADE	35
#define IFDEVICE_NEGADO_SENTIDO		36

#define IFDEVICE_DESISTENCIA		90
#define IFDEVICE_BOTAO			95

#define IFDEVICE_PORTA_ABERTA		120
#define IFDEVICE_PORTA_FORCADA		121
#define IFDEVICE_PORTA_ARROMBADA	122

#define IFDEVICE_ALARME			140
// ///////////////////////////////////

// Direcao
#define HENRY8x_ENTRADA		1
#define HENRY8x_SAIDA		2

// Indicador de acesso
#define HENRY8x_NORMAL		0
#define HENRY8x_MASTER		1

// Tipo de leitor
#define IFDEVICE_NENHUMA		0
#define IFDEVICE_WIEGAND		1
#define IFDEVICE_ABATRACKII		2
#define IFDEVICE_BARRAS			3
#define IFDEVICE_TECLADO		4
#define IFDEVICE_PROXBARRAS		5
#define IFDEVICE_BIOMETRIA		6
#define IFDEVICE_MIFARE			7

enum {
	CSV8x_NSR, 
	CSV8x_COD_EVT, 
	CSV8x_MATRICULA, 
	CSV8x_DATA, 
	CSV8x_HORA, 
	CSV8x_SENTIDO, 
	CSV8x_TIPO, 
	CSV8x_LEITOR, 
	CSV8x_LEN 
};

typedef enum
{
	IFDEVICE_PRISMA,
	IFDEVICE_PRIMME_PONTO,
	IFDEVICE_PRIMME_ACESSO,
	IFDEVICE_ARGOS,
	IFDEVICE_SUPER_FACIL,
	IFDEVICE_VELTI,
	IFDEVICE_UNKNOWN,
	IFDEVICE_MODEL_LEN,
} IFDEVICE_MODEL;

typedef enum
{
	IFDEVICE_LOGIN,
	IFDEVICE_OFF,
	IFDEVICE_UPLOAD_GERAL,
	IFDEVICE_UPLOAD_BIO,
	IFDEVICE_PAGES_LEN,
} IFDEVICE_PAGES;

typedef struct
{
	char *url_format;
	char **post_list;
} IFDEVICE_WEB;

typedef enum
{
	HENRY_UNKNOWN, 
	HENRY_ARGOS, 
	HENRY_ACESSO, 
	HENRY_PONTO, 
	HENRY_TYPE_LEN
} HENRY_TYPE;

typedef enum
{
	HENRY_COD_ACESSO_NEGADO,
	HENRY_COD_ACESSO_LIBERADO,
	HENRY_COD_ACESSO_HORARIO,
	HENRY_COD_ACESSO_VALIDADE,
	HENRY_COD_ACESSO_CARTAO,
} HENRY_COD_ACESSO;

#define HENRY8x_SB	0x02
#define HENRY8x_EB	0x03

enum {H8x_SB, H8x_LLEN, H8x_HLEN, H8x_HEADER_LEN};
enum {H8x_CS, H8x_EB, H8x_TRAILER_LEN};

int henry8x_send(_IN IFDEVICE *, _IN unsigned char *pack, _IN int size);
int henry8x_recv(_IN IFDEVICE *, _OUT unsigned char **pack, _OUT int *err);

unsigned char henry8x_checksum(_IN unsigned char *data, _IN int data_len);
int henry8x_connect(IFDEVICE *);
int henry8x_close(IFDEVICE *);

int henry8x_get_config(IFDEVICE *);
int henry8x_get_empregador(IFDEVICE *);

HENRY_TYPE henry8x_getType(IFDEVICE *);

#endif
