#include <ifractal.h>

#ifdef WIN32
#include <process.h>
#else
#include <signal.h>
#include <setjmp.h>
#endif


#define TIMEOUT	2	// 2 segundo


// /////////////////////////////////////////////////////////////////////////////
int readLine(int fd, char *buf, int len)
{
	char *p = buf;
	int n;

	while (((n = read_timeout(fd, (void *) p, 1, 1)) >= 0) && ((p - buf) < len))
	{
		if (n == 0)
			continue;

		if (*p == '\r')
			*p = ' ';

		if (*p == '\n')
		{
			*(p + 1) = 0;
			return(p - buf + 1);
		} else
			p++;
	}

	return(-1);
}
// /////////////////////////////////////////////////////////////////////////////


// /////////////////////////////////////////////////////////////////////////////
int readln_timeout(int fd, char *buf, int len, int timeout)
{
	char *p = buf;
	int n, c = 0;

	while (((n = read_timeout(fd, (void *) p, 1, 0)) >= 0) && ((p - buf) < len))
	{
		if (n == 0)
		{
#ifdef WIN32
			Sleep(10);
#else
			usleep(1000*10);
#endif
			if (c++ <= (timeout * 100))
				continue;
			else
				break;
		}

		// TODO - 15/10/2019
		//if (*p == '\r')
		//	*p = ' ';

		if (*p == '\n')
		{
			*(p + 1) = 0;
			return(p - buf + 1);
		} else
			p++;
	}

	return(n);
}
// /////////////////////////////////////////////////////////////////////////////


// /////////////////////////////////////////////////////////////////////////////
int write_timeout(int nTcpSocket, const void *szBuff, int tamBuff, int time)
{
	int n = 0;
	int n_select;
	struct timeval timeout;
	fd_set fdwrite;  

	FD_ZERO(&fdwrite);
	FD_SET(nTcpSocket, &fdwrite);

	if (time >= 0)
	{
		timeout.tv_sec = time;
		timeout.tv_usec = 0;
		n_select = select(nTcpSocket + 1, (fd_set *)0, &fdwrite, (fd_set *)0, &timeout);
	} else
		n_select = 1;

	if(n_select < 0)
		return -1;

	//time out
	if(n_select == 0)
		return 0;

	if (FD_ISSET(nTcpSocket, &fdwrite))  
#ifdef WIN32
		if ((n = send(nTcpSocket, szBuff, tamBuff, 0)) < 0)
#else
		if ((n = write(nTcpSocket, szBuff, tamBuff)) < 0)
#endif
			return -1;

	return(n);
}
// /////////////////////////////////////////////////////////////////////////////


// /////////////////////////////////////////////////////////////////////////////
int read_timeout(int readfd, void *szBuff, int MaxRead, int time)
{
	int n = 0;
	int n_select;
	fd_set fdread;
	fd_set fd_exc;
	struct timeval timeout;

	FD_ZERO(&fdread);
	FD_ZERO(&fd_exc);
	FD_SET(readfd, &fdread);
	FD_SET(readfd, &fd_exc);

	if (time >= 0)
	{
		timeout.tv_sec = time;
		timeout.tv_usec = 0;
        	n_select = select(readfd + 1, &fdread, (fd_set *)0, &fd_exc, &timeout);
	} else
        	n_select = 1;

	// 0 - timeout
	// < 0 - erro
	if (n_select <= 0)
		  return(n_select);

	if (FD_ISSET(readfd, &fdread))
#ifdef WIN32
		if((n = recv(readfd, szBuff, MaxRead, 0)) <= 0)
#else
		if((n = read(readfd, (void *) szBuff, MaxRead)) <= 0)
#endif
			return -1;

	return(n);
}
// /////////////////////////////////////////////////////////////////////////////


#ifdef WIN32
HANDLE wmutex;

// /////////////////////////////////////////////////////////////////////////////
void connectTCP(SOCKET *lhSocket, char *hostname, char *port)
{
	LPHOSTENT lpHostEntry;
	SOCKADDR_IN lSockAddr;
	WSADATA wsaData;
	float socklib_ver;
	//struct hostent *hp;
	int lConnect;
	char *ip;
	
	if (WSAStartup(MAKEWORD(2,2),&wsaData) != 0)
	{
		verbose(stderr, "Socket Initialization Error. Program aborted\n");
		*lhSocket = -1;
		return;
	}

	socklib_ver = HIBYTE( wsaData.wVersion ) / 10.0;
	socklib_ver += LOBYTE( wsaData.wVersion );
	fprintf(stderr, "Versao do socket (%0.01f).\n", socklib_ver);
	
	memset(&lSockAddr,0, sizeof(lSockAddr));
	lSockAddr.sin_family = AF_INET;
	lSockAddr.sin_port = htons(atoi(port));

	if (inet_addr(hostname) == INADDR_NONE)
	{
		WaitForSingleObject( wmutex, INFINITE );
		lpHostEntry = gethostbyname(hostname);
		ReleaseMutex(wmutex);
		if (lpHostEntry == NULL)
		{
			fprintf(stderr, "Erro: gethostbyname(\"%s\")\n", hostname);
			*lhSocket = -1;
			return;
		}

		ip = inet_ntoa(*((LPIN_ADDR)*lpHostEntry->h_addr_list));
		lSockAddr.sin_addr.s_addr = inet_addr(ip);
	}
	else
	{
		lSockAddr.sin_addr.s_addr = inet_addr(hostname);
	}

	*lhSocket = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	if(*lhSocket == INVALID_SOCKET)
	{
		fprintf(stderr, "Invalid Socket\n");
		*lhSocket = -1;
		return;
	}
	      
	lConnect = connect(*lhSocket,(SOCKADDR *)&lSockAddr,sizeof(SOCKADDR_IN));
	if(lConnect == SOCKET_ERROR)
	{
		//verbose(stderr, "Connect Error. Program aborted\n");
		return;
	}
	
	return;
}



#define THREAD_STACK_SIZE  0

struct thread_data 
{
	SOCKET *sock;
	char *h;
	char *p;
	DWORD ws_error;
};


static unsigned _stdcall thread_helper (void *arg)
{
	struct thread_data *td = (struct thread_data *) arg;

	/* Initialize Winsock error to what it was in the parent.  That way
	   the subsequent call to WSAGetLastError will return the same value
	   if td->fun doesn't change Winsock error state.  */
	WSASetLastError (td->ws_error);

	connectTCP(td->sock, td->h, td->p);

	/* Return Winsock error to the caller, in case FUN ran Winsock code.  */
	td->ws_error = WSAGetLastError ();

	_endthreadex(0);
	return 0; 
}


int openTCP (char *hostname, char *port, int timeout)
{
	HANDLE thread_hnd = NULL;
	struct thread_data thread_arg;
	unsigned thread_id;
	int ret = -1;

	/* Should never happen, but test for recursivety anyway */
	//assert (thread_hnd == NULL);  
	
	thread_arg.sock = (SOCKET *) &ret;
	thread_arg.h = hostname;
	thread_arg.p = port;
	thread_arg.ws_error = WSAGetLastError ();
	//thread_hnd = CreateThread (NULL, THREAD_STACK_SIZE, thread_helper, &thread_arg, 0, &thread_id); 
	thread_hnd = (HANDLE) _beginthreadex(NULL, 0, thread_helper, &thread_arg, 0, &thread_id);
	if (thread_hnd == 0)
	{
		//DEBUGP (("CreateThread() failed; %s\n", strerror (GetLastError ())));
		return(-1);
	}

	wmutex = CreateMutex(NULL, FALSE, NULL);

	if (WaitForSingleObject (thread_hnd, INFINITE) == WAIT_OBJECT_0)
	{
		/* Propagate error state (which is per-thread) to this thread,
		so the caller can inspect it.  */
	} else
	{
		// TerminateThread (thread_hnd, 1);
		fprintf(stderr, "connect timeout\n");
		ret = -1;
	}
		
	WSASetLastError (thread_arg.ws_error);
	if (WSAGetLastError() != 0)
	{
		fprintf (stderr, "Winsock error: %d\n", WSAGetLastError ());
		if_closesocket(ret);
		ret = -1;
	}

	CloseHandle (thread_hnd);
	CloseHandle (wmutex);
	thread_hnd = NULL;
	
	return(ret);
}
// /////////////////////////////////////////////////////////////////////////////
#else
// /////////////////////////////////////////////////////////////////////////////
int openTCP (char *hostname, char *port, int timeout)
{
	struct sockaddr_in sa; 
	struct hostent *hp;
	int portnum = atoi(port);
	int s, to;

	// Quando timeout == -1 - fica bloqueado "para sempre" == 1 hora
	if (timeout < 0)
		timeout = 3600;

	memset(&sa, 0, sizeof(sa));

	if ((hostname[0] <= '9') || ((hp = gethostbyname(hostname)) == NULL))
		sa.sin_addr.s_addr = inet_addr(hostname);
	else 
		memcpy((char *) &sa.sin_addr, hp->h_addr, hp->h_length);
		
	sa.sin_family = AF_INET; 
	sa.sin_port = htons((u_short)portnum);

	// Ignora FD 0 
	while ((s = socket(AF_INET, SOCK_STREAM, 0)) == 0)
		;

	if (s < 0)
		return(-1); 

	if (fcntl(s, F_SETFL, O_NONBLOCK) < 0)
	{
		close(s);
		return(-2); 
	}

	for (to = timeout*1000 ; (connect(s,(struct sockaddr *)&sa,sizeof sa) == -1)&&(errno != EISCONN)&&(to > 0) ; to--)
	{
		if ( errno == EFAULT )
		{
			close(s);	
			return(-3);
		}
		usleep(1000);
	}

	// Timeout
	if (to <= 0)
	{
		close(s);
		return(0);
	}

	return(s); 
}
// /////////////////////////////////////////////////////////////////////////////

// /////////////////////////////////////////////////////////////////////////////
int init_fds_and_find_maxfd1(int *fds, int len, fd_set *rset)
{
	int i, max;

	FD_ZERO(rset);
	for (i = 0, max = -1 ; i < len ; i++)
	{
		FD_SET(fds[i], rset);

		if (fds[i] > max)
			max = fds[i];
	}

	return(max + 1);
}
// /////////////////////////////////////////////////////////////////////////////
int accept_pool(int fds[], int fds_len, int timeout, struct sockaddr *cli_addr, int *cli_len)
{
	struct timeval tv;
	fd_set rset;
	int maxfd1, rs, i;

	maxfd1 = init_fds_and_find_maxfd1(fds, fds_len, &rset);

	if (timeout >= 0)
	{
		tv.tv_sec = timeout;
		tv.tv_usec = 0;

		rs = select(maxfd1, &rset, NULL, NULL, &tv);
	}
	else
	{
		rs = select(maxfd1, &rset, NULL, NULL, NULL);
	}

	if (rs <= 0)
		return(rs);
		
	for (i = 0 ; (i < MAXQTYFD) && (fds[i] >= 0) ; i++)
		if (FD_ISSET(fds[i], &rset))
			return(accept(fds[i], cli_addr, (unsigned int *) cli_len));

	return(-1);
}
// /////////////////////////////////////////////////////////////////////////////
#endif



// /////////////////////////////////////////////////////////////////////////////
int accept_timeout(int serversock, int time, struct sockaddr *cli_addr, int *cli_len)
{
	struct timeval timeout;
	int n_select;
	fd_set fdread;

	FD_ZERO(&fdread);
	FD_SET(serversock, &fdread);

	if (time >= 0)
	{
		timeout.tv_sec = time;
		timeout.tv_usec = 0;
	
		n_select = select(serversock + 1, &fdread, (fd_set *)0, (fd_set *)0, &timeout);
	} else
		n_select = 1;

	if(n_select < 0)
		return(-1);

	//time out
	if(n_select == 0)
		return(0);

	if(FD_ISSET(serversock, &fdread))
#ifdef WIN32
		return accept(serversock, cli_addr, cli_len);
#else
		return accept(serversock, cli_addr, (unsigned int *) cli_len);
#endif
	
	return(-1);
}
// /////////////////////////////////////////////////////////////////////////////


// /////////////////////////////////////////////////////////////////////////////
int openServerTCP(char *port)
{
	struct sockaddr_in serv_addr;

	// abrindo o TCP socket
#ifdef WIN32
	SOCKET ssock;
	WSADATA wsaData;
	BOOL bOptVal = TRUE;
	int r;

	WSAStartup(MAKEWORD(2,2), &wsaData);
	
	// Bind local address
	memset( &serv_addr, 0, sizeof(struct sockaddr_in) );
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(atoi(port));

	if ((ssock = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
	{
		r = WSAGetLastError();
		verbose(stderr, "socket error: %d\n", r);
		return(-1);
	}

	if (setsockopt(ssock, SOL_SOCKET, SO_REUSEADDR, (char *) &bOptVal, sizeof(bOptVal)) == SOCKET_ERROR) 
	{
		r = WSAGetLastError();
		verbose(stderr, "setsockopt error: %d\n", r);
		return(-2);
	}

	if ( bind( ssock, (struct sockaddr *) &serv_addr, sizeof(struct sockaddr_in) ) == SOCKET_ERROR )
	{
		r = WSAGetLastError();
		verbose(stderr, "bind error: %d\n", r);
		return(-3);
	}

	if (listen(ssock, SOMAXCONN) == SOCKET_ERROR )
	{
		r = WSAGetLastError();
		verbose(stderr, "listen error: %d\n", r);
		return(-4);
	}

#else
	int ssock;
	int reuse = 1;
	
	// Bind local address
	memset((char *) &serv_addr, 0, sizeof(struct sockaddr_in));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	serv_addr.sin_port = htons(atoi(port));
	if ((ssock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
		return(-1);

	if (setsockopt(ssock, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(reuse)) < 0) 
		return(-2);
	
	if (bind(ssock, (struct sockaddr *) &serv_addr, sizeof(struct sockaddr_in)) < 0)
		return(-3);

	if (listen(ssock, SOMAXCONN) != 0)
		return(-4);
#endif
	
	return(ssock);
}
// ////////////////////////////////////////////////////////////////////////// //


// ////////////////////////////////////////////////////////////////////////// //
int send_bytes(int sock, void *data, int qtd, int timeout)
{
	unsigned char *buf = (unsigned char *) data;
	unsigned char *p;
	int n, to;

	if (qtd <= 0)
		return(qtd);
	
	for (p = buf, to = 0 ; (p - buf) < qtd ; p += n)
	{
		n = write_timeout(sock, p, qtd - (p - buf), 0);
		if (n == 0)
		{
			if_sleep(100);
			to++;
			if (to > (10 * timeout))
				break;
		}

		if (n < 0)
		{
			return(-1);
		}
	}

	return(p - buf);
}
// ////////////////////////////////////////////////////////////////////////// //


// ////////////////////////////////////////////////////////////////////////// //
int read_bytes(int sock, void *ptr, int qtd, int timeout)
{
	unsigned char *buf = (unsigned char *) ptr;
	unsigned char *p;
	int n, to;
	
	for (p = buf, to = 0 ; (p - buf) < qtd ; p += n)
	{
		n = read_timeout(sock, p, qtd - (p - buf), 0);
		if (n == 0)
		{
#ifdef WIN32
			Sleep(100);
#else
			usleep(100 * 1000);	// decimo de segundo
#endif
			to++;
			if (to > (10 * timeout))
				break;
		}

		if (n < 0)
		{
			return(-1);
		}
	}

	return(p - buf);
}
// ////////////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int if_broadcast(char *port, void *data, int len)
{
	int sock;
	int optval, optlen;
	struct sockaddr_in server;
	struct hostent *server_data;
#ifdef WIN32
	WSADATA wsaData;
	WSAStartup(0x101, &wsaData);
#endif

	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
		verbose(stderr, "Falha ao tentar iniciar broadcast\n");
		return(-1);
	}

	 optval = 1;
	 optlen = sizeof(optval);
	 if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, (char *) &optval, optlen) == -1)
	 {
	 	verbose(stderr, "ERROR: set SO_BROADCAST\n");
		return(-2);
	} 

	if((server_data = gethostbyname("255.255.255.255")) == 0)
	{
		verbose(stderr, "Erro gethostbyname\n");
		return(-3);
	}
	memcpy(&server.sin_addr,server_data->h_addr, server_data->h_length);
	
	server.sin_family = AF_INET;
	server.sin_port = htons(atoi(port));

	if (sendto(sock, data, len, 0, (struct sockaddr *) &server, sizeof(server)) < 0)
	{
		verbose(stderr, "Erro no envio de broadcast.\n");
		return(-4);
	}

	if_closesocket(sock);
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //



// ////////////////////////////////////////////////////////////////////////
int openServerUDP(char *port)
{
	int sockfd;
	struct sockaddr_in my_addr;

#ifdef WIN32
	WSADATA wsaData;
	WSAStartup(MAKEWORD(2,2), &wsaData);
#endif

	if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
	{
		fprintf(stderr, "Erro ao tentar abrir UDP PORT:%s\n", port);
		return(-1);
	}

	my_addr.sin_family = AF_INET;
	my_addr.sin_port = htons(atoi(port));
	my_addr.sin_addr.s_addr = INADDR_ANY;
	memset(my_addr.sin_zero, '\0', sizeof my_addr.sin_zero);

	bind(sockfd, (struct sockaddr *) &my_addr, sizeof(my_addr));

	return(sockfd);
}
// ////////////////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////////////////
int if_closesocket(int sock)
{
	int ret;

	if (sock == 0)
		return(-1);

#ifdef WIN32
	ret = closesocket(sock);
	switch (ret)
	{
		case WSANOTINITIALISED: 
			verbose(stderr, "closesocket - A successful WSAStartup call must occur before using this function.\n");
			break;

		case WSAENETDOWN:
			verbose(stderr, "closesocket - The network subsystem has failed.\n");
			break;

		case WSAENOTSOCK:
			verbose(stderr, "closesocket - The descriptor is not a socket.\n");
			break;

		case WSAEINPROGRESS:
			verbose(stderr, "closesocket - A blocking Windows Sockets 1.1 call is in progress, or the service provider is still processing a callback function.\n");
			break;

		case WSAEINTR:
			verbose(stderr, "closesocket - The (blocking) Windows Socket 1.1 call was canceled through WSACancelBlockingCall.\n");
			break;

		case WSAEWOULDBLOCK:
			verbose(stderr, "closesocket - The socket is marked as nonblocking, but the l_onoff member of the linger structure is set to non-zero and the l_linger member of the linger structure is set to a nonzero timeout value.\n");
			break;
	}
	
	//WSACleanup();
#else
	ret = close(sock);
#endif
	return(ret);
}
// ////////////////////////////////////////////////////////////////////////



#ifdef DEBUG_NET
int main(int argc, char **argv)
{
	int sock, n;
	char buf[1000];

	if (argc < 3)
	{
		fprintf(stderr, "Use:\nshell$ %s <HOST> <PORT>\n", argv[0]);
		return(1);
	}

	for (n = 0 ; n < 20 ; n++)
	{
		sock = openTCP(argv[1], argv[2], 2);
		if (sock == 0)
			fprintf(stderr, "timeout...\n");

		if (sock > 0)
			break;
	}

	if (sock <= 0)
	{
		fprintf(stderr, "Erro ao tentar acessar %s:%s\n", argv[1], argv[2]);
		return(3);
	}

	n = snprintf(buf, 1000, "GET / HTTP1.0\r\n\r\n");
	n = send_bytes(sock, buf, n, -1);
	fprintf(stdout, "%d bytes enviados.\n", n);
	
	fprintf(stdout, "le dados\n");
	while ((n = read_timeout(sock, buf, 1000, 10)) >= 0)
	{
		fprintf(stdout, "%d bytes lidos\n", n);
	}
	fprintf(stdout, "fim\n");

	if_closesocket(sock);

	return(0);
}
#endif

