#ifndef SCHED_H
#define SCHED_H

#include <ifractal.h>
#include <modXXXXload.h>

typedef enum
{
	SCHED_TYPE_PROC,
	SCHED_TYPE_URL,
	SCHED_TYPE_DELETE,
	SCHED_TYPE_UPLOAD,
	SCHED_TYPE_LEN,
} SCHED_TYPE;

enum
{
	PERIOD_MIN,
	PERIOD_HOUR,
	PERIOD_DAY,
	PERIOD_MONTH,
	PERIOD_DWEEK,
	PERIOD_LEN,
};

typedef enum 
{
	SCHED_PERIOD_FREQ, 
	SCHED_PERIOD_FIXED,
	SCHED_PERIOD_NONE
} SCHED_PERIOD_TYPE;


typedef struct
{
	SCHED_TYPE type;
	SCHED_PERIOD_TYPE period_type;
	char name[PATH_LEN];
	union
	{
		int cron[PERIOD_LEN];
		int frequency;
	};
	time_t last;
} SCHED;

typedef struct _EXTENDS(SCHED)
{
	SCHED sched;
	char proc[PATH_LEN];
	char path[PATH_LEN];
	char *args[PATH_LEN];
} SCHED_PROC;

typedef struct _EXTENDS(SCHED)
{
	SCHED sched;
	char url[PATH_LEN];
	char path[PATH_LEN];
	char *post_list[PATH_LEN];
} SCHED_URL;

typedef struct _EXTENDS(SCHED)
{
	SCHED sched;
	char path[PATH_LEN];
	char prefix[PATH_LEN];
	char suffix[PATH_LEN];
	int days;
} SCHED_DELETE;

typedef struct _EXTENDS(SCHED)
{
	SCHED sched;
	JSON_VALUE *jconfig;
} SCHED_UPLOAD;


SCHED * sched_delete_new(_IN char *path, _IN char *prefix, _IN char *suffix, _IN int days);

SCHED * sched_proc_new_cron(_IN char *cron_string, _IN char *proc, _IN char *path, _IN char **args);
SCHED * sched_url_new_cron(_IN char *cron_string, _IN char *url, _IN char *path, _IN char **post_list);

SCHED * sched_proc_new_freq(_IN int freq, _IN char *proc, _IN char *path, _IN char **args);
SCHED * sched_url_new_freq(_IN int freq, _IN char *url, _IN char *path, _IN char **post_list);

SCHED * sched_upload_new(_IN JSON_VALUE *);

void sched_free(SCHED *);

SCHED * sched_new_json(_IN JSON_VALUE *);
VETOR * sched_load_jobs(char *config_json);
void sched_verbose(VETOR *jobs);

int sched_check(SCHED *);
int sched_execute(SCHED *);
int sched_clean(_IN VETOR *);

#endif
