#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "if_vetor.h"



// ////////////////////////////////////////////////////////////
VETOR * vetor_new()
{
	VETOR *vetor;

	vetor = malloc(sizeof(VETOR));
	memset(vetor, 0, sizeof(VETOR));

	vetor->max = 2;
	vetor->vetor = malloc(vetor->max * sizeof(void *));

	return(vetor);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void vetor_free(VETOR *vetor)
{
	if (vetor == NULL)
		return;

	free(vetor->vetor);
	free(vetor);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_resize(VETOR *vetor)
{
	vetor->max *= 2;
	vetor->vetor = realloc(vetor->vetor, vetor->max * sizeof(void *));

	return(vetor->max);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_push(VETOR *vetor, void *data)
{
	if (vetor == NULL)
		return(vetor->length);

	if (vetor->length >= vetor->max)
		vetor_resize(vetor);

	vetor->vetor[vetor->length++] = data;

	return(vetor->length); 
}
// ////////////////////////////////////////////////////////////
void * vetor_pop(VETOR *vetor)
{
	if (vetor == NULL)
		return(NULL);

	vetor->length--;

	return(vetor->vetor[vetor->length]);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void * vetor_get_index(VETOR *vetor, int index)
{
	if ((vetor == NULL) || (index >= vetor->length) || (index < 0))
		return(NULL);
	
	return(vetor->vetor[index]);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void * vetor_remove_index(VETOR *vetor, int index)
{
	void *elem;
	int i;

	if ((vetor == NULL) || (index >= vetor->length) || (index < 0))
		return(NULL);

	elem = vetor->vetor[index];

	for (i = index ; (i + 1) < vetor->length ; i++)
		vetor->vetor[i] = vetor->vetor[i + 1];

	vetor->length--;

	return(elem);
}
// ////////////////////////////////////////////////////////////
int vetor_remove(VETOR *vetor, void *elem)
{
	int i, q;

	for (q = 0, i = 0 ; i < vetor->length ; )
	{
		if (vetor->vetor[i] != elem)
		{
			i++;
			continue;
		}

		vetor_remove_index(vetor, i);
		q++;
	}

	return(q);
}
// ////////////////////////////////////////////////////////////
int vetor_remove_all(VETOR *vetor)
{
	int l = vetor->length;

	vetor->length = 0;

	return(l);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_prepend(VETOR *vetor, void *data)
{
	int i;

	if (vetor == NULL)
		return(vetor->length);

	if (vetor->length >= vetor->max)
		vetor_resize(vetor);

	for (i = vetor->length ; i > 0 ; i--)
		vetor->vetor[i] = vetor->vetor[i - 1];

	vetor->vetor[0] = data;

	vetor->length++;

	return(vetor->length); 
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_insert(VETOR *vetor, int index, void *data)
{
	int i;

	if ((vetor == NULL) || (index > vetor->length) || (index < 0))
		return(vetor->length);

	if (vetor->length >= vetor->max)
		vetor_resize(vetor);

	for (i = vetor->length ; i > index ; i--)
		vetor->vetor[i] = vetor->vetor[i - 1];

	vetor->vetor[index] = data;

	vetor->length++;

	return(vetor->length);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_length(VETOR *vetor)
{
	return(vetor->length);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
int vetor_iter(VETOR *vetor, VETOR_ITER_CALLBACK cb, void *user_data)
{
	int i;

	if (vetor == NULL)
		return(-1);

	for (i = 0 ; i < vetor->length ; i++)
		if (cb(vetor, i, vetor->vetor[i], user_data))
			break;

	return(i);
}
// ////////////////////////////////////////////////////////////


