#ifndef IF_VETOR_H
#define IF_VETOR_H

#include <stdio.h>

typedef struct
{
        int max;
        int length;
        void **vetor;
} VETOR;

VETOR * vetor_new();
int vetor_length(VETOR *);
void vetor_free(VETOR *);
int vetor_prepend(VETOR *, void *);
int vetor_push(VETOR *, void *);
void * vetor_pop(VETOR *);
void * vetor_get_index(VETOR *, int index);
int vetor_insert(VETOR *, int index, void *data);
void * vetor_remove_index(VETOR *, int index);
int vetor_remove(VETOR *, void *);
int vetor_remove_all(VETOR *);

typedef int (*VETOR_ITER_CALLBACK)(VETOR *, int index, void *data, void *user_data);
int vetor_iter(VETOR *, VETOR_ITER_CALLBACK, void *user_data);

#endif
