#include <ifractal.h>
#include <ifdevice.h>

#define MODULE	"IFPONTO"
#define verbose3(ref,def,format,...)	verbose2(ref,def,stdout,MODULE,format, ##__VA_ARGS__)

extern char *IFPONTO_IDs[];
extern IF_GETOPT scanner_configs[];
extern char *BIO_vendor_encode[][2];


// ///////////////////////////////////////////////////////////////////// //
int ifdevice_drawBWLine(uint8_t *img, size_t width, size_t height, int xi, int yi, int xf, int yf, uint32_t pattern)
{
	double x1 = xi;
	double y1 = yi;
	double x2 = xf;
	double y2 = yf;
	double l = abs(x2 - x1) + abs(y2 - y1);
	double dx = (x2 - x1) / l;
	double dy = (y2 - y1) / l;
	double t;
	int x, y, p;
	int len = width * height;
	int b = 1;

	for (t = 0 ; t < l ; t++, b++)
	{
		x = (int) (t * dx + x1);
		y = (int) (t * dy + y1);
		p = y * width + x;

		if ((p < 0) || (p > len))
			continue;

		if (pattern & (1 << (b % 32)))
			img[p] = 0xFF;
		else
			img[p] = 0;
	}

	return(t);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int scanner_get_image_filename(char *path, char *filename, size_t len, char *id, int finger, int count)
{
	int n = 0;

	n = snprintf(filename, len, "%s%c%s_%d_%d.png", path, PATH_SEPARATOR, id, finger, count);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_get_template_filename(char *path, char *filename, size_t len, char *id, int finger)
{
	int n = 0;

	n = snprintf(filename, len, "%s%c%s_%d%s", path, PATH_SEPARATOR, id, finger, TEMPLATE_SUFFIX);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int ifdevice_addResult(JSON_VALUE *reg, JSON_VALUE *res, char *msg, int err)
{
	JSON_VALUE *evt = json_object_new(1);
	char *cod = json_object_get_string(reg, "cod");
	char *codigo = json_object_get_string(reg, "codigo");
	char *nome = json_object_get_string(reg, "nome");
	time_t now = time(NULL);
	char aux[PATH_LEN];
	struct tm *dt;

	dt = localtime(&now);
	snprintf(aux, sizeof(aux), "%04d-%02d-%02d %02d:%02d:%02d", 
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, dt->tm_hour, dt->tm_min, dt->tm_sec);

	json_object_add(evt, "datahora", json_string_new(aux));

	json_object_add(evt, "cod", json_string_new(cod));
	json_object_add(evt, "nome", json_string_new(nome));
	json_object_add(evt, "codigo", json_string_new(codigo));
	json_object_add(evt, "status", json_string_new(msg));
	json_object_add(evt, "cod_error", json_integer_new(err));
	json_array_add(res, evt);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int ifdevice_web_server(char *port)
{
	struct sockaddr_in cli_addr;
	int sock, clilen, ssock;

	ssock = openServerTCP(port);
	if (ssock < 0)
	{
		verbose(stderr, "*** Porta %s nao disponivel. ***\n", port);
		return(2);
	}
	
	while (1)
	{
		clilen = sizeof(struct sockaddr);
		sock = accept_timeout(ssock, 0, (struct sockaddr *) &cli_addr, &clilen);
		if (sock <= 0)
			break;

		//snprintf(req->ip, IP_LEN, "%s", inet_ntoa(cli_addr.sin_addr));
		//if_thread_add(context->th_list, web_launcher, context->thread_id++, data);

		// TODO
		// headers
	}

	if_closesocket(ssock);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
char * ifdevice_getID(JSON_VALUE *juser)
{
	if ((juser == NULL) || (json_get_type(juser) != JSON_OBJECT_TYPE))
		return("");

	char *id;
	int k;

	for (k = 0 ; IFPONTO_IDs[k] != NULL ; k++)
	{
		id = json_object_get_string(juser, IFPONTO_IDs[k]);
		if (id[0] != 0)
			return(id);
	}

	return("");
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int scanner_load(SCANNER *scan)
{
	char *name = json_object_get_string(scan->dev.config, "lib");
	char filename[PATH_LEN];
	char *ext;
	LIB_BIND funcs[] = {
		{(void (**)()) &(scan->init), "ifdevice_init"},
		{NULL, NULL}
	};

#ifdef WIN32
	ext = ".dll";
#elif __linux__
	ext = ".so";
#elif __APPLE__
	ext = ".dylib";
#endif

	snprintf(filename, PATH_LEN, "bin%c%s%s", PATH_SEPARATOR, name, ext);

	LIB_API api;
	api.bind = funcs;
	int ret = if_libloader(filename, &api);
	scan->lib_handle = (intptr_t) api.handle;

	return(ret);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER * IFPONTO_SCANNER_new_in(JSON_VALUE *jinfo, SCANNER_TEMPLATE_CALLBACK tcb, SCANNER_IMAGE_CALLBACK icb, SCANNER_MESSAGE_CALLBACK mcb)
{
	SCANNER *scan;
	int r;

	if ((mcb == NULL) || (tcb == NULL) || (icb == NULL))
		return(NULL);

	scan = if_malloc(sizeof(SCANNER));
	memset(scan, 0, sizeof(SCANNER));
	
	scan->dev.config = json_clone(jinfo);

	r = scanner_load(scan);
	if (r)
	{
		json_value_free(scan->dev.config);
		if_free(scan);
		return(NULL);
	}

	scan->template_callback = tcb;
	scan->image_callback = icb;
	scan->message_callback = mcb;

	return(scan);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER * IFPONTO_SCANNER_new(JSON_VALUE *jinfo, SCANNER_TEMPLATE_CALLBACK tcb, SCANNER_IMAGE_CALLBACK icb, SCANNER_MESSAGE_CALLBACK mcb)
{
	SCANNER *scan = IFPONTO_SCANNER_new_in(jinfo, tcb, icb, mcb);
	if (scan != NULL)
	{
		scan->init(scan);
	}

	return(scan);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER * IFPONTO_SCANNER_new_with_hwnd(
	JSON_VALUE *jinfo, 
	intptr_t hwnd, 
	SCANNER_TEMPLATE_CALLBACK tcb, 
	SCANNER_IMAGE_CALLBACK icb, 
	SCANNER_MESSAGE_CALLBACK mcb)
{
	SCANNER *scan = IFPONTO_SCANNER_new_in(jinfo, tcb, icb, mcb);
	if (scan != NULL)
	{
		scan->hwnd = hwnd;
		scan->init(scan);
	}

	return(scan);
}
// ///////////////////////////////////////////////////////////////////// //
void IFPONTO_SCANNER_free(SCANNER *scan)
{
	if (scan == NULL)
		return;

	scan->finalize(scan);
	json_value_free(scan->dev.config);

	if (scan->device != NULL)
		if_free(scan->device);

#ifdef WIN32
	FreeLibrary((HMODULE) scan->lib_handle);
#else
	dlclose(scan->lib_handle);
#endif

	if_free(scan);
}
// ///////////////////////////////////////////////////////////////////// //

#ifdef WITH_PNG
// ///////////////////////////////////////////////////////////////////// //
int ifdevice_BW8_to_PNG(SCANNER *scan, uint8_t *img, int width, int height, PNG_WRITE_CALLBACK cb, void *user_data)
{
	int code = 0;
	png_structp png_ptr = NULL;
	png_infop info_ptr = NULL;
	png_bytep row = NULL;

	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if (png_ptr == NULL)
	{
		fprintf(stderr, "Could not allocate write struct\n");
		code = 1;
		goto writePNG_end;
	}

	info_ptr = png_create_info_struct(png_ptr);
	if (info_ptr == NULL)
	{
		fprintf(stderr, "Could not allocate info struct\n");
		code = 2;
		goto writePNG_end;
	}

	//png_init_io(png_ptr, fp);
	png_set_write_fn(png_ptr, user_data, cb, NULL);

	png_set_IHDR(png_ptr, info_ptr, width, height,
			8, PNG_COLOR_TYPE_GRAY, PNG_INTERLACE_NONE,
			PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

	// TODO - inserir titulo
	png_text title_text;
	title_text.compression = PNG_TEXT_COMPRESSION_NONE;
	title_text.key = "Title";
	title_text.text = "iFractal SIIN";
	png_set_text(png_ptr, info_ptr, &title_text, 1);

	png_write_info(png_ptr, info_ptr);

	row = (png_bytep) if_malloc(width * sizeof(png_byte));

	int x, y;
	for (y = 0 ; y < height ; y++)
	{
		for (x = 0 ; x < width ; x++)
		{
			row[x] = img[y * width + x];
		}
		png_write_row(png_ptr, row);
	}

	png_write_end(png_ptr, NULL);

writePNG_end:
	if (info_ptr != NULL)
		png_free_data(png_ptr, info_ptr, PNG_FREE_ALL, -1);

	if (png_ptr != NULL)
		png_destroy_write_struct(&png_ptr, (png_infopp) NULL);

	if (row != NULL)
		if_free(row);

	return code;
}
// ///////////////////////////////////////////////////////////////////// //
#endif

// ///////////////////////////////////////////////////////////////////// //
int ifdevice_get_password_hash(char *pass)
{
	int seq[] = {3, 5, 11, 61, 133, 7, 13, 23};
	int len = sizeof(seq) / sizeof(int);
	int hash = 0;

	if ((pass == NULL) || (pass[0] == 0))
		return(0);

	for (int i = 0 ; pass[i] != 0 ; i++)
		hash += pass[i] * seq[i % len]; 

	return(hash);
}
// ///////////////////////////////////////////////////////////////////// //


// Implementacao //////////////////////////////////////////////////////// //
// ///////////////////////////////////////////////////////////////////// //
int scanner_file_getUsers_iter(DIR_CONTEXT *dir, FILE_CONTEXT *fctx, void *user_data)
{
	void **ctx = (void **) user_data;
	int *qty = (int *) ctx[0];
	JSON_VALUE *jusers = (JSON_VALUE *) ctx[1];
	JSON_VALUE *jtemplates;
	//JSON_VALUE *jtemplates = (JSON_VALUE *) ctx[2];
	//char *last_id = (char *) ctx[3];
	char *vendor = (char *) ctx[4];
	JSON_VALUE *juser, *jtemp;
	int finger = 0;
	char buf[50];
	char *id = buf;
	char *tk[4];
	int n;

	if (!fs_file_check(fctx, "", TEMPLATE_SUFFIX))
		return(0);

	n = snprintf(buf, sizeof(buf), "%s", fctx->name);
	n = tokenizer('_', buf, tk, 4);

	if (n < 2)
		return(0);

	id = tk[0];
	finger = atoi(tk[1]);

	juser = json_object_new(1);
	json_array_add(jusers, juser);

	jtemplates = json_array_new(1);
	json_object_add(juser, "templates", jtemplates);
	json_object_add(juser, "id", json_string_new(id));

	jtemp = json_object_new(1);
	json_array_add(jtemplates, jtemp);

	json_object_add(jtemp, "finger", json_integer_new(finger));
	json_object_add(jtemp, "vendor", json_string_new(vendor));

	*qty += 1;

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * scanner_file_getUsers(IFDEVICE4J *dev4j, char *vendor)
{
	SCANNER *scan = (SCANNER *) dev4j;
	char *path = json_object_get_string(scan->dev.config, "path");
	JSON_VALUE *jusers = json_array_new(1);
	DIR_CONTEXT *dir;
	int qty = 0;

	dir = fs_dir_new(path);
	if (dir == NULL)
		return(jusers);

	// TODO
	void *ctx[] = {&qty, jusers, NULL, NULL, vendor};
	fs_dir_iter(dir, scanner_file_getUsers_iter, ctx);
	fs_dir_free(dir);

	return(jusers);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_file_sendBio_template_iter(JSON_VALUE *jtemp, void *user_data)
{
	void **ctx = (void **) user_data;
	SCANNER *scan = (SCANNER *) ctx[0];
	JSON_VALUE *jres = (JSON_VALUE *) ctx[1];
	JSON_VALUE *juser = (JSON_VALUE *) ctx[2];
	char *id = (char *) ctx[3];
	int *i = (int *) ctx[4];
	char *VENDOR = (char *) ctx[5];
	char *path = json_object_get_string(scan->dev.config, "path");
	char *temp = json_object_get_string(jtemp, "template");
	char *vendor = json_object_get_string(jtemp, "vendor");
	char *encode = json_object_get_string(jtemp, "encode");
	char filename[PATH_LEN];
	unsigned char *bio;
	char msg[PATH_LEN];
	uint32_t len;
	FILE *fd;

	if (strcmp(vendor, VENDOR) != 0)
		return(0);

	if (encode[0] == 0)
	{
		encode = TXT_ENCODE_B64;
		for (int k = 0 ; BIO_vendor_encode[k][0] != NULL ; k++)
		{
			if (strcmp(BIO_vendor_encode[k][0], vendor) == 0)
			{
				encode = BIO_vendor_encode[k][1];
				break;
			}
		}
	}

	scanner_get_template_filename(path, filename, PATH_LEN, id, *i);
	fd = fopen(filename, "wb");
	if (fd == NULL)
	{
		snprintf(msg, PATH_LEN, "Falha ao tentar gravar: '%s' - ID: %s", filename, id);
		ifdevice_addResult(juser, jres, msg, 3);
		return(0);
	}

	len = if_str_decoder(temp, &bio, encode);
	if ((len > 0) && (bio != NULL))
	{
		fwrite(bio, len, 1, fd);
		if_free(bio);
	}

	fclose(fd);

	snprintf(msg, PATH_LEN, "Biometria gravada: '%s' - ID: %s", filename, id);
	ifdevice_addResult(juser, jres, msg, 0);

	*i += 1;

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_file_sendBio_iter(JSON_VALUE *juser, void *user_data)
{
	char *id = ifdevice_getID(juser);
	JSON_VALUE *jtemplates = json_object_find(juser, "templates");
	int i = 1;
	void **ctx = (void **) user_data;
	JSON_VALUE *jres = (JSON_VALUE *) ctx[1];
	ctx[2] = juser;
	ctx[3] = id;
	ctx[4] = &i;

	if (id[0] == 0)
	{
		ifdevice_addResult(juser, jres, "ID (id|pis|cracha|matricula|codigo) nao localizado.", 1);
		return(0);
	}

	if (jtemplates == NULL)
		return(0);

	json_array_iter(jtemplates, scanner_file_sendBio_template_iter, ctx);
	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * scanner_file_sendBio(IFDEVICE4J *dev4j, JSON_VALUE *jusers, char *vendor)
{
	SCANNER *scan = (SCANNER *) dev4j;
	JSON_VALUE *jres = json_array_new(1);
	void *ctx[] = {scan, jres, NULL, NULL, NULL, vendor};

	json_array_iter(jusers, scanner_file_sendBio_iter, ctx);

	return(jres);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_file_deleteBio_file_iter(DIR_CONTEXT *dir, FILE_CONTEXT *fctx, void *user_data)
{
	void **ctx = (void **) user_data;
	char *id = (char *) ctx[0];
	int *d = (int *) ctx[1];

	if (!fs_file_check(fctx, id, TEMPLATE_SUFFIX))
		return(0);

	fs_delete(fctx->filename);
	*d += 1;

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_file_deleteBio(SCANNER *scan, char *id)
{
	char buf[PATH_LEN];

	char *path = json_object_get_string(scan->dev.config, "path");
	DIR_CONTEXT *dir = fs_dir_new(path);
	int deleted = 0;

	if (dir == NULL)
		return(1);

	snprintf(buf, sizeof(buf), "%s_", id);

	void *ctx[] = {buf, &deleted};
	fs_dir_iter(dir, scanner_file_deleteBio_file_iter, ctx);

	fs_dir_free(dir);

	return(deleted);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
_CALLBACK int scanner_file_getBio_file_iter(DIR_CONTEXT *dir, FILE_CONTEXT *fctx, void *user_data)
{
	void **ctx = (void **) user_data;
	int *qty = (int *) ctx[1];
	char *vendor = (char *) ctx[2];
	JSON_VALUE *juser = (JSON_VALUE *) ctx[3];
	JSON_VALUE *jtemplates = (JSON_VALUE *) ctx[4];
	JSON_VALUE *jtemp;
	char *id = ifdevice_getID(juser);
	uint8_t *content;
	int finger = 1;
	char *tk[4];
	int n;

	if (!fs_file_check(fctx, id, TEMPLATE_SUFFIX))
		return(0);

	if (fctx->size < 1)
		return(0);

	n = tokenizer('_', fctx->name, tk, 4);
	*qty += 1;

	if ((n < 2) || (strcmp(tk[0], id) != 0))
		return(0);

	finger = atoi(tk[1]);

	n = fs_file_get_content(fctx, &content);
	if(n > IFPONTO_MAX_TEMPLATE_LEN)
	{
		verbose(stderr, "Biometria excedeu o tamanho: %d/%d.\n", n, IFPONTO_MAX_TEMPLATE_LEN);
		return(0);
	}

	jtemp = json_object_new(1);
	json_array_add(jtemplates, jtemp);

	json_object_add(jtemp, "vendor", json_string_new(vendor));
	json_object_add(jtemp, "finger", json_integer_new(finger));

	char *txtencoded = NULL;
	for (int i = 0 ; BIO_vendor_encode[i][0] != NULL ; i++)
	{
		if (strcmp(vendor, BIO_vendor_encode[i][0]) == 0)
		{
			json_object_add(jtemp, "encode", json_string_new(BIO_vendor_encode[i][1]));
			if_str_encoder(content, n, &txtencoded, BIO_vendor_encode[i][1]);
		}
	}

	if (txtencoded == NULL)
	{
		json_object_add(jtemp, "encode", json_string_new(TXT_ENCODE_B64));
		b64_encode((unsigned char *) content, n, &txtencoded);
	}

	json_object_add(jtemp, "template", json_string_new(txtencoded));

	if_free(content);
	if_free(txtencoded);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
_CALLBACK int scanner_file_getBio_iter(JSON_VALUE *juser, void *user_data)
{
	void **ctx = (void **) user_data;
	SCANNER *scan = (SCANNER *) ctx[0];
	char *path = json_object_get_string(scan->dev.config, "path");
	JSON_VALUE *jtemplates = json_object_find(juser, "templates");
	DIR_CONTEXT *dir;

	if (jtemplates == NULL)
	{
		jtemplates = json_array_new(1);
		json_object_add(juser, "templates", jtemplates);
	}

	dir = fs_dir_new(path);
	if (dir == NULL)
		return(1);

	ctx[3] = juser;
	ctx[4] = jtemplates;
	fs_dir_iter(dir, scanner_file_getBio_file_iter, ctx);
	fs_dir_free(dir);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * scanner_file_getBio(IFDEVICE4J *dev4j, JSON_VALUE *jusers, char *vendor)
{
	SCANNER *scan = (SCANNER *) dev4j;
	int qty = 0;
	void *ctx[] = {scan, &qty, vendor, NULL, NULL};

	json_array_iter(jusers, scanner_file_getBio_iter, ctx);

	// TODO - Obs: Retorna os templates em 'jusers' para bio_desktop.
	// Se algum dia for integrar com Java essa funcao deve retornar um clone de 'jusers'.

	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_set_device(SCANNER *, uint8_t);
// Implementacao /////////////////////////////////////////////////////// //


