#include <ifractal.h>
#include <ifdevice.h>

#include <com_ifractal_ifponto_Device.h>
#include <com_ifractal_utils_Verbosity.h>


#define MODULE		"libifponto4j"


#ifdef WIN32

ICLRRuntimeHost *runtime = NULL;


// /////////////////////////////////////////////////////////////// //
int APIENTRY DllMain(HMODULE hDLL, DWORD Reason, LPVOID Reserved)
{
	switch(Reason)
	{
		case DLL_PROCESS_ATTACH:
			// freeze - ver 'initC'
			//runtime = loadDotNetInstance();
			break;

		case DLL_PROCESS_DETACH:
			//unloadDotNetInstance(runtime);
			break;

		case DLL_THREAD_ATTACH:
			break;

		case DLL_THREAD_DETACH:
			break;
	}

	return(1);
}
// /////////////////////////////////////////////////////////////// //

#endif


int dotnet_load_mono(char *lib, char *ns, char *klass);
size_t dotnet_setDllName(char *name);
char * dotnet_getModels();

char *dotnet_models[50];
char *henry8x_models[] = {"henry8x", "argos", "prisma", "primme", "PrimmePonto", "PrimmeAcesso", NULL};
char *zk_models[] = {"zkteco", "zk", NULL};
char *cid_models[] = {"cid", "controlid", "idx", NULL};
char *dimep_models[] = {"dimep", "madis", NULL};
char *test_models[] = {"dummy", "test", NULL};

char **all_models[] = {henry8x_models, zk_models, cid_models, dimep_models, dotnet_models, test_models, NULL};


#ifndef WITH_MONO
// ///////////////////////////////////////////////////////////////////// //
void dotnet_init(IFDEVICE4J *dev)
{
}
// ///////////////////////////////////////////////////////////////////// //
#endif


// Comando para obter a assinatura dos metodos em java
// javap -s -p <class>

// Implementacao de Referencia ///////////////////////////////////////// //
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_getInfoU(IFDEVICE4J *dev, intptr_t sock)
{
	char *list[] = {"WARNING","modelo de equipamento nao implementado.", NULL,NULL};
	JSON_VALUE *r = json_object_new_list(list);
	return(r);
}
// ///////////////////////////////////////////////////////////////////// //
time_t IFDEVICE4J_getTimeU(IFDEVICE4J *dev, intptr_t sock)
{
	time_t now = time(NULL);

	if (dev->type == IFDEVICE4J_MODEL_UNKNOWN)
		return(0);

	return(now);
}
// ///////////////////////////////////////////////////////////////////// //
intptr_t IFDEVICE4J_setTimeU(IFDEVICE4J *dev, intptr_t diff)
{
	return(1);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_sendUsersU(IFDEVICE4J *dev, JSON_VALUE *users)
{
	JSON_VALUE *result = json_array_new(1);

	for(int i = 0 ; i < json_array_length(users) ; i++)
	{
		JSON_VALUE *reg = json_object_new(1);

		char *pis = json_object_get_string(json_array_index(users, i), "pis");
		json_object_add(reg, "pis", json_string_new(pis));
		json_object_add(reg, "cod_error", json_integer_new(0));
		json_array_add(result, reg);
	}

	return(result);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_getUsersU(IFDEVICE4J *dev, intptr_t none)
{
	char *user[] = {"nome", "Teste Nonononon nonononononon", "pis", "36428364284996", NULL, NULL};
	JSON_VALUE *jusers = json_array_new(1);
	JSON_VALUE *juser = json_object_new_list(user);

	json_array_add(jusers, juser);

	return(jusers);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_sendBioU(IFDEVICE4J *dev, JSON_VALUE *users)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_getBioU(IFDEVICE4J *dev, JSON_VALUE *users)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * IFDEVICE4J_getEventsU(IFDEVICE4J *dev, intptr_t nsr)
{
	JSON_VALUE *joffs = json_array_new(1);
	JSON_VALUE *jreg = json_object_new(1);
	char msg[PATH_LEN];
	time_t now = time(NULL);
	struct tm *dt;

	dt = localtime(&now);
	snprintf(msg, sizeof(msg), "%04d-%02d-%02d %02d:%02d:%02d", 
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, dt->tm_hour, dt->tm_min, dt->tm_sec);

	json_object_add(jreg, "datahora", json_string_new(msg));
	json_object_add(jreg, "nro_cartao", json_string_new("31415926"));
	json_object_add(jreg, "nsr", json_integer_new(nsr));

	json_array_add(joffs, jreg);

	return(joffs);
}
// ///////////////////////////////////////////////////////////////////// //
void IFDEVICE4J_freeU(IFDEVICE4J *dev)
{
}
// ///////////////////////////////////////////////////////////////////// //
char * IFDEVICE4J_onlineU_request(IFDEVICE4J *dev, IFDEVICE4J_online_callback callback, void *ctx, char **tk)
{
	char *req_list[] = {"cartao","12345", "sentido","E", "canal","1"};
	JSON_VALUE *jevent = callback(sizeof(req_list) / sizeof(char *), req_list, ctx, "getUserOnline");
	if (jevent == NULL)
		return(NULL);

	char *txtevent = json_serialize(jevent);
	fprintf(stdout, "Request Resp: '%s'\n", txtevent);

	json_value_free(jevent);

	int l = tokenizer('|', txtevent, tk, IFDEVICE_RESPONSE_LEN);
	if (l < IFDEVICE_RESPONSE_PASSWORD)
	{
		if_free(txtevent);
		return(NULL);
	}

	return(txtevent);
}
// ///////////////////////////////////////////////////////////////////// //
int IFDEVICE4J_onlineU(IFDEVICE4J *dev, IFDEVICE4J_online_callback callback, void *ctx)
{
	char *tk[IFDEVICE_RESPONSE_LEN];
	JSON_VALUE *jevent = NULL;
	char *txtevent = NULL;

	for (int i = 0 ; i < 5 ; i++)
	{
		txtevent = IFDEVICE4J_onlineU_request(dev, callback, ctx, tk);
		if (txtevent == NULL)
			return(-1);

		if_sleep(1000);

		char *cod_cartao = tk[IFDEVICE_RESPONSE_COD_CARTAO];
		char *cod_pessoa = tk[IFDEVICE_RESPONSE_COD_PESSOA];
		char *cod_acesso = tk[IFDEVICE_RESPONSE_ACCESS_CODE];
		char *sentido = "E";
		char *confirm_list[] = {"sentido",sentido, "cod_cartao",cod_cartao, "cod_pessoa",cod_pessoa, "cod_acesso",cod_acesso};
        
		jevent = callback(sizeof(confirm_list) / sizeof(char *), confirm_list, ctx, "turnConfirmation");
		if_free(txtevent);
		if (jevent == NULL)
			return(-2);
        
		txtevent = json_serialize(jevent);
		fprintf(stdout, "Confirm Resp: '%s'\n\n", txtevent);
        
		if_free(txtevent);
		json_value_free(jevent);

		if_sleep(2000);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
void IFPONTO_init_dummy(IFDEVICE4J *dev)
{
	dev->getInfo = IFDEVICE4J_getInfoU;
	dev->getTime = IFDEVICE4J_getTimeU;
	dev->setTime = IFDEVICE4J_setTimeU;
	dev->sendUsers = IFDEVICE4J_sendUsersU;
	dev->getUsers = IFDEVICE4J_getUsersU;
	dev->sendBio = IFDEVICE4J_sendBioU;
	dev->getBio = IFDEVICE4J_getBioU;
	dev->getEvents = IFDEVICE4J_getEventsU;
	dev->free = IFDEVICE4J_freeU;
	dev->online = IFDEVICE4J_onlineU;
}
// ///////////////////////////////////////////////////////////////////// //
// Implementacao de Referencia ///////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
IFDEVICE4J_MODEL IFPONTO_init_model(IFDEVICE4J *dev4j, JSON_VALUE *jconfig)
{
	IFDEVICE *dev = (IFDEVICE *) dev4j;
	IFDEVICE4J_MODEL type = IFDEVICE4J_MODEL_UNKNOWN;
	char *model = json_object_get_string(jconfig, "modelo");
	struct
	{
		char **ids;
		void (*init)(IFDEVICE4J *);
		IFDEVICE4J_MODEL type;
	} models[] = {
		{henry8x_models, henry8x_init, IFDEVICE4J_MODEL_HENRY8x},
		{zk_models, ZK_init, IFDEVICE4J_MODEL_ZK},
		{cid_models, CID_init, IFDEVICE4J_MODEL_CID},
		{dotnet_models, dotnet_init, IFDEVICE4J_MODEL_DOTNET},
		{test_models, IFPONTO_init_dummy, IFDEVICE4J_MODEL_TEST},
#ifndef WIN32
		{dimep_models, dimep_init, IFDEVICE4J_MODEL_DIMEP},
#endif
		{NULL, NULL, 0}
	};
	int i, k;

	for (i = 0 ; models[i].ids != NULL ; i++)
	{
		for (k = 0 ; models[i].ids[k] != NULL ; k++)
		{
			if (strcasecmp(model, models[i].ids[k]) == 0)
			{
				models[i].init(dev4j);
				return(models[i].type);
			}
		}
	}

	verboseFATAL(&(dev->log), "Modelo '%s': Device nao implementado.\n", model);
	IFPONTO_init_dummy(dev4j);

	return(type);
}
// ////////////////////////////////////////////////////////////////////////
void IFPONTO_device_init(IFDEVICE *dev, JSON_VALUE *jconfig)
{
	dev->sock = -1;

	dev->nro = json_object_get_int(jconfig, "nro");
	dev->codigo = json_object_get_int(jconfig, "codigo");
	dev->log.verbosity = json_object_get_int(jconfig, "verbosity");

	char *model = json_object_get_string(jconfig, "modelo");
	snprintf(dev->log.source, sizeof(dev->log.source), "%s|%d", model, dev->nro);
	strncpy(dev->host, json_object_get_string(jconfig, "ip"), HOST_LEN);
	strncpy(dev->port, json_object_get_string(jconfig, "porta"), PORT_LEN);

	verbose(stderr, "|%s| verbosity: %d\n", dev->log.source, dev->log.verbosity);
}
// ///////////////////////////////////////////////////////////////////// //
IFDEVICE4J * IFPONTO_ifponto4j_new(JSON_VALUE *jconfig)
{
	if (jconfig == NULL)
		return(NULL);

	IFDEVICE4J *dev = if_malloc(sizeof(IFDEVICE_GENERIC));
	IFPONTO_device_init((IFDEVICE *) dev, jconfig);
	dev->type = IFPONTO_init_model(dev, jconfig);
	dev->config = jconfig;
	return(dev);
}
// ///////////////////////////////////////////////////////////////////// //
void IFPONTO_ifponto4j_free(IFDEVICE4J *dev)
{
	if (dev == NULL)
		return;

	verboseDEBUG(&(dev->log), "Free device.\n");

	if (dev->free != NULL)
		dev->free(dev);

	if (dev->config != NULL)
		json_value_free(dev->config);

	if_free(dev);
}
// ///////////////////////////////////////////////////////////////////// //


// /////////////////////////////////////////////////////////////// //
jstring json2jstring(JNIEnv *env, JSON_VALUE *json)
{
	if (json == NULL)
		return(NULL);

	char *aux = json_serialize(json);
	json_value_free(json);
	jstring r = (*env)->NewStringUTF(env, aux);
	if_free(aux);

	return(r);
}
// /////////////////////////////////////////////////////////////// //
JSON_VALUE * jstring2json(JNIEnv *env, jstring str)
{
	if (str == NULL)
		return(NULL);

	const char *jstr = (*env)->GetStringUTFChars(env, str, 0);
	JSON_VALUE *r = json_parse_mem((char *) jstr);

	(*env)->ReleaseStringUTFChars(env, str, jstr);

	return(r);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
#ifdef WIN32
__declspec(dllexport) uint32_t verboseC(char *msg)
{  
	uint32_t n = verbose(stdout, "%s", msg);
	return(n);
}
#endif
// /////////////////////////////////////////////////////////////// //
JNIEXPORT void JNICALL Java_com_ifractal_utils_Verbosity_verboseC
  (JNIEnv *env, jclass refclass, jstring jmsg)
{
	const char *msg = (*env)->GetStringUTFChars(env, jmsg, 0);
	verbose(stdout, "%s", msg);
	(*env)->ReleaseStringUTFChars(env, jmsg, msg);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jlong JNICALL Java_com_ifractal_ifponto_Device_initC
  (JNIEnv *env, jclass klass, jstring conf)
{
#ifdef WIN32
	runtime = loadDotNetInstance();
#endif

	memset(dotnet_models, 0, sizeof(dotnet_models));

#ifdef WITH_MONO

	JSON_VALUE *jconfig = jstring2json(env, conf);
	char *lib = NULL;
	char *ns = "ifponto";
	char *sklass = "NativeDevice";
	char *aux;

	dotnet_setDllName(NULL);

	if (jconfig != NULL)
	{
		lib = json_object_get_string(jconfig, "mono_library");

		if ((aux = json_object_get_string(jconfig, "dotnet_namespace"))[0] != 0)
			ns = aux;

		if ((aux = json_object_get_string(jconfig, "dotnet_class"))[0] != 0)
			sklass = aux;

		dotnet_load_mono(lib, ns, sklass);
		json_value_free(jconfig);
	}

	char *models = dotnet_getModels();
	if (models == NULL)
	{
		verbose(stdout, "Falha ao tentar carregar modelos .Net\n");
		return(0);
	}

	tokenizer('|', models, dotnet_models, sizeof(dotnet_models) / sizeof(char *));

	for (int i = 0 ; dotnet_models[i] != NULL ; i++)
	{
		if (dotnet_models[i][0] == 0)
		{
			dotnet_models[i] = NULL;
			continue;
		}
	}

#else

	 dotnet_models[0] = "mono nao implementado";
	 dotnet_models[1] = NULL;

#endif

	return(0);
}
// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_getModelsC
  (JNIEnv *env, jclass klass, jstring conf)
{
	JSON_VALUE *jmodels = json_array_new(1);

	for (int i = 0 ; all_models[i] != NULL ; i++)
		for (int m = 0 ; all_models[i][m] != NULL ; m++)
			json_array_add(jmodels, json_string_new(all_models[i][m]));

	jstring smodels = json2jstring(env, jmodels);

	return(smodels);
}
// /////////////////////////////////////////////////////////////// //
JNIEXPORT jlong JNICALL Java_com_ifractal_ifponto_Device_deviceNewC
  (JNIEnv *env, jobject obj, jstring config)
{
	IFDEVICE4J *dev = NULL;
	JSON_VALUE *jconfig = jstring2json(env, config);

	if (jconfig == NULL)
		return(0);

	dev = IFPONTO_ifponto4j_new(jconfig);

	return((jlong) dev);
}
// /////////////////////////////////////////////////////////////// //
JNIEXPORT void JNICALL Java_com_ifractal_ifponto_Device_deviceFreeC
  (JNIEnv *env, jobject obj, jlong ptr)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;

	if (dev != NULL)
		IFPONTO_ifponto4j_free(dev);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_getEventsC
  (JNIEnv *env, jobject obj, jlong ptr, jint nsr)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	JSON_VALUE *joffs = dev->getEvents(dev, nsr);
	jstring evts = json2jstring(env, joffs);

	return(evts);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_getInfoC
  (JNIEnv *env, jobject obj, jlong ptr, jlong sock)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	JSON_VALUE *jinfo = dev->getInfo(dev, sock);
	jstring info = json2jstring(env, jinfo);
	return(info);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jlong JNICALL Java_com_ifractal_ifponto_Device_getTimeC
  (JNIEnv *env, jobject obj, jlong ptr, jlong sock)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	time_t dt = dev->getTime(dev, sock);
	return(dt);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT void JNICALL Java_com_ifractal_ifponto_Device_setTimeC
  (JNIEnv *env, jobject obj, jlong ptr, jint timediff)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	dev->setTime(dev, timediff);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_sendUsersC
  (JNIEnv *env, jobject obj, jlong ptr, jstring users)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	JSON_VALUE *jusers = jstring2json(env, users);
	JSON_VALUE *jres = dev->sendUsers(dev, jusers);
	json_value_free(jusers);
	jstring res = json2jstring(env, jres);
	return(res);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_getUsersC
  (JNIEnv *env, jobject obj, jlong ptr)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	JSON_VALUE *jusers = dev->getUsers(dev, 0);
	jstring users = json2jstring(env, jusers);

	return(users);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_sendBioC
  (JNIEnv *env, jobject obj, jlong ptr, jstring users)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	JSON_VALUE *jusers = jstring2json(env, users);
	JSON_VALUE *jres = dev->sendBio(dev, jusers);
	json_value_free(jusers);
	jstring res = json2jstring(env, jres);
	return(res);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
JNIEXPORT jstring JNICALL Java_com_ifractal_ifponto_Device_getBioC
  (JNIEnv *env, jobject obj, jlong ptr, jstring users)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	jstring bios = NULL;
	JSON_VALUE *jusers = jstring2json(env, users);
	JSON_VALUE *jres = dev->getBio(dev, jusers);
	bios = json2jstring(env, jres);
	
	json_value_free(jusers);

	return(bios);
}
// /////////////////////////////////////////////////////////////// //


typedef struct
{
	IFDEVICE4J *dev;
	JNIEnv *env;
	jobject obj;
} JCONTEXT;

// /////////////////////////////////////////////////////////////// //
JSON_VALUE * ifdev_callback(int argc, char *argv[], void *context, char *method_name)
{
	char *defmeth = "(Lcom/ifractal/ifponto/Device;Ljava/lang/String;)Ljava/lang/String;";
	char *classname = "com/ifractal/ifponto/User";
	JCONTEXT *ctx = (JCONTEXT *) context;
	JSON_VALUE *juser = NULL;
	jstring user = NULL;
	jmethodID mid;
	jclass klass;
	jstring jstrdata;
	const char *jstr;

	if (argc < 1)
		return(NULL);

	if (ctx->env == NULL)
		return(NULL);

	klass = (*(ctx->env))->FindClass(ctx->env, classname);
	if(klass == NULL) 
	{
		verboseFATAL(&(ctx->dev->log), "Classe '%s' nao encontrada.\n", classname);
		return(NULL);
	}

	mid = (*(ctx->env))->GetStaticMethodID(ctx->env, klass, method_name, defmeth);
	if (mid == 0)
	{
		verboseFATAL(&(ctx->dev->log), "Metodo '%s' nao encontrado.\n", method_name);
		return(NULL);
	}

	if (argc == 1)
	{
		jstrdata = (*(ctx->env))->NewStringUTF(ctx->env, argv[0]);
	}
	else
	{
		JSON_VALUE *json = json_object_new(1);

		int i;
		for (i = 0 ; (i + 1) < argc ; i += 2)
			json_object_add(json, argv[i], json_string_new(argv[i + 1]));

		jstrdata = json2jstring(ctx->env, json);
	}

	user = (jstring) (*(ctx->env))->CallStaticObjectMethod(ctx->env, klass, mid, ctx->obj, jstrdata);
	if (user != NULL)
	{
		juser = jstring2json(ctx->env, user);
		if (juser == NULL)
		{
			jstr = (*(ctx->env))->GetStringUTFChars(ctx->env, user, 0);
			juser = json_string_new((char *) jstr);
			(*(ctx->env))->ReleaseStringUTFChars(ctx->env, user, jstr);
		}
	}

	return(juser);
}
// /////////////////////////////////////////////////////////////// //
JNIEXPORT jint JNICALL Java_com_ifractal_ifponto_Device_getEndIterDelayC
  (JNIEnv *env, jobject obj, jlong ptr)
{
	IFDEVICE4J *dev = (IFDEVICE4J *) ptr;
	jint delay = 30;
	JCONTEXT ctx = {dev, env, obj};

	if (dev->online != NULL)
		delay = dev->online(dev, ifdev_callback, &ctx);

	return(delay);
}
// /////////////////////////////////////////////////////////////// //



#ifdef DEBUG

// /////////////////////////////////////////////////////////////// //
JSON_VALUE * debug_online_callback(int argc, char *argv[], void *context, char *method_name)
{
	fprintf(stdout, "Solicitacao Online: (%s)\n", method_name);
	for (int i = 0 ; (i + 1) < argc ; i += 2)
		fprintf(stdout, "\t%s=%s\n", argv[i], argv[i + 1]);

	// Vide 'enum IFDEVICE_RESPONSE_CSV' em ifdevice.h
	char online_resp[] = " |1|L|E|Acesso Liberado|Teste Online|Usuario Teste|1234|0|0|0|0";
	JSON_VALUE *jresp = json_string_new(online_resp);

	return(jresp);
}
// /////////////////////////////////////////////////////////////// //

// /////////////////////////////////////////////////////////////// //
int main(int argc, char **argv)
{
	char *params[] = {
		"modelo", "dotnet", 
		"nro", "99", 
		"ip", "172.30.253.97", 
		"porta", "3000", 
		"mono_library", "/usr/lib/libmonoboehm-2.0.so.1",
		"dotnet_namespace", "ifponto",
		"dotnet_class", "NativeDevice",
		"tempo_aguardando_giro", "3",
		"MODO", "1",
		"verbosity", "0",
		NULL, NULL};

	if (argc < 2)
	{
		fprintf(stderr, "\nSIIN - Unit Test implementacoes C e Mono / .Net\n\n");
		fprintf(stderr, "Uso:\n");
		fprintf(stderr, "\t$ %s <CMD> <Arquivo JSON> <Param 1> <Val 1> ... <Param N> <Val N>\n", argv[0]);

		fprintf(stderr, "\nOnde <Param>:\n");
		for (int i = 0 ; params[i + 1] != NULL ; i += 2)
			fprintf(stderr, "%25s  -  Default: %s\n", params[i], params[i + 1]);

		fprintf(stderr, "\nExemplo:\n");
		fprintf(stderr, "\t$ %s getInfo - modelo dummy ip 172.30.1.10 porta 3000\n", argv[0]);
		fprintf(stderr, "\t$ %s sendUsers arquivo_users.json modelo dummy ip 172.30.1.10 porta 3000\n\n", argv[0]);
		return(1);
	}
	else if ((argc % 2) == 0)
	{
		fprintf(stderr, "Parametros devem vir em pares.\n\n");
		return(2);
	}

	JSON_VALUE *jconfig = json_object_new_list(params);

	for (int i = 3 ; (i + 1) < argc ; i += 2)
		json_object_add(jconfig, argv[i], json_string_new(argv[i + 1]));

#ifdef WITH_MONO
	char *lib = json_object_get_string(jconfig, "mono_library");
	char *ns = json_object_get_string(jconfig, "dotnet_namespace");
	char *klass = json_object_get_string(jconfig, "dotnet_class");

	dotnet_setDllName(NULL);
	dotnet_load_mono(lib, ns, klass);
#endif

	Java_com_ifractal_ifponto_Device_initC(NULL, NULL, NULL);

	fprintf(stdout, "\n");

	IFDEVICE4J *dev = IFPONTO_ifponto4j_new(jconfig);
	struct
	{
		char *cmd;
		IFDEVICE4J_method meth;
	} cmds[] = {
		{"getTime", dev->getTime},
		{"setTime", dev->setTime},
		{"getInfo", (IFDEVICE4J_method) dev->getInfo},
		{"getUsers", (IFDEVICE4J_method) dev->getUsers},
		{"sendUsers", (IFDEVICE4J_method) dev->sendUsers},
		{"sendBio", (IFDEVICE4J_method) dev->sendBio},
		{"getBio", (IFDEVICE4J_method) dev->getBio},
		{"getEvents", (IFDEVICE4J_method) dev->getEvents},
		{NULL, NULL}
	};

	IFDEVICE4J_method meth = NULL;
	JSON_VALUE *jin = NULL;
	JSON_VALUE *jout = NULL;
	char *txt;
	FILE *fd;

	if (argv[2][0] != '-') 
	{
		fd = fopen(argv[2], "r");
		if (fd == NULL)
		{
			fprintf(stderr, "Falha ao tentar abrir: '%s'.\n", argv[2]);
			return(3);
		}

		jin = json_parse_file(fd);
		if (jin == NULL)
		{
			fprintf(stderr, "Arquivo JSON invalido: '%s'.\n", argv[2]);
			return(4);
		}

		fclose(fd); 
	}

	for (int i = 0 ; cmds[i].cmd != NULL ; i++)
	{
		if (strcmp(cmds[i].cmd, argv[1]) != 0)
			continue;

		meth = cmds[i].meth;
		break;
	}

	if (strcmp("online", argv[1]) == 0)
	{
		dev->online(dev, debug_online_callback, NULL);
		return(0);
	}
	else if (meth == NULL)
	{
		fprintf(stderr, "Falha ao tentar executar: '%s' - metodo nao encontrado.\n", argv[1]);

		fprintf(stderr, "\nMetodos disponiveis:\n");
		for (int i = 0 ; cmds[i].cmd != NULL ; i++)
			fprintf(stderr, "\t%s\n", cmds[i].cmd);
		fprintf(stderr, "\tonline\n\n");

		return(9);
	}

	fprintf(stderr, "Executa %s\n", argv[1]);
	jout = (JSON_VALUE *) meth(dev, (intptr_t) jin);
	if (jout == NULL)
	{
		fprintf(stderr, "Falha na execucao do metodo: '%s'\n", argv[1]);
		return(10);
	}

	if (((intptr_t) jout & 0xFFFFFFFF00000000) != ((intptr_t) dev & 0xFFFFFFFF00000000))
	{
		int r = (int) ((intptr_t) jout & 0xFFFFFFFF);
		fprintf(stdout, "%d\n", r);
		return(0);
	}

	txt = json_serialize(jout);
	fprintf(stdout, "%s\n", txt);
	if_free(txt);
	json_value_free(jout);

	return(0);
}
// /////////////////////////////////////////////////////////////// //

#endif


#ifdef DEBUG_THREAD

IF_THREAD_LIST *list;


// ///////////////////////////////////////////////////////////////////// //
void * th_event(IF_THREAD_LIST *list, IF_THREAD_EVENT *ev)
{
	int n = if_slist_length(list->first);

	switch (ev->event)
	{
		case IF_EVENT_START: fprintf(stdout, "Total:%d  -  EV: start (%d)\n", n, ev->id); break;
		//case IF_EVENT_WAIT: fprintf(stdout, "Total:%d  -  EV: wait (%d)\n", n, ev->id); break;
		case IF_EVENT_FREE: fprintf(stdout, "Total:%d  -  EV: FREE (%d)\n", n, ev->id); break;
#ifdef WIN32
		case IF_EVENT_IDLE: Sleep(1); break;
		case IF_EVENT_END: fprintf(stdout, "Total:%d  -  EV: end\n", n); Sleep(1000); break;
#else
		case IF_EVENT_IDLE: usleep(1000); break;
		case IF_EVENT_END: fprintf(stdout, "Total:%d  -  EV: end\n", n); sleep(1); break;
#endif
		default: break;
	}

	return(NULL);
}
// ////////////////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////////////////
void * th_func(THREAD_STATE *state, int id, void *data)
{
	char *list[] = {"modelo", "dummy", "nro", "1", "ip", "172.30.1.254", "porta", "3000", NULL, NULL};

	JSON_VALUE *jconf = json_object_new_list(list);
	json_object_add(jconf, "nro", json_integer_new(id));

	IFDEVICE4J *dev = IFPONTO_ifponto4j_new(jconf);

	time_t dt = dev->getTime(dev, 0);
	fprintf(stdout, "UnixTime: %ld\n", (uint64_t) dt);

	JSON_VALUE *info = dev->getUsers(dev, 0);
	char *txt = json_serialize(info);
	fprintf(stdout, "Users: %s\n", txt);
	json_value_free(info);
	if_free(txt);

	IFPONTO_ifponto4j_free(dev);

	return(NULL);
}
// ////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////// //
int main(int argc, char *argv[])
{
	int i, qtd;

	if (argc < 2)
	{
		fprintf(stderr, "Uso:\n\t$ %s <Qtd Threads>\n", argv[0]);
		return(1);
	}

	dotnet_setDllName(NULL);
	dotnet_load_mono("/usr/lib/libmonoboehm-2.0.so.1", "ifponto", "NativeDevice");
	Java_com_ifractal_ifponto_Device_initC(NULL, NULL, NULL);

	list = if_thread_list_new(th_event);

	qtd = atoi(argv[1]);
	for (i = 1 ; i < qtd ; i++)
	{
		if_thread_add(list, th_func, i, NULL);
		// TODO - se tirar esse sleep erro fatal
		//if_sleep(20);
	}
	
	for (i = 2 ; i > 0 ; i--)
	{
		fprintf(stdout, "Espera (%d)\n", i);
		fflush(stdout);
		if_sleep(1000);
	}

	fprintf(stdout, "Finaliza lista.\n");
	if_thread_list_finalize(list);
	fprintf(stdout, "Espera lista.\n");
	i = if_thread_list_wait(list);

	return(0);
}

#endif

