#include <ifractal.h>

#include <jni.h>

#include <modjava.h>


#ifdef WIN32
#define CONFIG_INI	"conf\\modjava.ini"
#else
#define CONFIG_INI	"conf/modjava.ini"
#endif


// Comando para encontrar a assinatura dos metodos em java
// javap -s -p <class>


JAVA_CONTEXT *ctx = NULL;

IF_GETOPT config[] = {
	{0, 'e', IF_GETOPT_TYPE_NUMBER, "ATIVO", "0", 0, "0 = Modulo inativo, 1 = ativo"},
	{0, 'l', IF_GETOPT_TYPE_STRING, "LIBRARY_PATH", "bin", 0, "PATH para dependencias. (so,dll)"},
	{0, 'c', IF_GETOPT_TYPE_STRING, "CLASSPATH", "lib/java", 0, "PATH para *.class, *.jar."},
	{0, 's', IF_GETOPT_TYPE_STRING, "LISTENERS", "", 0, "JSON de configuracao das classes."},
	{0, 'p', IF_GETOPT_TYPE_NUMBER, "STACK", "256", 0, "Tamanho da pilha em kbytes."},
	{0, 'x', IF_GETOPT_TYPE_STRING, "JVERBOSITY", "gc", 0, "parametro -verbose do JVM. (gc*|class|jni)"},
	{0, 'x', IF_GETOPT_TYPE_STRING, "DUMPSIZE", "none", 0, "parametro --XXdumpSize do JVM. (none*|small|normal|large)"},
	{0, 'x', IF_GETOPT_TYPE_SELECT, "VERBOSITY", "0", 0, VERBOSITY_OPTIONS},
	{0, 0, 0, 0, 0, 0, 0}
};


// //////////////////////////////////////////////////////////////////////
int delete_cb(char *path, char *filename, void *user_data)
{
	verbose(stdout, "Deleta: '%s'\n", filename);
	return(0);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
JAVA_CONTEXT * java_init_context(char *classpath, char *libpath, char *stack)
{
	char *opts[] = {
		"-Djava.compiler=%s", "NONE",
		"-Djava.class.path=%s", classpath,
		"-Djava.library.path=%s", libpath,
		"-Xss%sm", stack,
		"-verbose:%s", if_getopt_getValue(config, "JVERBOSITY"),
		"-XX:-CreateMinidumpOnCrash", NULL,
#ifdef WIN32
		//"-XXdumpSize:%s", if_getopt_getValue(config, "DUMPSIZE"),
#endif
		NULL, NULL
	};
	int opts_qty = ((sizeof(opts) / sizeof(char *)) / 2) - 1;
	JAVA_CONTEXT *jctx;
	JavaVMInitArgs vm_args;
	JavaVMOption options[opts_qty];
	char opt[opts_qty][4 * PATH_LEN];
	long result;
	int i, ptr;

	verbose(stdout, "Parametros JVM\n");
	for (i = 0, ptr = 0 ; opts[ptr] != NULL ; i++, ptr += 2)
	{
		snprintf(opt[i], sizeof(opt[i]), opts[ptr], opts[ptr + 1]);
		options[i].optionString = opt[i];
		verbose(stdout, "\t%s\n", opt[i]);
	}

	vm_args.version = JNI_VERSION_1_2;
	vm_args.options = options;
	vm_args.nOptions = opts_qty;
	vm_args.ignoreUnrecognized = JNI_FALSE;

	jctx = if_malloc(sizeof(JAVA_CONTEXT));

	verbose(stdout, "Inicia JVM\n");
	result = JNI_CreateJavaVM(&(jctx->jvm), (void **) &(jctx->env), &vm_args);
	if(result == JNI_ERR) 
	{
		verbose(stderr, "Erro ao tentar carregar JVM.\n");
		return(NULL);
	}

	verbose(stdout, "JVM inicializada.\n");

#ifdef WIN32
	// Deleta arquivos de DUMP (java)
	i = execute_delete(".", "hs_err_", ".mdmp", 0, 0, delete_cb, NULL);	
	verbose(stdout, "%d arquivos deletados.\n", i);
#endif

	return(jctx);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
int java_new_class(JAVA_INSTANCE *instance, JNIEnv *env, char *classname, jobjectArray objarray)
{
	jmethodID mid;
	jclass klass;
	jobject obj;

	klass = (*env)->FindClass(env, classname);
	if(klass == NULL) 
	{
		verbose(stderr, "Classe '%s' nao encontrada.\n", classname);
		(*env)->ExceptionDescribe(env);
		(*env)->ExceptionClear(env);
		return(-1);
	}
	(*env)->ExceptionClear(env);

	instance->klass = klass;
	strncpy(instance->classname, classname, PATH_LEN);

	verbose(stderr, "Carrega classe: %s.\n", classname);

	mid = (*env)->GetMethodID(env, klass, "<init>", "()V");
	obj = (*env)->NewObject(env, klass, mid);

	instance->klass = (*env)->NewGlobalRef(env, klass);
	instance->object = (*env)->NewGlobalRef(env, obj); 

	mid = (*env)->GetMethodID(env, klass, "initModule", "([Ljava/lang/String;)V");
	if (mid)
		(*env)->CallVoidMethod(env, instance->object, mid, objarray);
	else
		verbose(stderr, "metodo 'initModule' nao encontrado.\n");

	return(0);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
JAVA_INSTANCE * java_get_object(char *classname)
{
	int i;

	for (i = 0 ; i < ctx->qty ; i++)
		if (strcmp(ctx->instances[i].classname, classname) == 0)
			return(&(ctx->instances[i]));

	return(NULL);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_CALLBACK int java_init_listeners_params_iter(char *key, JSON_VALUE *jparam, void *user_data)
{
	char **params = (char **) user_data;
	int i;

	for (i = 0 ; (i < PATH_LEN) && (params[i] != NULL) ; i++)
		;

	if (i >= PATH_LEN)
		return(1);

	params[i++] = key;
	params[i] = json_get_string(jparam);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
int java_init_listener(JSON_VALUE *jklass, JNIEnv *env, JAVA_INSTANCE *instance)
{
	char *classname, *key, *value;
	jobjectArray objarray;
	char *params[PATH_LEN];
	int qty_params, i, n, r;
	JSON_VALUE *aux;

	classname = json_object_get_string(jklass, "class");
	if (classname[0] == 0)
	{
		verbose(stderr, "init_listeners - Campo 'class' nao encontrado.\n");
		return(0);
	}

	aux = json_object_find(jklass, "params");
	if (aux == NULL)
	{
		verbose(stderr, "init_listeners - Campo 'params' nao encontrado.\n");
		return(0);
	}

	memset(params, 0, sizeof(params));
	qty_params = json_object_iter(aux, java_init_listeners_params_iter, params);

	for (n = 0 ; config[n].long_opt != NULL ; n++)
		;

	objarray = (*env)->NewObjectArray(
		env, 
		2 * (qty_params + n), 
		(*env)->FindClass(env, "java/lang/String"), 
		NULL);

	for (i = 0 ; i < (2 * qty_params) ; i++)
	{
		(*env)->SetObjectArrayElement(env, objarray, i, (*env)->NewStringUTF(env, params[i]));
		i++;
		(*env)->SetObjectArrayElement(env, objarray, i, (*env)->NewStringUTF(env, params[i]));
	}

	for (n = i, i = 0 ; config[i].long_opt != NULL ; i++, n += 2)
	{
		key = config[i].long_opt;
		value = config[i].arg;

		(*env)->SetObjectArrayElement(env, objarray, n, (*env)->NewStringUTF(env, key));
		(*env)->SetObjectArrayElement(env, objarray, n + 1, (*env)->NewStringUTF(env, value));
	}

	r = java_new_class(instance, env, classname, objarray);
	if (r)
		verbose(stderr, "init_listeners - Falha ao tentar carregar Classe '%s'\n", classname);

	return(r);
}
// //////////////////////////////////////////////////////////////////////
_PRIVATE int java_init_listeners(_IN FILE *listeners)
{
	JSON_VALUE *jlisteners, *jlist;
	JavaVM *jvm = ctx->jvm;
	JNIEnv *env;
	jint res;
	int r;

	res = (*jvm)->AttachCurrentThread(jvm, (void **) &env, NULL);
	if (res < 0)
	{
		verbose(stderr, "init_listeners - Thread attach failed\n");
		return(-2);
	}

	jlisteners = json_parse_file(listeners);
	if ((jlisteners == NULL) || (json_get_type(jlisteners) != JSON_ARRAY_TYPE))
		return(-3);

	ctx->qty = json_array_length(jlisteners);
	ctx->instances = if_malloc(ctx->qty * sizeof(JAVA_INSTANCE));

	for (r = 0 ; r < ctx->qty ; r++)
	{
		jlist = json_array_index(jlisteners, r);
		java_init_listener(jlist, env, &(ctx->instances[r]));
	}

	(*jvm)->DetachCurrentThread(jvm);

	return(r);
}
// //////////////////////////////////////////////////////////////////////


// Implementacao da Interface SIIN //////////////////////////////////////
// //////////////////////////////////////////////////////////////////////
int if_modweb_init(MODSIIN *mod)
{
	char *classpath, *libpath, *listeners, *stack;
	int ativo = 0;
	FILE *fd;
	int r = 0;

	if (if_getopt_ini(CONFIG_INI, config) < 1)
	{
		verbose(stderr, "Falha ao tentar ler: %s\n", CONFIG_INI);
		return(1);
	}

	ativo = atoi(if_getopt_getValue(config, "ATIVO"));
	if (!ativo)
	{
		verbose(stderr, "|%s| inativo.\n", MODULE);
		return(0);
	}

	classpath = if_getopt_getValue(config, "CLASSPATH");
	libpath = if_getopt_getValue(config, "LIBRARY_PATH");
	stack = if_getopt_getValue(config, "STACK");
	listeners = if_getopt_getValue(config, "LISTENERS");

	verbose(stdout, "CLASSPATH=%s\n", classpath);
	verbose(stdout, "LIBRARY_PATH=%s\n", libpath);
	verbose(stdout, "STACK=%s\n", stack);

	ctx = java_init_context(classpath, libpath, stack);
	
	if (listeners[0] == 0)
	{
		verbose(stderr, "|%s| listener JSON nao definido.\n", MODULE);
		return(2);
	}

	if ((fd = fopen(listeners, "r")) != NULL)
	{
		if (java_init_listeners(fd) < 0)
		{
			verbose(stderr, "init_listeners - Arquivo invalido: '%s'\n", listeners);
			r = 3;
		}

		fclose(fd);
	}
	else
	{
		verbose(stderr, "init_listeners - Falha ao tentar ler configuracao: '%s'\n", listeners);
		return(4);
	}
	
	return(r);
}
// //////////////////////////////////////////////////////////////////////
int if_modweb_finalize(MODSIIN *mod)
{
	if (ctx == NULL)
		return(0);
	
	JAVA_INSTANCE *instance;
	JavaVM *jvm = ctx->jvm;
	JNIEnv *env;
	jmethodID mid;
	int i, r;

	r = (*jvm)->AttachCurrentThread(jvm, (void **) &env, NULL);
	if (r < 0)
	{
		verbose(stderr, "finalizeModule - Thread attach failed\n");
		return(-2);
	}

	for (i = 0 ; i < ctx->qty ; i++)
	{
		instance = ctx->instances + i;

		if (instance->klass == NULL)
			continue;

		mid = (*env)->GetMethodID(env, instance->klass, "finalizeModule", "()V");
		if (mid)
			(*env)->CallVoidMethod(env, instance->object, mid);
		else
			verbose(stderr, "metodo 'finalizeModule' nao encontrado.\n");
	}

	(*jvm)->DestroyJavaVM(jvm);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
void * if_modweb_run(THREAD_STATE *state, int id, void *data)
{
	return(NULL);
}
// //////////////////////////////////////////////////////////////////////
// FIM - Implementacao da Interface /////////////////////////////////////



#ifdef DEBUG
int main(int argc, char *argv[])
{
	if_modweb_init(NULL);
	if_modweb_finalize(NULL);

	return(0);
}
#endif
