#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>

#ifdef SCO
#include <sys/time.h>
#elif __MACH__
#include <sys/time.h>
#endif


#ifdef WIN32
#include <windows.h>
#include <winsock2.h>
#else
#include <unistd.h>
#include <wait.h>
#endif

#include <ifractal_threads.h>
#include <ifractal_utils.h>
#include <if_common_net.h>

typedef struct _RESULT_TEST RESULT_TEST;
typedef int (*FUNC_TEST)(RESULT_TEST *);

struct _RESULT_TEST
{
	char *host;
	char *port;
	union
	{
		char *path;
		int qty_lines;
	};
	int qty_sess;
	int min_delay;
	int max_delay;
	int sum_delay;
	int qty_fails;
	FUNC_TEST func;
};


// Prototipos
RESULT_TEST * result_test_new(FUNC_TEST);
void result_test_update(RESULT_TEST *, time_t delay);
int result_test_run(RESULT_TEST *);
void result_test_report(RESULT_TEST *);

// Funcoes de teste
int test(RESULT_TEST *);


// Validacao de linha de comando
typedef enum
{
	CMDLN_OK,
	CMDLN_HOST,
	CMDLN_PORT,
	CMDLN_QTYLINES,
	CMDLN_QTYSESS,
	CMDLN_LEN
} CMDLN_RET;

IF_MSG_ERRO cmdln_msgs[] = {
	{CMDLN_OK, "OK - No errors."},
	{CMDLN_HOST, "HOST invalido."},
	{CMDLN_PORT, "PORT invalido."},
	{CMDLN_QTYLINES, "QUANTIDADE invalida."},
	{CMDLN_QTYSESS, "QTYSESS invalido."},
	{CMDLN_LEN, "Faltam parametros."},
	{0, NULL}
};

CMDLN_RET check_cmdln_params(int argc, char **argv);
char * get_cmdln_error(CMDLN_RET);


