#include <netraw.h>

// //////////////////////////////////////////////////////////////////////
// From Unix network programming
_PRIVATE uint16_t in_cksum(uint16_t *addr, int len) 
{
	int nleft = len;
	uint32_t sum = 0;
	uint16_t *w = addr;
	uint16_t answer = 0;

	while (nleft > 1)  
	{
		sum += *w++;
		nleft -= 2;
	}

	if (nleft == 1) 
	{
		*(unsigned char *)(&answer) = *(u_char *)w ;
		sum += answer;
	}

	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;

	return(answer);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
unsigned short int tcp4_in_cksum (struct ip iphdr, struct tcphdr tcphdr)
{
	unsigned short int svalue;
	char buf[IP_MAXPACKET], cvalue;
	char *ptr;
	int chksumlen = 0;

	// ptr points to beginning of buffer buf
	ptr = &buf[0];

	// Copy source IP address into buf (32 bits)
	memcpy (ptr, &iphdr.ip_src.s_addr, sizeof (iphdr.ip_src.s_addr));
	ptr += sizeof (iphdr.ip_src.s_addr);
	chksumlen += sizeof (iphdr.ip_src.s_addr);

	// Copy destination IP address into buf (32 bits)
	memcpy (ptr, &iphdr.ip_dst.s_addr, sizeof (iphdr.ip_dst.s_addr));
	ptr += sizeof (iphdr.ip_dst.s_addr);
	chksumlen += sizeof (iphdr.ip_dst.s_addr);

	// Copy zero field to buf (8 bits)
	*ptr = 0; ptr++;
	chksumlen += 1;

	// Copy transport layer protocol to buf (8 bits)
	memcpy (ptr, &iphdr.ip_p, sizeof (iphdr.ip_p));
	ptr += sizeof (iphdr.ip_p);
	chksumlen += sizeof (iphdr.ip_p);

	// Copy TCP length to buf (16 bits)
	svalue = htons (sizeof (tcphdr));
	memcpy (ptr, &svalue, sizeof (svalue));
	ptr += sizeof (svalue);
	chksumlen += sizeof (svalue);

	// Copy TCP source port to buf (16 bits)
	memcpy (ptr, &tcphdr.th_sport, sizeof (tcphdr.th_sport));
	ptr += sizeof (tcphdr.th_sport);
	chksumlen += sizeof (tcphdr.th_sport);

	// Copy TCP destination port to buf (16 bits)
	memcpy (ptr, &tcphdr.th_dport, sizeof (tcphdr.th_dport));
	ptr += sizeof (tcphdr.th_dport);
	chksumlen += sizeof (tcphdr.th_dport);

	// Copy sequence number to buf (32 bits)
	memcpy (ptr, &tcphdr.th_seq, sizeof (tcphdr.th_seq));
	ptr += sizeof (tcphdr.th_seq);
	chksumlen += sizeof (tcphdr.th_seq);

	// Copy acknowledgement number to buf (32 bits)
	memcpy (ptr, &tcphdr.th_ack, sizeof (tcphdr.th_ack));
	ptr += sizeof (tcphdr.th_ack);
	chksumlen += sizeof (tcphdr.th_ack);

	// Copy data offset to buf (4 bits) and
	// copy reserved bits to buf (4 bits)
	cvalue = (tcphdr.th_off << 4) + tcphdr.th_x2;
	memcpy (ptr, &cvalue, sizeof (cvalue));
	ptr += sizeof (cvalue);
	chksumlen += sizeof (cvalue);

	// Copy TCP flags to buf (8 bits)
	memcpy (ptr, &tcphdr.th_flags, sizeof (tcphdr.th_flags));
	ptr += sizeof (tcphdr.th_flags);
	chksumlen += sizeof (tcphdr.th_flags);

	// Copy TCP window size to buf (16 bits)
	memcpy (ptr, &tcphdr.th_win, sizeof (tcphdr.th_win));
	ptr += sizeof (tcphdr.th_win);
	chksumlen += sizeof (tcphdr.th_win);

	// Copy TCP in_cksum to buf (16 bits)
	// Zero, since we don't know it yet
	*ptr = 0; ptr++;
	*ptr = 0; ptr++;
	chksumlen += 2;

	// Copy urgent pointer to buf (16 bits)
	memcpy (ptr, &tcphdr.th_urp, sizeof (tcphdr.th_urp));
	ptr += sizeof (tcphdr.th_urp);
	chksumlen += sizeof (tcphdr.th_urp);

	return in_cksum ((unsigned short int *) buf, chksumlen);
}
// //////////////////////////////////////////////////////////////////////


#ifdef WIN32
// //////////////////////////////////////////////////////////////////////
_PRIVATE int netraw_win_ifconfig(
	_IN int sock, 
	_INOUT INTERFACE_INFO ilist[],
	_INOUT unsigned char macs[][6])
{
	unsigned long n;
	int r, ifs;

	r = WSAIoctl(sock, 
		SIO_GET_INTERFACE_LIST, 0, 0, 
		ilist, 
		MAX_IFACES  * sizeof(INTERFACE_INFO), 
		&n, 0, 0);

	if (r == SOCKET_ERROR)
	{
        	fprintf(stderr, "Failed calling WSAIoctl: %d\n", WSAGetLastError());
		return(-1);
	}

	ifs = n / sizeof(INTERFACE_INFO);

	return(ifs);
}
// //////////////////////////////////////////////////////////////////////
#else
// //////////////////////////////////////////////////////////////////////
_PRIVATE int netraw_ifconfig(
	_IN int sock, 
	_INOUT struct ifconf *ifconf, 
	_INOUT struct ifreq ifr[],
	_INOUT unsigned char macs[][6])
{
	int i, k, ifs;

	if (ioctl(sock, SIOCGIFCONF, ifconf) == -1)
		return(-1);

	ifs = ifconf->ifc_len / sizeof(ifr[0]);
#ifdef __linux__
	for (i = 0; (i < ifs) && (i < MAX_IFACES) ; i++)
	{
		if (ioctl(sock, SIOCGIFHWADDR, &ifr[i]))
			continue;

		for (k = 0 ; k < 6 ; k++)
			macs[i][k] = (unsigned char) ifr[i].ifr_hwaddr.sa_data[k];
	}

	if (ioctl(sock, SIOCGIFCONF, ifconf) == -1)
		return(-2);
#endif

	return(ifs);
}
// //////////////////////////////////////////////////////////////////////
#endif

