#ifndef NETRAW_H
#define NETRAW_H

#include <ifractal.h>

#ifndef WIN32

#define __FAVOR_BSD
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef __linux__
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#endif

#include <sys/ioctl.h>

#include <net/if.h>
#include <errno.h>

#endif


#define IP4_HDRLEN 20				 // IPv4 header length
#define TCP_HDRLEN 20				 // TCP header length, excludes options data

#define MAX_IFACES	20



#ifdef WIN32

int netraw_win_ifconfig(
	_IN int sock, 
	_INOUT INTERFACE_INFO ilist[],
	_INOUT unsigned char macs[][6]);

#else

int netraw_ifconfig(
	_IN int sock, 
	_INOUT struct ifconf *ifconf, 
	_INOUT struct ifreq ifr[],
	_INOUT unsigned char macs[][6]);

#endif


#ifndef __linux__

#define IP_MAXPACKET	65535
#define ICMP_ECHO 8

// from <linux/icmp.h>
struct icmphdr {
	uint8_t		type;
	uint8_t		code;
	uint16_t		checksum;
	union {
	struct {
		uint16_t	id;
		uint16_t	sequence;
	} echo;
	uint32_t	gateway;
	struct {
		//uint16_t	__unused;
		uint16_t	unused;
		uint16_t	mtu;
	} frag;
	} un;
};



#ifndef __LITTLE_ENDIAN_BITFIELD
#define __LITTLE_ENDIAN_BITFIELD
#endif

// from <sys/types.h> on linux
struct ip
{
#if defined(__LITTLE_ENDIAN_BITFIELD)
	uint8_t	ip_hl:4,
		ip_v:4;
#else
	uint8_t	ip_v:4,
		ip_hl:4;
#endif
#define IPVERSION	4
	uint8_t	ip_tos;
	uint16_t	ip_len;
	uint16_t	ip_id;
	uint16_t	ip_off;
	uint8_t	ip_ttl;
	uint8_t	ip_p;
	uint16_t	ip_sum;
	struct	in_addr ip_src;
	struct  in_addr ip_dst;
};


// From <netinet/ip_icmp.h>
struct icmp_ra_addr
{
  uint32_t ira_addr;
  uint32_t ira_preference;
};

struct icmp
{
  uint8_t  icmp_type;	/* type of message, see below */
  uint8_t  icmp_code;	/* type sub code */
  uint16_t icmp_cksum;	/* ones complement checksum of struct */
  union
  {
    unsigned char ih_pptr;		/* ICMP_PARAMPROB */
    struct in_addr ih_gwaddr;	/* gateway address */
    struct ih_idseq		/* echo datagram */
    {
      uint16_t icd_id;
      uint16_t icd_seq;
    } ih_idseq;
    uint32_t ih_void;

    /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */
    struct ih_pmtu
    {
      uint16_t ipm_void;
      uint16_t ipm_nextmtu;
    } ih_pmtu;

    struct ih_rtradv
    {
      uint8_t irt_num_addrs;
      uint8_t irt_wpa;
      uint16_t irt_lifetime;
    } ih_rtradv;
  } icmp_hun;
#define	icmp_pptr	icmp_hun.ih_pptr
#define	icmp_gwaddr	icmp_hun.ih_gwaddr
#define	icmp_id		icmp_hun.ih_idseq.icd_id
#define	icmp_seq	icmp_hun.ih_idseq.icd_seq
#define	icmp_void	icmp_hun.ih_void
#define	icmp_pmvoid	icmp_hun.ih_pmtu.ipm_void
#define	icmp_nextmtu	icmp_hun.ih_pmtu.ipm_nextmtu
#define	icmp_num_addrs	icmp_hun.ih_rtradv.irt_num_addrs
#define	icmp_wpa	icmp_hun.ih_rtradv.irt_wpa
#define	icmp_lifetime	icmp_hun.ih_rtradv.irt_lifetime
  union
  {
    struct
    {
      uint32_t its_otime;
      uint32_t its_rtime;
      uint32_t its_ttime;
    } id_ts;
    struct
    {
      struct ip idi_ip;
      /* options and then 64 bits of data */
    } id_ip;
    struct icmp_ra_addr id_radv;
    uint32_t   id_mask;
    uint8_t    id_data[1];
  } icmp_dun;
#define	icmp_otime	icmp_dun.id_ts.its_otime
#define	icmp_rtime	icmp_dun.id_ts.its_rtime
#define	icmp_ttime	icmp_dun.id_ts.its_ttime
#define	icmp_ip		icmp_dun.id_ip.idi_ip
#define	icmp_radv	icmp_dun.id_radv
#define	icmp_mask	icmp_dun.id_mask
#define	icmp_data	icmp_dun.id_data
};

typedef uint32_t tcp_seq; 

struct tcphdr {
     u_short th_sport;
     u_short th_dport;
     tcp_seq th_seq;
     tcp_seq th_ack;
     u_int   th_x2:4,
         th_off:4;
     u_char  th_flags;
     u_short th_win;   
     u_short th_sum;   
     u_short th_urp;   
};

#endif


// From Unix network programming
uint16_t in_cksum(uint16_t *addr, int len);
unsigned short int tcp4_in_cksum (struct ip iphdr, struct tcphdr tcphdr);

BROADCAST_CONTEXT * tcpraw_open(
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data); 

BROADCAST_CONTEXT * tcpraw_portscan(
	_IN char *dst_ip,
	_IN uint16_t ports[],	// vetor de portas terminado em 0.
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data); 

BROADCAST_CONTEXT * broadcast_portscan(
	uint16_t *ports,
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data);

#endif
