#include <ifractal.h>

#define ENTRADA_SCHED_WIN	"{\n" \
				"\t\"name\":\"Recoleta Nsr 500\",\n" \
		  		"\t\"path\":\"c:\\\\ifractal\",\n" \
				"\t\"cron\":\"44 15 * * *\",\n" \
				"\t\"proc\":\"c:\\\\ifractal\\\\bin\\\\recoleta_nsr.exe\",\n" \
				"\t\"args\":[\"--path\",\"\\\\conf\\\\\",\"--sub\",\"500\"]\n" \
				"}\n"

#define ENTRADA_SCHED_UNIX	"{\n" \
				"\t\"name\":\"Recoleta Nsr 500\",\n" \
		  		"\t\"path\":\"./\",\n" \
				"\t\"cron\":\"44 15 * * *\",\n" \
				"\t\"proc\":\"./bin/recoleta_nsr\",\n" \
				"\t\"args\":[\"--path\",\"./conf/\",\"--sub\",\"500\"]\n" \
				"}\n"

#define DESCRIPT		"Le todos os arquivos .nsr do PATH e subtrai N do NSR."

IF_GETOPT config[] = {
	{0, 'p', IF_GETOPT_TYPE_STRING, "path", "conf", 0, "Pasta dos arquivos .nsr (default: conf)."},
	{0, 's', IF_GETOPT_TYPE_NUMBER, "sub", "1000", 0, "Valor subtraido no nsr."},
	{0, 0, 0, 0, 0, 0, 0}
};



// ///////////////////////////////////////////////////////// //
int nsr_sub(char *file, int sub)
{
	char buf[50];
	FILE *fd;
	int nsr;

	fd = fopen(file, "r");
	fgets(buf, sizeof(buf), fd);
	fclose(fd);

	nsr = atoi(buf);
	if (nsr < sub)
		return(nsr);

	nsr -= sub;

	fd = fopen(file, "w");
	fprintf(fd, "%d\n", nsr);
	fclose(fd);

	return(nsr);
}
// ///////////////////////////////////////////////////////// //
int nsr_sub_iter(DIR_CONTEXT *ctx, FILE_CONTEXT *fctx, void *user_data)
{
	char *strsub = (char *) user_data;
	int sub = atoi(strsub);
	char suffix[] = ".nsr";
	char *p;
	int n;

	if (sub < 1)
		return(1);

	if (fctx->type != FILE_TYPE_REGULAR)
		return(0);
	
	if ((p = strstr(fctx->name, suffix)) == NULL)
		return(0);

	if (strlen(p) != strlen(suffix))
		return(0);

	n = nsr_sub(fctx->filename, sub);
	verbose(stdout, "NSR sub: %s: %d -> %d\n", fctx->name, n + sub, n);

	return(0);
}
// ///////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////// //
int main(int argc, char **argv)
{
	DIR_CONTEXT *ctx;
	int r;
	
	r = if_getopt(config, argc, argv);
	if ((r) || (!if_getopt_isChecked(config, "sub")))
	{
		if_help_header(argv[0], DESCRIPT);
		fprintf(stderr, "Ajuda:\n");
		if_getopt_help(config);

		fprintf(stderr, "\nUso:\n");
		fprintf(stderr, "\tshell$ %s --path <PATH> --sub <Valor subtraido>\n", argv[0]);

		fprintf(stderr, "\nExemplo:\n");
		fprintf(stderr, "\tshell$ %s --path log --sub 1000\n", argv[0]);
		fprintf(stderr, "\n");
#ifdef WIN32
		fprintf(stderr, "\nExemplo sched.json (win):\n");
		fprintf(stderr, ENTRADA_SCHED_WIN);
#else
		fprintf(stderr, "Exemplo sched.json (GNU/Linux):\n");
		fprintf(stderr, ENTRADA_SCHED_UNIX);
#endif
		fprintf(stderr, "\n");

		return(r);
	}

	ctx = fs_dir_new(if_getopt_getValue(config, "path"));

	fs_dir_iter(ctx, nsr_sub_iter, if_getopt_getValue(config, "sub"));

	fs_dir_free(ctx);

	return(0);
}
// ///////////////////////////////////////////////////////// //

