#include <netraw.h>

extern int errno;


uint16_t BROADCAST_PORTS[] = {22, 80, 139, 2051, 3000, 5432, 5900, 5901, 6000, 8080, 9000, 10000, 51000, 0};



// //////////////////////////////////////////////////////////////////////
_PUBLIC BROADCAST_CONTEXT * tcpraw_open(
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data)
{
	BROADCAST_CONTEXT *ctx;
	int sock;

#ifdef WIN32
	WSADATA WSData;
	if ( WSAStartup(MAKEWORD(2,2), &WSData) )
	{
		verbose(stderr, "ERROR: You need Winsock.\n");
		return(NULL);
	}

	if ((sock = WSASocket(AF_INET, SOCK_RAW, IPPROTO_TCP, 0, 0, 0)) == SOCKET_ERROR)
	{
		fprintf(stderr, "ERROR creating socket (%d)\n", WSAGetLastError());
	  	return(NULL);
	}

	// Set flag so socket expects us to provide IPv4 header.
	const int on = 1;
	if (setsockopt (sock, IPPROTO_IP, IP_HDRINCL, (char *) &on, sizeof (on)) < 0)
	{
		fprintf(stderr, "setsockopt() failed to set IP_HDRINCL\n");
		return(NULL);
	}

	unsigned long int nonBlockingMode = 1;
	ioctlsocket(sock, FIONBIO, &nonBlockingMode);

#else
	if ((sock = socket(AF_INET, SOCK_RAW, IPPROTO_TCP)) < 0)
	{
		fprintf(stderr, "socket() failed to get socket descriptor for using ioctl()\n");
		return(NULL);
	}

	// Set flag so socket expects us to provide IPv4 header.
	const int on = 1;
	if (setsockopt (sock, IPPROTO_IP, IP_HDRINCL, &on, sizeof (on)) < 0)
	{
		fprintf(stderr, "setsockopt() failed to set IP_HDRINCL\n");
		return(NULL);
	}
#endif

	ctx = if_malloc(sizeof(BROADCAST_CONTEXT));
	memset(ctx, 0, sizeof(BROADCAST_CONTEXT));

	ctx->sock = sock;
	ctx->cb = cb;
	ctx->user_data = user_data;

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PRIVATE int tcpraw_fill_header(_IN int sock, char *dst_ip, _INOUT void *packet)
{
	struct sockaddr_in *src;
	unsigned char macs[MAX_IFACES][6];
	int k, ifs;
	struct
	{
		struct ip iphdr;
		struct tcphdr tcphdr;
	} *frame = packet;

#ifdef WIN32
	INTERFACE_INFO InterfaceList[MAX_IFACES];

	ifs = netraw_win_ifconfig(sock, InterfaceList, macs);
	for (k = 0; k < ifs ; k++)
	{
		src = (struct sockaddr_in *) &(InterfaceList[k].iiAddress);

		if (((unsigned char *) &src->sin_addr.s_addr)[0] == 127)
			continue;

		frame->iphdr.ip_src.s_addr = src->sin_addr.s_addr;
	}
#else
	struct ifconf ifconf;
	struct ifreq ifr[MAX_IFACES];
	struct ifreq *ifr_ptr;
	int n = 0;

	ifconf.ifc_buf = (char *) ifr;
	ifconf.ifc_len = sizeof(ifr);
	memset(macs, 0, sizeof(macs));
	ifs = netraw_ifconfig(sock, &ifconf, ifr, macs);

	for (k = 0, ifr_ptr = ifr ; k < ifs ; k++, ifr_ptr = (struct ifreq *)(n + (char *) ifr_ptr))
	{
#ifdef __MACH__
		n = sizeof(struct ifreq) - sizeof(struct sockaddr) + MAX(sizeof(struct sockaddr), ifr_ptr->ifr_addr.sa_len);

		src = (struct sockaddr_in *) &(ifr_ptr->ifr_addr);
#else
		src = (struct sockaddr_in *) &ifr[k].ifr_addr;
#endif
		if (src->sin_family != AF_INET)
			continue;

		if (((unsigned char *) &src->sin_addr.s_addr)[0] == 127)
			continue;

		frame->iphdr.ip_src.s_addr = src->sin_addr.s_addr;
	}
#endif
  
	frame->iphdr.ip_hl = 5;
	frame->iphdr.ip_v = 4;
	frame->iphdr.ip_tos = 16;
	frame->iphdr.ip_len = sizeof(struct ip) + sizeof(struct tcphdr);
	frame->iphdr.ip_id = htons(54321);
	frame->iphdr.ip_off = 0;
	frame->iphdr.ip_ttl = 64;
	frame->iphdr.ip_p = IPPROTO_TCP;
	frame->iphdr.ip_sum = 0;

	// Source IP, modify as needed, spoofed
	//frame->iphdr.ip_src.s_addr = inet_addr(src_ip);
	frame->iphdr.ip_dst.s_addr = inet_addr(dst_ip);

	//frame->tcphdr.th_dport = htons(dst_port);
	frame->tcphdr.th_sport = htons(1025);
	frame->tcphdr.th_seq = htonl(0);
	frame->tcphdr.th_ack = htonl (0);

	frame->tcphdr.th_x2 = 0;
	frame->tcphdr.th_off = TCP_HDRLEN / 4;
	frame->tcphdr.th_flags = 0x02;
	frame->tcphdr.th_win = htons (65535);
	frame->tcphdr.th_urp = htons (0);

	//frame->tcphdr.th_sum = tcp4_in_cksum(frame->iphdr, frame->tcphdr);
	//frame->iphdr.ip_sum = in_cksum((unsigned short *) &frame, (sizeof(struct ip) + sizeof(struct tcphdr)));

	return(ifs);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
_PRIVATE int tcpraw_portscan_in(
	_IN BROADCAST_CONTEXT *ctx,
	_IN struct sockaddr_in *dst,
	_IN uint16_t ports[],
	_INOUT void *packet)
{
	struct
	{
		struct ip iphdr;
		struct tcphdr tcphdr;
	} *frame = packet;
	int i;

	for (i = 0 ; ports[i] != 0 ; i++)
	{
		frame->tcphdr.th_dport = htons(ports[i]);
		frame->tcphdr.th_sum = tcp4_in_cksum (frame->iphdr, frame->tcphdr);
		frame->iphdr.ip_sum = in_cksum((unsigned short *) frame, (sizeof(struct ip) + sizeof(struct tcphdr)));
        
#ifdef WIN32
		// TODO - Não é possivel enviar pacotes tcp utilizando SOCK_RAW
		// Esta chamada não vai funcionar
		return(0);

		if (sendto(ctx->sock, (char *) frame, IP4_HDRLEN + TCP_HDRLEN, 0, (struct sockaddr *) dst, sizeof(struct sockaddr_in)) == SOCKET_ERROR)
		{
			fprintf(stderr, "sendto() failed (%d)\n", WSAGetLastError());
			return(-1);
		}
#else
		if (sendto(ctx->sock, frame, IP4_HDRLEN + TCP_HDRLEN, 0, (struct sockaddr *) dst, sizeof (struct sockaddr)) < 0)
		{
			fprintf(stderr, "sendto() failed (%d)\n", errno);
			return(-1);
		}
#endif
	}

	return(0);
}
// //////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
BROADCAST_CONTEXT * tcpraw_portscan(
	_IN char *dst_ip,
	_IN uint16_t ports[],
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data)
{
	BROADCAST_CONTEXT *ctx = tcpraw_open(cb, user_data);
	struct sockaddr_in dst;
	struct
	{
		struct ip iphdr;
		struct tcphdr tcphdr;
	} packet;

	if (ctx == NULL)
		return(NULL);

	dst.sin_family = AF_INET;
	dst.sin_addr.s_addr = inet_addr(dst_ip);

	tcpraw_fill_header(ctx->sock, dst_ip, &packet);
      
	tcpraw_portscan_in(ctx, &dst, ports, &packet);

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////////
BROADCAST_CONTEXT * broadcast_portscan(
	uint16_t *ports,
	_IN BROADCAST_RESPONSE_CALLBACK cb, 
	_INOUT void *user_data)
{
	BROADCAST_CONTEXT *ctx = tcpraw_open(cb, user_data);
	struct sockaddr_in dst;
	struct
	{
		struct ip iphdr;
		struct tcphdr tcphdr;
	} packet;
	unsigned char j;

	if (ctx == NULL)
		return(NULL);

	if ((ports == NULL) || (ports[0] == 0))
		ports = BROADCAST_PORTS;

	tcpraw_fill_header(ctx->sock, "127.0.0.1", &packet);
	packet.iphdr.ip_dst.s_addr = packet.iphdr.ip_src.s_addr;

	dst.sin_family = AF_INET;
	dst.sin_addr.s_addr = packet.iphdr.ip_src.s_addr;

	for (j = 1 ; j < 255 ; j++)
	{
		((unsigned char *) &dst.sin_addr.s_addr)[3] = j;
		((unsigned char *) &packet.iphdr.ip_dst.s_addr)[3] = j;
		tcpraw_portscan_in(ctx, &dst, ports, &packet);
		broadcast_recv(ctx->sock, ctx->cb, ctx->user_data);
	}

	return(ctx);
}
// //////////////////////////////////////////////////////////////////////



#ifdef STANDALONE
// //////////////////////////////////////////////////////////////////////
int tcp_postscan_callback(char *ip, int port, BROADCAST_DATA *data, size_t len, void *user_data)
{
	struct
	{
		struct ip iphdr;
		struct tcphdr tcphdr;
	} frame;
	int sport;

	if (len > sizeof(frame))
		memcpy(&frame, data->data, sizeof(frame));
	else
		memcpy(&frame, data->data, len);

	sport = ((frame.tcphdr.th_sport & 0xFF) << 8) + (frame.tcphdr.th_sport >> 8);

	printf("%s:%d flags: %d (%d) proto: %d\n", 
		ip, sport, 
		frame.tcphdr.th_flags, 
		(int) len, 
		frame.iphdr.ip_p);
	
	return(0);
}
// //////////////////////////////////////////////////////////////////////
int main (int argc, char **argv)
{
	time_t start = time(NULL);
	BROADCAST_CONTEXT *ctx;
	uint16_t ports[argc];
	int i;

	if (argc < 3)
	{
		fprintf(stderr, "\nUso:\n\tshell$ %s <IP_DEST> <PORT 1> ... <PORT N>\n\n", argv[0]);
		return(1);
	}

	for (i = 0 ; (i + 2) < argc ; i++)
		ports[i] = atoi(argv[i + 2]);
	ports[i] = 0;

	ctx = tcpraw_portscan_broadcast(ports, tcp_postscan_callback, NULL); 
	do
	{
		broadcast_events_pending(ctx);
		if_sleep(10);
	}
	while ((time(NULL) - start) < 30);

	broadcast_free(ctx);

	return(0);
}
// //////////////////////////////////////////////////////////////////////
#endif

