#include <ifractal.h>
#include <result_config.h>

#define MODULE			"TUNNEL"
#define TUNNEL_SERVER		"http://tunnel.ifractal.srv.br/"

#ifdef WIN32
#define TUNNEL_INI		"conf\\tunnel.ini"
#else
#define TUNNEL_INI		"conf/tunnel.ini"
#endif

#define IF_HTTP_200		"HTTP/1.1 200 OK\r\n"

#define SERVER_HEADER		"Server: "
#define TOKEN_HEADER		"Token: "
#define TIMEOUT_HEADER		"Timeout: "
#define REMOTE_HEADER		"Remote: "
#define STREAM_HEADER		"Stream: "
#define DOWNLOAD_HEADER		"Download: "
#define UPLOAD_HEADER		"Upload: "

#define MIME_OCTETSTREAM	"application/octet-stream"
#define MIME_PLAIN		"text/plain"
#define MIME_JSON		"text/json"

#define TUNNEL_AGENT		"Tunnel SIIN"

#define CSV_TEMPLATE		"{\n" \
"	'globals':{'source':'parser_csv2json'},\n" \
"	'keys':['name','port'],\n" \
"	'fields':[\n" \
"			{\n" \
"				'csv_name':'name',\n" \
"				'name':'name',\n" \
"				'formatting_function_calls':[{'function_definition_id':1}]\n" \
"			},\n" \
"			{\n" \
"				'csv_name':'port',\n" \
"				'name':'port',\n" \
"				'formatting_function_calls':[{'function_definition_id':1}]\n" \
"			}\n" \
"		]\n" \
"}"


typedef size_t (*CURL_STREAM_CALLBACK)(void *buf, size_t size, size_t nitems, void *userdata);

typedef enum
{
	TUNNEL_TYPE_ADMIN,
	TUNNEL_TYPE_CLIENT,
	TUNNEL_TYPE_OBSERVER,
} IF_TUNNEL_TYPE;

typedef enum
{
	TUNNEL_STATE_FIRST,
	TUNNEL_STATE_HEADER,
	TUNNEL_STATE_REQUEST,
	TUNNEL_STATE_WAIT_REQUEST,
	TUNNEL_STATE_WAIT_RESPONSE,
	TUNNEL_STATE_RESPONSE,
	TUNNEL_STATE_END,
	TUNNEL_STATE_FREE
} TUNNEL_STATE;

typedef enum
{
	TUNNEL_SESSION_WS,
	TUNNEL_SESSION_STREAM,
	TUNNEL_SESSION_ERROR,
} TUNNEL_SESSION_TYPE;

typedef enum
{
	TUNNEL_SESSION_STATE_FIRST,
	TUNNEL_SESSION_STATE_WAIT,
	TUNNEL_SESSION_STATE_WS,
	TUNNEL_SESSION_STATE_RETURN,
	TUNNEL_SESSION_STATE_END,
	TUNNEL_SESSION_STATE_ERROR,
	TUNNEL_SESSION_STATE_LEN,
} TUNNEL_SESSION_STATE;

typedef struct _TUNNEL_SESSION TUNNEL_SESSION;
typedef TUNNEL_SESSION_STATE (*TUNNEL_STATE_PERFOM)(TUNNEL_SESSION *, void *user_data);

struct _TUNNEL_SESSION
{
	TUNNEL_SESSION_TYPE type;
	TUNNEL_SESSION_STATE state;
	URL *tunnel;
	char port[PORT_LEN];
	char token[PATH_LEN];
	time_t timeout;
	time_t start;
	char *clientid;
	JSON_VALUE *info;
	uint8_t *up_data;
	size_t up_len;
	size_t up_pos;
	uint8_t *down_data;
	size_t down_len;
	size_t down_pos;
	char header_cmd[PATH_LEN];
	TUNNEL_STATE_PERFOM func[TUNNEL_SESSION_STATE_LEN];
};

typedef enum
{
	TUNNEL_STREAM_TYPE_SHELL,
	TUNNEL_STREAM_TYPE_PROXY,
	TUNNEL_STREAM_TYPE_DOWNLOAD,
	TUNNEL_STREAM_TYPE_UPLOAD,
} TUNNEL_STREAM_TYPE;
	

typedef struct
{
	TUNNEL_STREAM_TYPE type;
	void *thread;
	THREAD_STATE state;
	int ssock;
	char tunnel_port[PORT_LEN];
	char clientid[PATH_LEN];
	char admin_ip[IP_LEN];
	union
	{
		struct
		{
			char filename[PATH_LEN];
			size_t size;
		};
		struct
		{
			char client_ip[IP_LEN];
			char client_port[PORT_LEN];
		};
	};
	void *pairs;
} TUNNEL_STREAM;

typedef struct
{
	char admin_ip[IP_LEN];
	char client_ip[IP_LEN];
	int admin_sock;
	int client_sock;
	time_t start;
	time_t last;
	size_t down;
	size_t up;
} TUNNEL_STREAM_PAIR;


TUNNEL_STREAM * tunnel_stream_new(int refport, char *clientid, TUNNEL_STREAM_TYPE, char **fields);
void tunnel_stream_free(TUNNEL_STREAM *);

TUNNEL_STREAM_PAIR * tunnel_stream_pair_new(char *admin_ip, char *client_ip, int sock);
void tunnel_stream_pair_free(TUNNEL_STREAM_PAIR *);


typedef struct
{
	TUNNEL_STREAM_TYPE type;
	IF_THREAD_LIST *pairs;
	char admin_port[PORT_LEN];
	union
	{
		struct
		{
			char filename[PATH_LEN];
			size_t size;
		};
		struct
		{
			char client_ip[IP_LEN];
			char client_port[PORT_LEN];
		};
	};
} TUNNEL_CLIENT_STREAM;

typedef struct
{
	TUNNEL_STREAM_TYPE type;
	IF_THREAD *thread;
	int admin_sock;
	union
	{
		struct
		{
			int client_sock;
		};
		struct
		{
#ifdef WIN32
			PROCESS_INFORMATION *pi;
			STARTUPINFO si;
#else
			int pid;
			int pin[2];
			int pout[2];
			int perr[2];
#endif
		};
	};
	time_t start;
	time_t last;
	size_t down;
	size_t up;
} TUNNEL_CLIENT_STREAM_PAIR;


TUNNEL_CLIENT_STREAM * tunnel_client_stream_new(TUNNEL_STREAM_TYPE type, char *header);
void tunnel_client_stream_free(TUNNEL_CLIENT_STREAM *);

TUNNEL_CLIENT_STREAM_PAIR * tunnel_client_stream_pair_new(TUNNEL_CLIENT_STREAM *);
void tunnel_client_stream_pair_free(TUNNEL_CLIENT_STREAM_PAIR *);


typedef struct
{
	char name[PATH_LEN];
	char port[PORT_LEN];
	char admin_ip[IP_LEN];
	char client_ip[IP_LEN];
	int ssock;
	int admin_sock;
	int client_sock;
	time_t start;
	time_t last;
	size_t down;
	size_t up;
} TUNNEL_REVERSE_PAIR;

TUNNEL_REVERSE_PAIR * reverse_new(char *port, char *name);
void reverse_free(TUNNEL_REVERSE_PAIR *);
int reverse_iter(TUNNEL_REVERSE_PAIR *, size_t *in, size_t *out);

int tunnel_isAdmin(char *ip, char **ips);

