#ifndef VT_API_H
#define VT_API_H

#include <ifractal.h>
#include <ifdevice.h>


#define VT_DEFAULT_CTRL_PORT	"2051"
#define VT_DEFAULT_SERV_PORT	"2050"

#define VT_NUM_SERVER		"99"
#define VT_NUM_READER		1

// Mensagens OFF
#define VT_CMD_HELLO		"1"	
#define VT_CMD_FORMAT_ALL	"49"
#define VT_CMD_BYE		"50"

#define VT_CMD_QTY_OFF_UNREAD	"11;1"
#define VT_CMD_QTY_OFF_ALL	"11;4"
#define VT_CMD_GET_OFF_UNREAD	"12;1"
#define VT_CMD_GET_OFF_ALL	"12;4"

#define VT_CMD_SET_DATE		"14"
#define VT_CMD_GET_DATE		"15"

#define VT_CMD_RECV_CONFIG	"4"
#define VT_CMD_SEND_CONFIG	"3"

#define VT_CMD_SEND_ID_TAB	"7"	// cartoes
#define VT_CMD_SEND_TIME_TAB	"8"	// jornadas
#define VT_CMD_SEND_MSG_TAB	"9"	// mensagens
#define VT_CMD_SEND_SIGN_TAB	"10"	// sinaleiro


// Eventos ONLINE
#define VT_EVT_SOLIC_ACESSO		1
#define VT_EVT_OFF_PENDENTE		2
#define VT_EVT_ACAO			3
#define VT_EVT_ACAO_PASS		21
#define VT_EVT_ACAO_LIBERA		30
#define VT_EVT_ACAO_BLOQUEIA		31
#define VT_EVT_SOLIC_TIMEOUT		5
#define VT_EVT_GIRO_COMPLETO		6
#define VT_EVT_RESPOSTA_SOLIC		51
#define VT_EVT_SOLIC_PASS		"0;3;21"

typedef enum
{
	VT_EVT_SOLIC_REM,	// Remetente
	VT_EVT_SOLIC_DES,	// Destinatario
	VT_EVT_SOLIC_CLASS,	
	VT_EVT_SOLIC_EVE,	// Evento
	VT_EVT_SOLIC_ID,
	VT_EVT_SOLIC_SEN,	// Sentido
	VT_EVT_SOLIC_CAN,	// Canal
	VT_EVT_SOLIC_LEN,
} VT_EVT_SOLIC_CSV;


#define VT_DISPLAY_LEN		16 + 1
#define VT_ID_LEN		25
#define VT_CONFIG_LEN		256
#define VT_IP_LEN		20

//typedef char 			VT_BOOL;
#define VT_FALSE		0
#define VT_TRUE			1


#define VT_ID_CSV_QUERY		"0;0;0;0;0;0;0;0;0;0;0;01/01/2099;0;01/01/2099;0;1;0;01/01;0;01/01;0;"
#define VT_PASSWORD_LEN		10
typedef struct
{
	char sentido;
	char auth;
	char msg1[VT_DISPLAY_LEN];
	char msg2[VT_DISPLAY_LEN];
	char password[VT_PASSWORD_LEN];
} VT_RESPONSE;


// Classe vetronic ///////////////////////////////////////////
int vetronic_init_conn(_INOUT IFDEVICE *);
void vetronic_close_conn(_INOUT IFDEVICE *);

int vetronic_get_qty_off(_IN IFDEVICE *);
JSON_VALUE * vetronic_get_unread_off(_IN IFDEVICE *);

time_t vetronic_get_time(_IN IFDEVICE *);
int vetronic_set_time(_IN IFDEVICE *, int diff); 	// DD/MM/AAAA HH/MI/SS

int vetronic_set_cartoes(_IN IFDEVICE *, _IN JSON_VALUE *lista);
// ///////////////////////////////////////////////////////////

#endif
