#include <ifractal.h>

#include <core.h>
#include <parser.h>


#define BARRAS_LEN	60


typedef struct
{
	char *tag;
	char *value;
	size_t len;
} TAG_BOLETO;


void calc_fator(_INOUT char *barras, _IN char *data);
void calc_linha_digitavel(_IN char *barras, _INOUT char *ld);

void calc_barras_bb_semreg(_INOUT char *barras);
void calc_barras_bb(_INOUT char *barras);
void calc_barras_bradesco(_INOUT char *barras);
void calc_barras_santander(_INOUT char *barras);
void calc_barras_caixa(_INOUT char *barras);
void calc_barras_itau(_INOUT char *barras);
void calc_barras_itau198(_INOUT char *barras);
void calc_barras_panamericano(_INOUT char *barras);
void calc_barras_citi(_INOUT char *barras);
void calc_barras_cef_sigcb(_INOUT char *barras);
void calc_barras_bgn(_INOUT char *barras);
void calc_barras_real(_INOUT char *barras);

JSON_VALUE * parser_santander(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_bradesco(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_bb(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_caixa(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_itau(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_itau198(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_panamericano(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_citi(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_cef_sigcb(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_bgn(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_real(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);

JSON_VALUE * parser_linha2barras(
	_INOUT char *data,
	_IN JSON_VALUE *result, 
	_IN JSON_VALUE *record, 
	_IN JSON_VALUE *templ, 
	_IN JSON_VALUE *data_source, 
	_IN JSON_VALUE *token,
	_IN JSON_VALUE *params);


