#ifndef CGI_H
#define CGI_H

#include <stdio.h>
#include <stdlib.h>

#include <ifractal.h>

#define JPEG_MAX_LEN		750000

typedef struct _IF_CGI_PARAM
{
	int length;
	char *name;
	char *value;
	char *filename;
	struct _IF_CGI_PARAM *next;
} IF_CGI_PARAM;


int cgi_get_content(_IN FILE *fd, _OUT char **ref);
char * query_decode(char *);

int cgi_get_contentLength();
char * cgi_get_boundary();
char * cgi_get_queryString();
IF_CGI_PARAM * cgi_get_GET_params();

IF_CGI_PARAM * cgi_param_new(char *name, char *filename);
IF_CGI_PARAM * cgi_get_POST_params(char *content, int content_length);
IF_CGI_PARAM * cgi_get_params(char *content, char *boundary, int content_length);
void cgi_params_free(IF_CGI_PARAM *);

IF_CGI_PARAM * cgi_get_param(_IN IF_CGI_PARAM *params, _IN char *name);
IF_CGI_PARAM * cgi_get_param_n(_IN IF_CGI_PARAM *params, _IN char *name, int n);
int cgi_params_count(_IN IF_CGI_PARAM *params);

typedef int (*IF_CGI_PARAM_ITER)(IF_CGI_PARAM *, void *);
int cgi_params_iter(_IN IF_CGI_PARAM *params, IF_CGI_PARAM_ITER, void *);

typedef int (*IF_CGI_STREAM_CALLBACK)(_IN unsigned char *data, _IN int length, _INOUT void *user_data);
void cgi_stream(_IN char *host, _IN char *port, _IN char *path, IF_CGI_STREAM_CALLBACK, void *user_data);

void cgi_stream_auth(
	_IN char *host, 
	_IN char *port, 
	_IN char *path, 
	_IN IF_CGI_STREAM_CALLBACK cb, 
	_INOUT void *user_data, 
	_IN char *user, 
	_IN char *pass);
#endif

