#include <ifractal.h>

typedef enum
{
	DIAGNOSTICO_ID_UNKNOWN,
	DIAGNOSTICO_ID_IFRACTAL,
	DIAGNOSTICO_ID_IFRACTAL_OLD,
	DIAGNOSTICO_ID_IPCAM_FOSCAM,
	DIAGNOSTICO_ID_IPCAM_ANDROID,
	DIAGNOSTICO_ID_IPCAM_DLINK,
	DIAGNOSTICO_ID_ROUTER_TP_LINK,
	DIAGNOSTICO_ID_ROUTER_DLINK,
	DIAGNOSTICO_ID_ROUTER_CISCO,
	DIAGNOSTICO_ID_TIBBO,
	DIAGNOSTICO_ID_HENRY7x,
	DIAGNOSTICO_ID_HENRY8x,
	DIAGNOSTICO_ID_HP_PRINTER,
	DIAGNOSTICO_ID_UNIX,
	DIAGNOSTICO_ID_UBUNTU,
	DIAGNOSTICO_ID_REDHAT,
	DIAGNOSTICO_ID_GSA,
	DIAGNOSTICO_ID_WINDOWS,
	DIAGNOSTICO_ID_ORACLE,
	DIAGNOSTICO_ID_HEXA,
	DIAGNOSTICO_ID_LEN
} DIAGNOSTICO_ID;


typedef enum
{
	DIAGNOSTICO_SERVICE_ID_UNKNOWN,
	DIAGNOSTICO_SERVICE_ID_SSH,
	DIAGNOSTICO_SERVICE_ID_HTTP,
	DIAGNOSTICO_SERVICE_ID_SIIN,
	DIAGNOSTICO_SERVICE_ID_HENRY7x,
	DIAGNOSTICO_SERVICE_ID_LEN
} DIAGNOSTICO_SERVICE_ID;

typedef enum
{
	DIAGNOSTICO_STATUS_IRRELEVANT,
	DIAGNOSTICO_STATUS_OK,
	DIAGNOSTICO_STATUS_UNREF,
	DIAGNOSTICO_STATUS_CONFLICT,
	DIAGNOSTICO_STATUS_SIIN_UNREACHABLE,
	DIAGNOSTICO_STATUS_MODULE_UNREACHABLE,
	DIAGNOSTICO_STATUS_MODULE_FAIL,
	DIAGNOSTICO_STATUS_UNREACHABLE,
	DIAGNOSTICO_STATUS_LEN
} DIAGNOSTICO_STATUS;


#ifdef __linux__
#define	DIAGNOSTICO_CONFIG_FLAG_PORT	1
#else
#define	DIAGNOSTICO_CONFIG_FLAG_PORT	16
#endif

#define	DIAGNOSTICO_CONFIG_FLAG_ICMP	2
#define	DIAGNOSTICO_CONFIG_FLAG_SIIN	4
#define	DIAGNOSTICO_CONFIG_FLAG_TIBBO	8
#define	DIAGNOSTICO_CONFIG_FLAG_FIN	32


typedef int (*DIAGNOSTICO_EVENT)(char *msgevt, void *);

typedef struct
{
	unsigned int flags;
	uint16_t ports[PATH_LEN];
	DIAGNOSTICO_EVENT event;
	void *user_data;
} DIAGNOSTICO_CONFIG;

JSON_VALUE * diagnostico_perform(DIAGNOSTICO_CONFIG *);
void diagnostico_show(JSON_VALUE *jreport, FILE *fd);


