#ifndef DIMEP_H
#define DIMEP_H

#include <ifractal.h>
#include <ifdevice.h>

#ifdef MODULE
#undef MODULE
#endif

#define MODULE		"DIMEP"

#define verbose3(ref,def,format,...)	verbose2(ref,def,stdout,MODULE,format, ##__VA_ARGS__)


#define DIMEP_START1			0xF8
#define DIMEP_START2			0xA0
#define DIMEP_END			0xF0

#define DIMEP_CMD_DATAHORA		0xC1
#define DIMEP_CMD_STATUS		0x80
#define DIMEP_CMD_ACK			0x70
#define DIMEP_CMD_COLETA_PRIMEIRA	0xCD
#define DIMEP_CMD_COLETA_PROXIMO	0xCE

#define DIMEP_CMD_ENVIA_NOME		0xC6
#define DIMEP_CMD_ENVIA_MATRICULA	0xC8
#define DIMEP_CMD_ENVIA_BIOMETRIA	0xC9

typedef enum
{ 
	DIMEP_CMD_UNKNOWN1_BYTE,
	DIMEP_CMD_UNKNOWN2_BYTE,
	DIMEP_CMD_OPER_BYTE,
	DIMEP_CMD_CONFIG_BYTES_LEN
} DIMEP_CMD_CONFIG_BYTES;

#define DIMEP_CMD_OPER_INSERT		0x00
#define DIMEP_CMD_OPER_DELETE		0x01

#define DIMEP_SUBHEADER_MAX_LEN		4
#define DIMEP_SUBDATA_MAX_LEN		128
#define DIMEP_COLETA_LEN		25

typedef enum
{
	DIMEP_HEADER_START1,
	DIMEP_HEADER_START2,
	DIMEP_HEADER_CMD1,
	DIMEP_HEADER_SEQUENCE,
	DIMEP_HEADER_MSB_SIZE,
	DIMEP_HEADER_LSB_SIZE,
	DIMEP_HEADER_LEN
} DIMEP_HEADER;

typedef struct
{
	unsigned char header[DIMEP_HEADER_LEN];
	size_t datalen;
	unsigned char *data;
	unsigned char checksum;
	size_t blocklen;
} DIMEP_PACK;

void dimep_pack_free(DIMEP_PACK *);

typedef struct
{
	unsigned char config[DIMEP_CMD_CONFIG_BYTES_LEN];
	unsigned char unknown[2];
	unsigned char pis[6];
	char nome[52];
	unsigned char senha[3];
} DIMEP_SEND_NAME;

typedef struct
{
	unsigned char config[DIMEP_CMD_CONFIG_BYTES_LEN];
	unsigned char separator[1];	// default 0x20
	unsigned char cracha[12];
	unsigned char pis[6];
} DIMEP_SEND_MATRICULA;

int dimep_connect(IFDEVICE4J *);
int dimep_close(IFDEVICE4J *);

#endif

