#include <ifractal.h>
#include <ifdevice.h>
#include <henry7x.h>
#include <henry8x.h>


// ///////////////////////////////////////////////////////// //
_PRIVATE char * henry7x_getErrMsg(int err)
{
	switch (err)
	{
		case -1: return("timeout");
		case -2: return("header invalido");
		case -3: return("falha sincronizacao");
		case -4: return("falha ao tentar ler/enviar pacote");
		case -5: return("falha ao tentar ler trailer");
		case -6: return("falha checksum");
		case -7: return("falha end byte");
		case 0: return("OK");
	}

	return("Reservado");
}
// ///////////////////////////////////////////////////////// //


// ////////////////////////////////////////////////////////////////////////
JSON_VALUE * henry7x_getInfo(IFDEVICE4J *dev, long sock)
{
	return(json_clone(((IFDEVICE *) dev)->config));
}
// ////////////////////////////////////////////////////////////////////////
time_t henry7x_getTime(IFDEVICE4J *dev, long sock)
{
	return(0);
}
// ////////////////////////////////////////////////////////////////////////
void henry7x_setTime(IFDEVICE4J *dev, int diff)
{
/*
	unsigned char header[HEADER_LEN] = {0xFE, HENRY_AJUSTA_HORA, 0x71, 0, HENRY_DATAHORA_LEN, 1, 0, 0};
	char buf[HENRY_DATAHORA_LEN];
	time_t now = time(NULL);
	struct tm *dt;
	unsigned char cs;
	int i;

	if (henry_envia_header(dev, header) < HEADER_LEN)
		return;

	now += 3600 * diff;
	dt = localtime(&now);

	buf[0] = dt->tm_year & 0xFF;
	buf[1] = dt->tm_mon + 1;
	buf[2] = dt->tm_mday;
	buf[3] = dt->tm_hour;
	buf[4] = dt->tm_min;

	// inicio do horario de verao
	buf[5] = 0;	// ano
	buf[6] = 0;	// mes
	buf[7] = 0;	// dia

	// fim do horario de verao
	buf[8] = 0;	// ano
	buf[9] = 0;	// mes
	buf[10] = 0;	// dia
	
	send_bytes(dev->sock, buf, HENRY_DATAHORA_LEN, -1);
	
	// Calcula "checksum" e envia
	for (i = 1, cs = buf[0] ; i < HENRY_DATAHORA_LEN ; i++)
		cs ^= buf[i];
	send_bytes(dev->sock, &cs, 1, -1);

	// le o header (retorno)
	if (henry_recebe_header(dev, header) < 1)
		return;
*/
}
// ////////////////////////////////////////////////////////////////////////
JSON_VALUE * henry7x_getEvents(IFDEVICE4J *dev4j, int nsr)
{
//	IFDEVICE *dev = (IFDEVICE *) dev4j;
	JSON_VALUE *eventos = NULL;
	return(eventos);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * henry7x_sendUsers(IFDEVICE4J *dev, JSON_VALUE *users)
{
	JSON_VALUE *res = json_array_new(1);
	return(res);
}
// ////////////////////////////////////////////////////////////////////////
JSON_VALUE * henry7x_getBio(IFDEVICE4J *dev4j, JSON_VALUE *users)
{
//	IFDEVICE *dev = (IFDEVICE *) dev4j;
	return(NULL);
}
// ////////////////////////////////////////////////////////////////////////
JSON_VALUE * henry7x_sendBio(IFDEVICE4J *dev4j, JSON_VALUE *users)
{
	JSON_VALUE *res = json_array_new(1);
//	void *params[] = {dev4j, res};

	//json_array_iter(users, henry7x_sendBio_iter, params);

	return(res);
}
// ////////////////////////////////////////////////////////////////////////
JSON_VALUE * henry7x_getUsers(IFDEVICE4J *dev)
{
	JSON_VALUE *users = json_array_new(1);
	return(users);
}
// ////////////////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////////////////
int henry7x_online_send_message(IFDEVICE *dev, int seq, int cod_evento, char *msg1, char *msg2, int timeout)
{
	return(0);
}
// ////////////////////////////////////////////////////////////////////////
int henry7x_online_auth(IFDEVICE *dev, int seq, JSON_VALUE *jevent, int *cod_cartao, int *cod_pessoa, int *cod_acesso)
{
	char *resp_tk[IFDEVICE_RESPONSE_LEN];
	char *txt = json_serialize(jevent);
	char *msg1, *msg2, auth;
	int timeout = 4;
	int len;

	verboseDEBUG(&(dev->log), "Online_auth: -->%s<--\n", txt);
	len = tokenizer('|', txt, resp_tk, IFDEVICE_RESPONSE_LEN);
	if (len < IFDEVICE_RESPONSE_COD_CARTAO)
	{
		henry7x_online_send_message(dev, seq, 30, "Falha", "Comunicacao", 2);
		goto henry7x_online_auth_end;
	}

	*cod_cartao = atoi(resp_tk[IFDEVICE_RESPONSE_COD_CARTAO]);
	*cod_pessoa = atoi(resp_tk[IFDEVICE_RESPONSE_COD_PESSOA]);
	*cod_acesso = atoi(resp_tk[IFDEVICE_RESPONSE_ACCESS_CODE]);

	if (resp_tk[IFDEVICE_RESPONSE_AUTH][0] == 'B')
	{
		auth = 30;
	}
	else
	{
		if (resp_tk[IFDEVICE_RESPONSE_TURN][0] == 'E')
			auth = 5;
		else if (resp_tk[IFDEVICE_RESPONSE_TURN][0] == 'S')
			auth = 6;
		else
			auth = 1;
	}

	msg1 = resp_tk[IFDEVICE_RESPONSE_MSG1];
	msg2 = resp_tk[IFDEVICE_RESPONSE_MSG2];

	henry7x_online_send_message(dev, seq, auth, msg1, msg2, timeout);

henry7x_online_auth_end:
	if_free(txt);

	return(0);
}
// ////////////////////////////////////////////////////////////////////////
int henry7x_online(IFDEVICE4J *dev, IFDEVICE4J_online_callback callback, void *ctx)
{
/*
	char *modo = json_object_get_string(dev->config, "MODO");
	char str_cod_pessoa[20], str_cod_cartao[20], str_cod_acesso[20];
	int cod_evento = 0, t, seq, size, err, tk_len, delay = 0;
	int cod_pessoa, cod_cartao, cod_acesso;
	char datahora[PATH_LEN] = "";
	unsigned char *pack = NULL;
	JSON_VALUE *jevent = NULL;
	char *head[5], *tk[10];
	char *cartao, *sentido;
	time_t last_event = 0;

	//if ((type != HENRY_ACESSO) || (modo[0] == 0) || (modo[0] != '1'))
	if ((modo[0] == 0) || (modo[0] != '1'))
	{
		verboseINFO(&(dev->log), "Online desabilitado - verifique ifponto.ini (MODO)\n");
		return(10);
	}

	//if ((henry7x_connect((IFDEVICE *) dev)) < 1)
	//	return(-1);

	memset(str_cod_pessoa, 0, 20);
	memset(str_cod_cartao, 0, 20);
	memset(str_cod_acesso, 0, 20);

	verboseDEBUG(&(dev->log), "Online Start\n");
	for (t = 6 ; t > 0 ; t--, jevent = NULL, pack = NULL, cod_evento = 0)
	{
		if (head[3][0] == '0')
		{
			last_event = time(NULL);
        
			snprintf(datahora, PATH_LEN, "20%c%c-%c%c-%c%c %s",
				tk[2][8], tk[2][9], tk[2][3], tk[2][4], tk[2][0], tk[2][1], tk[2] + 11);
        
			for (cartao = tk[1] ; cartao[0] == '0' ; cartao++)
				;
      
			char *req_list[] = {"cartao",cartao, "sentido",sentido, "canal",tk[5], "datahora",datahora};
			jevent = callback(sizeof(req_list) / sizeof(char *), req_list, ctx, "getUserOnline");
        
			// Responder para a catraca
			henry7x_online_auth(dev, seq, jevent, &cod_cartao, &cod_pessoa, &cod_acesso);

			snprintf(str_cod_cartao, sizeof(str_cod_cartao), "%d", cod_cartao);
			snprintf(str_cod_pessoa, sizeof(str_cod_pessoa), "%d", cod_pessoa);
			snprintf(str_cod_acesso, sizeof(str_cod_acesso), "%d", cod_acesso);
		}
		else if (strcmp(head[3] ,"81") == 0)
		{
			char *req_list[] = {"sentido",sentido, "cod_cartao",str_cod_cartao, "cod_pessoa",str_cod_pessoa, "cod_acesso",str_cod_acesso};
			jevent = callback(sizeof(req_list) / sizeof(char *), req_list, ctx, "turnConfirmation");
		}
		else
		{
			verboseDEBUG(&(dev->log), "Online - codigo: %s.\n", head[3]);
		}
        
		json_value_free(jevent);
		if_free(pack);
	}
	verboseDEBUG(&(dev->log), "Online End\n");

	//henry7x_close((IFDEVICE *) dev);

	return(delay);
*/
	return(30);
}
// ////////////////////////////////////////////////////////////////////////
void henry7x_init(IFDEVICE4J *dev)
{
	dev->getInfo = henry7x_getInfo;
	dev->getTime = henry7x_getTime;
	dev->setTime = henry7x_setTime;
	dev->sendUsers = henry7x_sendUsers;
	dev->getUsers = henry7x_getUsers;
	dev->sendBio = henry7x_sendBio;
	dev->getBio = henry7x_getBio;
	dev->getEvents = henry7x_getEvents;
	dev->online = henry7x_online;
	dev->free = NULL;
}
// ////////////////////////////////////////////////////////////////////////


// ///////////////////////////////////////////////////////// //
// Retorna Henry Checksum (XOR a partir do byte 1)
unsigned char henry7x_checksum(_IN unsigned char *data, _IN int size)
{
	unsigned char checksum;
	int i, data_len;

	data_len = size;
	checksum = ((data_len >> 8) & 0xFF) ^ (data_len & 0xFF);
	for (i = 0 ; i < size ; i++)
		checksum ^= data[i];

	return(checksum);
}
// ///////////////////////////////////////////////////////// //

/* ///////////////////////////////////////////////////////// //
int henry7x_read_bytes(IFDEVICE *dev, void *buf, int qtd, int timeout)
{
	int n = read_bytes(dev->sock, buf, qtd, timeout);
	char *log;

	if (n < 1)
		return(n);

	log = siin_hexlog((unsigned char *) buf, n);
	verboseDEBUG(&(dev->log), "iFractal <-- leitor   bytes: %d\n%s\n\n", n, log);
	if_free(log);
	fflush(stdout);

	return(n);
}
// ///////////////////////////////////////////////////////// //
int henry7x_send_bytes(IFDEVICE *dev, void *buf, int qtd, int timeout)
{
	char *log = siin_hexlog((unsigned char *) buf, qtd);

	verboseDEBUG(&(dev->log), "iFractal --> leitor   bytes: %d\n%s\n\n", qtd, log);
	if_free(log);
	fflush(stdout);

	return(send_bytes(dev->sock, buf, qtd, timeout));
}
// ///////////////////////////////////////////////////////// */

