#ifndef IFRACTAL_H
#define IFRACTAL_H


#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
#include <ws2tcpip.h>
#include <process.h>


#define COBJMACROS
#include <mscoree.h>

#include <iphlpapi.h>


#else

#ifdef __APPLE__
#include <sys/param.h>
#include <sys/mount.h>
#else
#include <sys/statfs.h>
//__asm__(".symver memcpy,memcpy@GLIBC_2.2.5");
#endif

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dlfcn.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pthread.h>
#include <ifaddrs.h>

#endif

#ifndef MSVC
#include <stdint.h>
#endif

#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <ctype.h>

#include <inttypes.h>
#include <assert.h>

#include <ornamentos.h>
#include <ifractal_utils.h>
#include <cgi.h>
#include <if_common_net.h>
#include <ifractal_threads.h>
#include <ifractal_iface_module.h>
#include <if_string.h>

#include <json.h>
#include <siin.h>
#include <if_vetor.h>

#include <url.h>
#include <parser.h>
#include <filesystem.h>
#include <proc_manager.h>
#include <broadcast.h>
#include <netraw.h>
#include <re.h>

#ifdef WIN32
#include <w32_utils.h>
#else
#include <unix_utils.h>
#endif

#define CONST2STR(def)		#def

void if_help_header2(char *app_name, char *descript, int va, int vb, int vc, int rev, time_t unixtime);
#ifdef FWVER_A
#define if_help_header(x,y)	if_help_header2(x,y,FWVER_A,FWVER_B,FWVER_C,FWREV,RELEASE_UNIXTIME)
#else
#define if_help_header(x,y)	if_help_header2(x,y,0,0,0,0,0)
#endif


#define RESTART_RETURN		127
#define EXIT_RETURN		126

#define TXT_ENCODE_RAW		"raw"
#define TXT_ENCODE_B64		"b64"
#define TXT_ENCODE_B58		"b58"
#define TXT_ENCODE_HEX		"hex"

int if_str_decoder(char *txt, unsigned char **bin, char *format);
int if_str_encoder(unsigned char *bin, size_t, char **txt, char *format);


#define PROXY_PARAM_URL		"proxy_url"

#define IFRACTAL_CLIENT_ID	"client_id"
#define IFRACTAL_CLIENT_ID_TOKEN	\
"1824712981027019385211055523560n27nx1rm1z0381964428810975665933446128475648233"


#define IFRACTAL_URL		"ifractal_url"
#define IFRACTAL_URL_TOKEN	\
"117450284102701938521105559644622948954930381964428810975665933446128475648233" \
"951941511609433057270365759591953092186117381932611793105118548074462379962749" \
"567351885752724891227938183011949129833673362440656643086021394946395224737190" \
"837449448255379774726847104047534646208046684259069491293313677028989152104752" \
"644695848653836736222626099124608051243884390451244136549762780797715691435997"

typedef struct
{
	uint16_t verbosity;
	char source[NAME_LEN];
} IFLOG;

int verbose_in(IFLOG *, int def, char *format, ...);

#define verboseFATAL(log,format,...)    verbose_in(log, 1, format, ##__VA_ARGS__)
#define verboseERROR(log,format,...)    verbose_in(log, 2, format, ##__VA_ARGS__)
#define verboseWARN(log,format,...)    verbose_in(log, 3, format, ##__VA_ARGS__)
#define verboseINFO(log,format,...)    verbose_in(log, 4, format, ##__VA_ARGS__)
#define verboseDEBUG(log,format,...)    verbose_in(log, 5, format, ##__VA_ARGS__)

int rc4(_IN char *key, _IN char *plaintext, _INOUT unsigned char *ciphertext);
int rc4bin(_IN char *key, _IN unsigned char *datain, _IN size_t len, unsigned char *dataout);


typedef struct _MODSIIN
{
#ifdef WIN32
	HINSTANCE handle;
#else
	void *handle;				/*!< Ponteiro de referencia de linkagem. */
#endif
	int (*init)(struct _MODSIIN *);		/*!< Ponteiro para funcao de inicializacao do modulo. */
	int (*finalize)(struct _MODSIIN *);	/*!< Ponteiro para funcao de finalizacao. */
	char path[PATH_LEN];			/*!< PATH web. */
	struct _MODSIIN *next;
	IF_GETOPT *configs;
	IF_THREAD_FUNC run;			/*!< Ponteiro para funcao run. */
} MODSIIN;

typedef struct
{
	IF_GETOPT *configs;
	unsigned int thread_id;
	int serversock;
	char *webport;
	char *webpath;
	IF_THREAD_LIST *th_list;		/*!< Pool de threads */
	MODSIIN *modules;
	THREAD_STATE alive;
	BROADCAST_CONTEXT *broadcast;
} MODSIIN_CONTEXT;

THREAD_STATE modweb_idle(MODSIIN_CONTEXT *ctx, void *user_data);


typedef struct
{
	int (*func)(MODSIIN_CONTEXT *, THREAD_STATE (*)(MODSIIN_CONTEXT *, void *user_data), void *user_data);
	char *name;
#ifdef WIN32
	PROCESS_INFORMATION pi;
#else
	int pid;
#endif
} MODWEB_PROC;


MODSIIN_CONTEXT * if_modweb_context_new(IF_GETOPT *);

int modweb_start_procs();
void modweb_kill_procs();
int modweb_wait_proc(int *kill);
void modweb_wait_procs();

typedef int MODSIIN_ITER_FUNC(MODSIIN *, void *user_data);

void * if_modweb_run(THREAD_STATE *, int id, void *);
int if_modweb_init(MODSIIN *);

#endif

