#ifndef IFRACTAL_IFACE_MODULE_H
#define IFRACTAL_IFACE_MODULE_H

#include <ifractal.h>


#define 	PATH_LEN		128
#define		ONE_MIN			60


typedef enum
{
	IF_MOD_ADMIN,	// Status da maquina
	IF_MOD_WEB,	// Servidor WEB modular 
	IF_MOD_TUNNEL,
	IF_MOD_CTRL,	// Controladoras de catraca/relogio

	IF_MOD_BIO_MANAGER = 100,
	IF_MOD_BIO_DEVICE = 101,
	IF_MOD_BIO_SEARCH = 102,

	IF_MOD_LEN
} IF_MOD_TYPE;

// Ajuste para permitir senha no tunel sem perder a compatibilidade de protocolo
#define AUTH_LEN	(PATH_LEN / 4)
typedef struct
{
	char origem[AUTH_LEN];
	char pass[AUTH_LEN];
	char contra[AUTH_LEN];
	char pad[AUTH_LEN];
} IF_TUNNEL_AUTH;

typedef struct
{
#ifdef MSVC
	int type;
#else
	int32_t type;
#endif
	unsigned char version[3];
	union
	{
		char origem[PATH_LEN];
		IF_TUNNEL_AUTH auth;
	};
} IF_MOD_HEADER;

typedef enum
{
	IF_SO_LINUX,
	IF_SO_MACOSX,
	IF_SO_BSD,
	IF_SO_WIN32
} IF_SO;



typedef struct _IF_MOD_CLASS
{
#ifdef WIN32
	HINSTANCE 	handle;
#else
	void *		handle;
#endif
	char path[PATH_LEN];
	struct _IF_MOD_CLASS *next;
} IF_MOD_CLASS;


// Interpretador de comandos
typedef char * (*IF_MOD_FUNC)(int argc, char **argv);

typedef struct
{
	char *cmd;
	int qty_params;
	char *info;
	IF_MOD_FUNC func;
} IF_MOD_CMD;


#endif
