#include <stdio.h>
#include <stdlib.h>


#include <ifractal_utils.h>
#include <json.h>


static char **emails = NULL;

enum
{
	IF_EMAILCPF_CSV_CPF,
	IF_EMAILCPF_CSV_EMAIL,
	IF_EMAILCPF_CSV_LEN = 3,
};



// ////////////////////////////////////////////////////////////
int getSizeInBytes(int size)
{
	return((size + 2) * (2 * sizeof(char *)));
}
// ////////////////////////////////////////////////////////////
char ** getEmails(char *file)
{
	char buf[PATH_LEN];
	char *tk[IF_EMAILCPF_CSV_LEN];
	int len, size = 2, pos = 0;
	char *cpf_clean;
	FILE *fd;

	if (file == NULL)
		return(NULL);

	fd = fopen(file, "r");
	if (fd == NULL)
	{
		fprintf(stderr, "Erro ao tentar ler: '%s'\n", file);
		return(NULL);
	}

	emails = malloc(getSizeInBytes(size));
	memset(emails, 0, getSizeInBytes(size));
	for (pos = 0 ; fgets(buf, PATH_LEN, fd) ; )
	{
		len = tokenizer(';', buf, tk, IF_EMAILCPF_CSV_LEN);
		if (len < IF_EMAILCPF_CSV_EMAIL)
			continue;

		if (pos > (size / 2))
		{
			size *= 2;
			emails = realloc(emails, getSizeInBytes(size));
		}

		for (cpf_clean = tk[IF_EMAILCPF_CSV_CPF] ; *cpf_clean == '0' ; cpf_clean++)
			;

		emails[2 * pos + 0] = strdup(cpf_clean);
		emails[2 * pos + 1] = strdup(tk[IF_EMAILCPF_CSV_EMAIL]);
		emails[2 * pos + 2] = NULL;
		emails[2 * pos + 3] = NULL;

		pos++;
	}

	fclose(fd);

	return(emails);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
char * getEmail(char *cpf)
{
	char *cpf_clean;
	int i;

	if (emails == NULL)
		return(NULL);

	for (cpf_clean = cpf ; *cpf_clean == '0' ; cpf_clean++)
		;

	// Procura email
	for (i = 0 ; emails[i] != NULL ; i += 2)
		if (strcmp(emails[i], cpf_clean) == 0)
			return(emails[i + 1]);

	return(NULL);
}
// ///////////////////////////////////////////////////////// */



// ////////////////////////////////////////////////////////////
FILE * getFDIN(char *file)
{
	FILE *fd;

	if ((file[0] == '-') && (file[1] == 0))
		return(stdin);

	fd = fopen(file, "rb");
	if (fd == NULL)
		fprintf(stderr, "Falha ao tentar abrir: '%s'.\n", file);

	return(fd);
}
// ////////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////////
void sortXML(char **tags)
{
	int i, j;
	char *aux;

	for (i = 0 ; tags[i] != NULL ; i += 2)
		for (j = i + 2 ; tags[j] != NULL ; j += 2)
			if (strcmp(tags[i], tags[j]) < 0)
			{
				aux = tags[i];
				tags[i] = tags[j];
				tags[j] = aux;

				aux = tags[i + 1];
				tags[i + 1] = tags[j + 1];
				tags[j + 1] = aux;
			}
}
// ////////////////////////////////////////////////////////////
int makeXML(char **tags)
{
	char *email = NULL;
	char *name, *value, *key;
	char tag[PATH_LEN] = "";
	int k, i;

	sortXML(tags);

	for (i = 0 ; tags[i] != NULL ; i += 2)
	{
		name = tags[i];
		value = tags[i + 1];
		for (k = 0 ; (name[k] != '/') && (name[k] != 0) ; k++)
			;

		if (name[k] == 0)
		{
			fprintf(stdout, "\t\t<%s><![CDATA[%s]]></%s>\n", name, value, name);
			continue;
		}

		if (strncmp(name, tag, k) != 0)
		{
			if (tag[0] != 0)
				fprintf(stdout, "\t\t</%s>\n", tag);
        
			strncpy(tag, name, k + 1);
			tag[k] = 0;
			fprintf(stdout, "\t\t<%s>\n", tag);
		}

		key = name + k + 1;
		fprintf(stdout, "\t\t\t<%s><![CDATA[%s]]></%s>\n", key, value, key);

		if (strcmp(key, "envio_cpf_cnpj") == 0)
			email = getEmail(value);

		if (email != NULL)
		{
			fprintf(stdout, "\t\t\t<envio_para><![CDATA[%s]]></envio_para>\n", email);
			email = NULL;
		}
	}

	if (tag[0] != 0)
		fprintf(stdout, "\t\t</%s>\n", tag);
        
	return(0);
}
// ////////////////////////////////////////////////////////////
int elementIter(char *name, JSON_VALUE *value, void *user_data)
{
	char **tags = (char **) user_data;
	int pos;

	if (strcmp(name, "_") == 0)
		return(0);

	for (pos = 0 ; tags[pos] != NULL ; pos += 2)
		;

	tags[pos] = name;
	tags[pos + 1] = json_get_string(value);
	
	return(0);
}
// ////////////////////////////////////////////////////////////
int recordIter(JSON_VALUE *record, void *user_data)
{
	JSON_VALUE *result = (JSON_VALUE *) user_data;
	JSON_VALUE *globals;
	int size, qty = 0;
	char **tags;


	globals = json_object_find(result, "globals");
	if (globals != NULL)
		qty = json_object_length(globals);

	qty += json_object_length(record);

	fprintf(stdout, "\t<boleto>\n");

	size = (qty + 2) * 2 * sizeof(char *);
	tags = if_malloc(size);
	memset(tags, 0, size);
	if (globals != NULL)
		json_object_iter(globals, elementIter, tags);

	json_object_iter(record, elementIter, tags);

	makeXML(tags);
	if_free(tags);

	fprintf(stdout, "\t</boleto>\n");

	return(0);
}
// ////////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////////
void writeXML(_IN JSON_VALUE *result)
{
	JSON_VALUE *records;

	records = json_object_find(result, "records");
	if (records != NULL)
		json_array_iter(records, recordIter, result);
}
// ////////////////////////////////////////////////////////////
void initXML()
{
	fprintf(stdout, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
	fprintf(stdout, "<boletos>\n");
}
// ////////////////////////////////////////////////////////////
// ////////////////////////////////////////////////////////////
void finalizeXML(_IN JSON_VALUE *result)
{
	char **tags;
	int qty, size;

	JSON_VALUE *details = json_object_find(result, "details");

	if (details != NULL)
	{
		qty = json_object_length(details);
		size = (qty + 2) * 2 * sizeof(char *);
		tags = if_malloc(size);
		memset(tags, 0, size);
        
		fprintf(stdout, "\t<trailer>\n");
		json_object_iter(details, elementIter, tags);
		makeXML(tags);
		fprintf(stdout, "\t</trailer>\n");
        
		if_free(tags);
	}

	fprintf(stdout, "</boletos>\n");
}
// ////////////////////////////////////////////////////////////




#ifdef STANDALONE

#define DESCRIPT	"Conversor de JSON (parser) para XML boleto."

static IF_GETOPT opts[] = {
	{0, 'f', IF_GETOPT_TYPE_STRING, "file", "-", 0, "Arquivo de entrada JSON (- para stdin)."},
	{0, 'r', IF_GETOPT_TYPE_STRING, "report", "", 0, "Arquivo relatorio de saida."},
	{0, 'e', IF_GETOPT_TYPE_STRING, "email", "", 0, "Arquivo com CPFs e Emails"},
	{0, 0, 0, 0, 0, 0, 0}
};



// ////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	JSON_VALUE *result;
	FILE *fd_in;
	int r;

	r = if_getopt(opts, argc, argv);
	if (	(r) ||
		!if_getopt_isChecked(opts, "report")
	   )
	{
		if_help_header(argv[0], DESCRIPT);
		fprintf(stderr, "Ajuda:\n");
		if_getopt_help(opts);

		fprintf(stderr, "\nUso:\n");
		fprintf(stderr, "\tshell$ %s -f <JSON> -r <RELATORIO> [-e <CPFs>]\n", argv[0]);
		fprintf(stderr, "Exemplo:\n\tshell$ %s -f resultado.json -r relat.txt -e emails.csv > final.xml\n\n", argv[0]);
		fprintf(stderr, "\n");

		return(r);
	}

	if (if_getopt_isChecked(opts, "email"))
		getEmails(if_getopt_getValue(opts, "email"));

	if ((fd_in = getFDIN(if_getopt_getValue(opts, "file"))) == NULL)
		return(2);

	result = json_parse_file(fd_in);
	fclose(fd_in);

	if (result == NULL)
	{
		fprintf(stderr, "JSON invalido.\n");
		return(3);
	}

	initXML();
	writeXML(result);
	finalizeXML(result);

	return(0);
}
// ////////////////////////////////////////////////////////////
#endif

