#include <ifractal.h>


/*
IF_SERVICE_PARAMETER_DEFINITION	par1 = 
		{"json_data", "dados", "JSON com os dados.", IF_SERVICE_TYPE_STRING, "", NULL, NULL};

IF_SERVICE_PARAMETER_DEFINITION	par2 = 
		{"json_config", "configuracoes", "JSON de configuracao.", IF_SERVICE_TYPE_STRING, "", NULL, NULL};

IF_SERVICE_PARAMETER_DEFINITION	par_end = 
		{NULL, NULL, NULL, 0, NULL, NULL, NULL};

IF_SERVICE_PARAMETER_DEFINITION	*params[] = {
		&par1,
		&par2,
		&par_end
	};
*/


// ////////////////////////////////////////////////////////////
int check_keys_iter(JSON_VALUE *key, void *user_data)
{
	JSON_VALUE *line = (JSON_VALUE *) user_data;
	JSON_VALUE *field, *value, *line_field;
	char *v1, *v2;

	if (json_get_type(key) != JSON_OBJECT_TYPE)
		return(1);

	field = json_object_find(key, "field");
	if (field == NULL)
		return(1);

	value = json_object_find(key, "value");
	if (value == NULL)
		return(1);

	line_field = json_object_find(line, json_get_string(field));
	if (line_field == NULL)
		return(1);

	v1 = json_get_string(value);
	v2 = json_get_string(line_field);

	if (strcmp(v1, v2))
		return(1);
	
	return(0);
}
// ////////////////////////////////////////////////////////////
int get_config_iter(JSON_VALUE *config_line, void *user_data)
{
	JSON_VALUE *line = (JSON_VALUE *) user_data;
	JSON_VALUE *keys;
	int len, pos;

	if (json_get_type(config_line) != JSON_OBJECT_TYPE)
		return(0);

	keys = json_object_find(config_line, "keys");
	if (keys == NULL)
		return(0);

	if (json_get_type(keys) != JSON_ARRAY_TYPE)
		return(0);

	len = json_array_length(keys);
	pos = json_array_iter(keys, check_keys_iter, line);
	if (pos < len)
		return(0);

	return(1);
}
// ////////////////////////////////////////////////////////////
JSON_VALUE * get_config(JSON_VALUE *line, JSON_VALUE *config)
{
	int len, pos;

	len = json_array_length(config);
	pos = json_array_iter(config, get_config_iter, line);
	if (pos >= len)
		return(NULL);

	return(json_array_index(config, pos));
}
// ////////////////////////////////////////////////////////////
int make_line_iter(JSON_VALUE *field, void *user_data)
{
	void **line_params = user_data;
	JSON_VALUE *line = (JSON_VALUE *) line_params[0];
	JSON_VALUE *resp = (JSON_VALUE *) line_params[2];
	JSON_VALUE *jname, *jlength, *jfill, *jalign, *jdefault, *jvalue;
	char *buf, *name, *value = "";
	char align = 'l';
	char fill = ' ';
	int len, pos;

	jname = json_object_find(field, "name");
	if (jname == NULL)
		return(0);

	name = json_get_string(jname);

	jlength = json_object_find(field, "length");
	if (jlength == NULL)
		return(0);

	len = json_get_int(jlength);
	if (len < 1)
		return(0);

	jfill = json_object_find(field, "fill");
	if (jfill != NULL)
		fill = json_get_string(jfill)[0];

	jalign = json_object_find(field, "align");
	if (jalign != NULL)
		align = json_get_string(jalign)[0];

	jdefault = json_object_find(field, "default");
	if (jdefault != NULL)
		value = json_get_string(jdefault);

	jvalue = json_object_find(line, name);
	if (jvalue != NULL)
		value = json_get_string(jvalue);

	if (strlen(value) > len)
		value[len] = 0;

	buf = if_malloc(len + 1);
	memset(buf, fill, len);
	buf[len] = 0;

	if (align == 'r')
	{
		pos = len - strlen(value);
		strcpy(buf + pos, value);
	}
	else
		for (pos = 0 ; value[pos] != 0 ; pos++)
			buf[pos] = value[pos];

	json_array_add(resp, json_string_new(buf));

	if_free(buf);

	return(0);
}
// ////////////////////////////////////////////////////////////
int data_iter(JSON_VALUE *json_line, void *user_data)
{
	void **params = user_data;
	void *line_params[3];
	JSON_VALUE *config = (JSON_VALUE *) params[0];
	JSON_VALUE *resp = (JSON_VALUE *) params[1];
	int *line_n = (int *) params[2];
	JSON_VALUE *line_config, *fields, *line_resp;

	*line_n += 1;

	if (json_get_type(json_line) != JSON_OBJECT_TYPE)
	{
		verbose(stderr, "Regitro (%d) - deveria ser um objeto.\n", *line_n);
		return(1);
	}
	
	line_config = get_config(json_line, config);
	if (line_config == NULL)
	{
		verbose(stderr, "Regitro (%d) - nenhuma chave encontrada.\n", *line_n);
		return(1);
	}

	fields = json_object_find(line_config, "fields");
	if (fields == NULL)
	{
		verbose(stderr, "Regitro (%d) - configuracao de campos nao encontrada.\n", *line_n);
		return(1);
	}

	if (json_get_type(fields) != JSON_ARRAY_TYPE)
	{
		verbose(stderr, "Regitro (%d) - configuracao de campos invalida.\n", *line_n);
		return(1);
	}

	line_resp = json_array_new(2);
	json_array_add(resp, line_resp);

	line_params[0] = json_line;
	line_params[1] = line_n;
	line_params[2] = line_resp;
	json_array_iter(fields, make_line_iter, line_params);

	return(0);
}
/* ////////////////////////////////////////////////////////////
JSON_VALUE * execute_json2fixo(
	_INOUT IF_SERVICE_CONTEXT *context, 
	_IN IF_SERVICE *service,
	_IN IF_SERVICE_PARAMETER *params) 
{
	void *iter_params[3];
	char *data = service_get_parameter_value(params, "json_data");
	char *config = service_get_parameter_value(params, "json_config");
	JSON_VALUE *json_data, *json_config, *resp;
	int line_n = 0;

	json_data = json_parse_mem(data);
	if (json_data == NULL)
		return(json_parse_mem("'json de dados invalido.'"));

	if (json_get_type(json_data) != JSON_ARRAY_TYPE)
	{
		json_value_free(json_data);
		return(json_parse_mem("'json de dados invalido.'"));
	}

	json_config = json_parse_mem(config);
	if (json_config == NULL)
	{
		json_value_free(json_data);
		return(json_parse_mem("'json de configuracao invalido.'"));
	}

	if (json_get_type(json_config) != JSON_ARRAY_TYPE)
	{
		json_value_free(json_data);
		json_value_free(json_config);
		return(json_parse_mem("'json de configuracao invalido.'"));
	}

	resp = json_array_new(2);
	iter_params[0] = json_config;
	iter_params[1] = resp;
	iter_params[2] = &line_n;
	json_array_iter(json_data, data_iter, iter_params);

	json_value_free(json_data);
	json_value_free(json_config);

	return(resp);
}
// ///////////////////////////////////////////////////////// */


/*
IF_SERVICE services[] = {
	{"execute", "Gera arquivo de posicao fixa.", 
	"Gera arquivo de posicao fixa a partir de json de dados + json de configuracao.", 
	NULL, execute_json2fixo, params, NULL},
	{NULL, NULL, NULL, NULL, NULL, NULL}
};
*/


// ////////////////////////////////////////////////////////////
int out_line_iter(JSON_VALUE *line, void *user_data)
{
	fprintf(stdout, "%s", json_get_string(line));
	return(0);
}
// ////////////////////////////////////////////////////////////
int out_iter(JSON_VALUE *resp, void *user_data)
{
	if (json_get_type(resp) != JSON_ARRAY_TYPE)
	{
		fprintf(stdout, "%s\n", json_get_string(resp));
		return(1);
	}
	
	json_array_iter(resp, out_line_iter, NULL);
	fprintf(stdout, "\r\n");
	return(0);
}
// ////////////////////////////////////////////////////////////



// ////////////////////////////////////////////////////////////
int string_line_iter(JSON_VALUE *line, void *user_data)
{
	STRING_BUFFER *buf = (STRING_BUFFER *) user_data;

	string_append(buf, json_get_string(line));

	return(0);
}
// ////////////////////////////////////////////////////////////
int string_iter(JSON_VALUE *resp, void *user_data)
{
	STRING_BUFFER *buf = (STRING_BUFFER *) user_data;

	if (json_get_type(resp) != JSON_ARRAY_TYPE)
	{
		string_append(buf, json_get_string(resp));
		return(1);
	}
	
	json_array_iter(resp, string_line_iter, buf);
	string_append(buf, "\r\n");

	return(0);
}
// ////////////////////////////////////////////////////////////
char * json2fixo(char *temp, char *data)
{
	JSON_VALUE *jdata, *jconf, *jresp = NULL;
	STRING_BUFFER *buf;
	char *txt;

	jdata = json_parse_mem(data);
	if (jdata == NULL)
	{
		jresp = json_parse_mem("'json de dados invalido.'");
		goto json2fixo_err;
	}

	if (json_get_type(jdata) != JSON_ARRAY_TYPE)
	{
		json_value_free(jdata);
		jresp = json_parse_mem("'Formato json de dados invalido.'");
		goto json2fixo_err;
	}

	jconf = json_parse_mem(temp);
	if (jconf == NULL)
	{
		json_value_free(jdata);
		jresp = json_parse_mem("'json de configuracao invalido.'");
		goto json2fixo_err;
	}

	if (json_get_type(jconf) != JSON_ARRAY_TYPE)
	{
		json_value_free(jdata);
		json_value_free(jconf);
		jresp = json_parse_mem("'Formato json de configuracao invalido.'");
		goto json2fixo_err;
	}

	int line_n = 0;

	jresp = json_array_new(2);
	void *iter_params[] = {jconf, jresp, &line_n, NULL};
	json_array_iter(jdata, data_iter, iter_params);

	json_value_free(jdata);
	json_value_free(jconf);

json2fixo_err:
	if (jresp == NULL)
		return(strdup(""));

	buf = string_new("");

	json_array_iter(jresp, string_iter, buf);
	json_value_free(jresp);

	txt = strdup(string_get_text(buf));
	string_free(buf);

	return(txt);
}
// ////////////////////////////////////////////////////////////




#ifdef STANDALONE

static IF_GETOPT opts[] = {
	{0, 't', IF_GETOPT_TYPE_STRING, "template", "", 0, "Arquivo com template."},
	{0, 'd', IF_GETOPT_TYPE_STRING, "data", "", 0, "Arquivo com dados."},
	{0, 0, 0, 0, 0, 0, 0}
};

// ////////////////////////////////////////////////////////////
int main(int argc, char **argv)
{
	char *filename, *temp, *data, *resp;
	FILE *fd;
	int r;
	struct
	{
		char *filename;
		char **content;
	} pack[] = {
		{"template", &temp},
		{"data", &data},
		{NULL, NULL}
	};

	r = if_getopt(opts, argc, argv);
	if ((r < 0) || (!if_getopt_isChecked(opts, "template") || !if_getopt_isChecked(opts, "data")))
	{
		if_help_header(argv[0], "Gerador de arquivo de posicao fixa (CNAB).");
		fprintf(stderr, "Ajuda:\n");
		if_getopt_help(opts);

		fprintf(stderr, "\nUso:\n");
		fprintf(stderr, "\tshell$ %s  -t <TEMPLATE> -d <DADOS>\n\n", argv[0]);

		return(r);
	}

	for (int i = 0 ; pack[i].filename != NULL ; i++)
	{
		filename = if_getopt_getValue(opts, pack[i].filename);
		fd  = fopen(filename, "r");
		if (fd == NULL)
		{
			fprintf(stderr, "Falha ao tentar abrir: %s\n", filename);
			return(9);
		}
		cgi_get_content(fd, pack[i].content);

		fclose(fd);
	}

	resp = json2fixo(temp, data);

	if (resp == NULL)
		return(10);

	fprintf(stdout, "%s\r\n", resp);

	return(0);
}
// ////////////////////////////////////////////////////////////
#endif


