#include <ifractal.h>
#include <ifdevice.h>
#include <java_utils.h>

#include <jni.h>

#include <result_config.h>

#define VENDOR		"SourceAFIS"


// ///////////////////////////////////////////////////////////////////// //
JavaVM * scanner_java_init(JSON_VALUE *jconfig)
{
	static JavaVM *jvm = NULL;

	if (jvm != NULL)
		return(jvm);

	char *classpath = json_object_get_string(jconfig, "CLASSPATH");
	char *libpath = json_object_get_string(jconfig, "LIBRARY_PATH");
	char *stack = json_object_get_string(jconfig, "STACK");

	jvm = if_loadJVM(classpath, libpath, stack);
	return(jvm);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
SCANNER_RESULT scanner_java_enroll(
	JSON_VALUE *jconfig,
	uint8_t *img, size_t width, size_t height, uint32_t dpi, 
	_OUT uint8_t **data, _OUT size_t *datalen)
{
	JavaVM *jvm = scanner_java_init(jconfig);
	if (jvm == NULL)
		return(RESULT_ERRO_JAVA_INIT);

	char width_str[20];
	char height_str[20];
	char dpi_str[20];
	char *img_hex = bin2hex(img, width * height); 

	snprintf(width_str, sizeof(width_str), "%ld", width);
	snprintf(height_str, sizeof(height_str), "%ld", height);
	snprintf(dpi_str, sizeof(dpi_str), "%d", dpi);

	char *argv[] = {
		"width", width_str,
		"height", height_str,
		"dpi", dpi_str,
		"image", img_hex
	};
	int argc = sizeof(argv) / sizeof(char *);
	int r = if_JVM_callStaticBytesMethod(jvm, "com/ifractal/matcher/Matcher", "enroll", argc, argv, data, datalen);

	if_free(img_hex);

	if (r)
	{
		verbose(stderr, "callStaticBytesMethod error: %d\n", r);
		return(SCANNER_RESULT_EXTRACT_ERROR);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER_RESULT scanner_java_verify(
	JSON_VALUE *jconfig,
	uint8_t *templ, size_t templ_len, 
	uint8_t *img_bw8, size_t width, size_t height, uint32_t dpi)
{
	JavaVM *jvm = scanner_java_init(jconfig);
	if (jvm == NULL)
		return(RESULT_ERRO_JAVA_INIT);

	char width_str[20];
	char height_str[20];
	char dpi_str[20];
	char *img_hex = bin2hex(img_bw8, width * height); 
	char *templ_hex = bin2hex(templ, templ_len);

	snprintf(width_str, sizeof(width_str), "%ld", width);
	snprintf(height_str, sizeof(height_str), "%ld", height);
	snprintf(dpi_str, sizeof(dpi_str), "%d", dpi);

	int64_t value = 0;
	char *argv[] = {
		"width", width_str,
		"height", height_str,
		"dpi", dpi_str,
		"image", img_hex,
		"template", templ_hex
	};
	int argc = sizeof(argv) / sizeof(char *);
	int r = if_JVM_callStaticInt64Method(jvm, "com/ifractal/matcher/Matcher", "verify", argc, argv, &value);

	if_free(img_hex);
	if_free(templ_hex);

	if ((r) || (value < 40))
		return(SCANNER_RESULT_VERIFY_ERROR);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
SCANNER_RESULT scanner_enroll_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	int qty_frames, char *id, int8_t *quality, void *user_data)
{
	SCANNER_RESULT sr = 0;
	uint8_t *data = NULL;
	size_t datalen = 0;
	char vendor[] = VENDOR;

	if ((scan == NULL) || (img_bw8 == NULL))
		return(SCANNER_RESULT_BIO_NOT_ENROLLED);

	*quality = 0;
	sr = scanner_java_enroll(scan->dev.config, img_bw8, width, height, scan->dpi, &data, &datalen);
	if (sr)
		return(sr);

	*quality = 10;
	if (scan->template_callback != NULL)
		scan->template_callback(scan, vendor, data, datalen, *quality, user_data);

	if_free(data);

	return(sr);
}
// ///////////////////////////////////////////////////////////////////// //
int scanner_matcher_get_template(SCANNER *scan, char *id, int finger, uint8_t **templ)
{
	char filename[PATH_LEN];
	char *path = json_object_get_string(scan->dev.config, "path");
	int r = scanner_get_template_filename(path, filename, PATH_LEN, id, finger);
	if (r < 1)
		return(-1);

	*templ = NULL;

	FILE *fd = fopen(filename, "r");
	size_t len = 0;

	if (fd == NULL)
		return(-2);

	len = fs_get_content(fd, (char **) templ);
	fclose(fd);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER_RESULT scanner_verify_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	char *id, int *finger, void *user_data)
{
	SCANNER_RESULT sr = SCANNER_RESULT_BIO_NOT_FOUND;
	int templ_len = 0;
	uint8_t *templ = NULL;
	int f;

	for (f = 1 ; f < 10 ; f++)
	{
		templ_len = scanner_matcher_get_template(scan, id, f, &templ);
		if (templ_len < 1)
			continue;

		sr = scanner_java_verify(scan->dev.config, templ, templ_len, img_bw8, width, height, scan->dpi);
		if_free(templ);

		if (!sr)
			break;
	}

	if (sr == 0)
		*finger = f;

	return(sr);
}
// ///////////////////////////////////////////////////////////////////// //
SCANNER_RESULT scanner_identify_image(
	SCANNER *scan, uint8_t *img_bw8, size_t width, size_t height, 
	char *id, size_t id_len, int *finger, int32_t *score, void *user_data)
{
	// TODO
	return(SCANNER_RESULT_IDENTIFY_ERROR);
}
// ///////////////////////////////////////////////////////////////////// //



#ifdef SCANNER_DEBUG

#include "matcher/fingerprint4.c"

extern IF_GETOPT ifponto_config[];
char id[] = "teste";

// ///////////////////////////////////////////////////////////////////// //
int scanner_matcher_save_template(SCANNER *scan, char *vendor, uint8_t *templ, size_t len, int8_t quality, void *user_data)
{
	char filename[PATH_LEN];
	char *path = json_object_get_string(scan->dev.config, "path");
	int r = scanner_get_template_filename(path, filename, PATH_LEN, id, 1);
	if (r < 1)
		return(-1);

	FILE *fd = fopen(filename, "w");

	if (fd == NULL)
	{
		fprintf(stderr, "Falha ao tentar salvar: '%s'\n", filename);
		return(-2);
	}

	fwrite(templ, len, 1, fd);
	fclose(fd);

	fprintf(stderr, "Salva template: '%s'\n", filename);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int main(int argc, char *argv[])
{
	char *pars[] = {
		"vendor", VENDOR,
		"path", "conf/SourceAFIS",
		NULL, NULL
	};

	verbose(stdout, "Le configuracao: %s.\n", CONFIG_INI);
	if (if_getopt_ini(CONFIG_INI, ifponto_config) < 1)
	{
		fprintf(stderr, "Falha ao tentar ler: %s\n", CONFIG_INI);
		return(1);
	}

	int finger = 0;
	uint8_t *img_bw8 = NULL;
	SCANNER scan;

	scan.dev.config = json_object_new_list(pars);
	scanner_getopt_fill_json_object(ifponto_config, scan.dev.config);

	scan.template_callback = scanner_matcher_save_template;
	scan.dpi = 400.0;

	gimp_get_bw8(&img_bw8);

	SCANNER_RESULT sr = 0;

	int8_t quality = 0;
	sr = scanner_enroll_image(&scan, img_bw8, gimp.width, gimp.height, 1, id, &quality, NULL);
	fprintf(stdout, "Enroll sr: %d\n", sr);

	sr = scanner_verify_image(&scan, img_bw8, gimp.width, gimp.height, id, &finger, NULL);
	fprintf(stdout, "Verify sr: %d\n", sr);

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //

#endif

