#ifndef SERVICES_H
#define SERVICES_H

#include <ifractal_utils.h>
#include <cgi.h>
#include <json.h>

typedef struct _IF_SERVICE_CONTEXT IF_SERVICE_CONTEXT;
typedef struct _IF_SERVICE IF_SERVICE;
typedef struct _IF_SERVICE_PARAMETER_DEFINITION IF_SERVICE_PARAMETER_DEFINITION;

typedef enum
{
	IF_SERVICE_TYPE_STRING,
	IF_SERVICE_TYPE_INTEGER,
	IF_SERVICE_TYPE_NUMBER,
	IF_SERVICE_TYPE_BOOLEAN,
	IF_SERVICE_TYPE_OPTION,
} IF_SERVICE_TYPE;

typedef struct
{
	char *id;
	char *value;
} IF_SERVICE_PARAMETER_OPTION;

struct _IF_SERVICE_PARAMETER_DEFINITION
{
	char *name;
	char *label;
	char *description;
	IF_SERVICE_TYPE type;
	char *default_value;
	IF_SERVICE_PARAMETER_OPTION *options;
	char *style;
};

typedef struct
{
	IF_SERVICE_TYPE type;
	char *name;
	char *value;
} IF_SERVICE_PARAMETER;

typedef JSON_VALUE * (*IF_SERVICE_FUNC)(
	_INOUT IF_SERVICE_CONTEXT *, 
	_IN IF_SERVICE *service,
	_IN IF_SERVICE_PARAMETER *params);

struct _IF_SERVICE
{
	char *name;
	char *label;
	char *description;
	struct _IF_SERVICE *services;	// vetor de servicos
	IF_SERVICE_FUNC func;
	IF_SERVICE_PARAMETER_DEFINITION **parameters;
	char *style;
};

struct _IF_SERVICE_CONTEXT
{
	char *name;
	IF_SERVICE *services;		// vetor de servicos
	void *user_data;
};


int service_show_definitions(_IN IF_SERVICE_CONTEXT *);
char * service_json_definition(_IN IF_SERVICE_CONTEXT *);

IF_SERVICE_PARAMETER * service_get_parameter_list(_IN IF_SERVICE *service);
char * service_get_parameter_value(_IN IF_SERVICE_PARAMETER *, _IN char *name);
void service_parameters_free(_IN IF_SERVICE_PARAMETER *);

JSON_VALUE * service_json_call(
	_IN char *json,
	_INOUT IF_SERVICE_CONTEXT *); 

JSON_VALUE * service_cgi_call(
	_INOUT IF_SERVICE_CONTEXT *); 

JSON_VALUE * service_name_value_call(
	_IN char *name_value_list[],
	_INOUT IF_SERVICE_CONTEXT *);

JSON_VALUE * service_cli_call(
	_IN int argc,
	_IN char *argv[],
	_INOUT IF_SERVICE_CONTEXT *);

#endif
