#ifndef SIINDB_H
#define SIINDB_H

#include <ifractal.h>


typedef struct
{
	// PRIMARY_KEY(cid, module, id)
	DICTIONARY *attrs;
	// cid
	// module
	// id
	// ip
	// filename

	IRESULTSET *rs;
	time_t unixtime;
	unsigned int valid;		// em minutos
	unsigned int persistence;	// em dias
} SIINDB_TABLE;

typedef struct
{
	VETOR *tables;
	DICTIONARY *attrs;
	// DB_PATH
} SIINDB_CONTEXT;

// Interface Servidor
SIINDB_TABLE * siindb_table_find(SIINDB_CONTEXT *, DICTIONARY *attrs);

SIINDB_CONTEXT * siindb_load(char *dirpath);
int siindb_update(SIINDB_CONTEXT *, SIINDB_TABLE *);
int siindb_update_incremental(SIINDB_CONTEXT *, SIINDB_TABLE *);

typedef int (*SIINDB_ITER_FUNC)(SIINDB_CONTEXT *, SIINDB_TABLE *, void *user_data);
int siindb_iter(SIINDB_CONTEXT *, SIINDB_ITER_FUNC, void *user_data);


// Integracao C
#ifdef WIN32
#else
SIINDB_TABLE * siindb_table_new(DICTIONARY *attrs, IRESULTSET *);
void siindb_table_free(SIINDB_TABLE *);

DICTIONARY * siindb_table_get_attrs(SIINDB_TABLE *);
IRESULTSET * siindb_table_get_result(SIINDB_TABLE *);

int siindb_send_table(ICONNECTION *, SIINDB_TABLE *);
int siindb_send_table_incremental(ICONNECTION *, SIINDB_TABLE *);

IRESULTSET * siindb_list_tables(ICONNECTION *, DICTIONARY *query_attrs);
IRESULTSET * siindb_get_table(ICONNECTION *, DICTIONARY *query_attrs);
#endif
#endif

