#include <server.h>
#include <main.h>

// Globais
THREAD_STATE alive = TH_ALIVE;
extern IF_VERBOSITY verbosity;
extern IF_GETOPT configs[];
extern MODWEB_PROC procs[];

// ///////////////////////////////////////////////////////////////////// //
_CALLBACK THREAD_STATE modweb_idle(MODSIIN_CONTEXT *ctx, void *user_data)
{
	int ppid = getppid();

	if (ppid <= 1)
	{
		verbose(stderr, "|%s| Processo pai finalizado.\n", MODULE);
		return(TH_ZOMBIE);
	}

	return(TH_ALIVE);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int modweb_start_procs()
{
	MODSIIN_CONTEXT *modweb_ctx;
	int pid, i;

	for (i = 0 ; procs[i].func != NULL ; i++)
	{
		if (procs[i].pid > 0)
			continue;

		pid = fork();
		if (pid == 0)
		{
			modweb_ctx = if_modweb_context_new(configs);
			modweb_ctx->alive = TH_ALIVE;

			procs[i].func(modweb_ctx, modweb_idle, procs[i].name);
			exit(0);
		}
		else
		{
			procs[i].pid = pid;
			verbose(stdout, "Inicia %s: %d\n", procs[i].name, procs[i].pid);
		}
	}

	return(i);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC void modweb_kill_procs()
{
	int i;

	for (i = 0 ; procs[i].func != NULL ; i++)
	{
		if (procs[i].pid < 2)
			continue;

		verbose(stdout, "Mata processo '%s'. PID: %d\n", procs[i].name, procs[i].pid);
		kill(procs[i].pid, SIGKILL);
	}

	modweb_finalize_subprocs();
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC int modweb_wait_proc(int *kill)
{
	int pid, status, i;

	pid = waitpid(0, &status, WNOHANG);
	if (pid < 0)
		return(pid);

	if (pid > 0)
	{
		verbose(stdout, "Encerra pid: %d\n", pid);

		for (i = 0 ; procs[i].func != NULL ; i++)
			if (procs[i].pid == pid)
				procs[i].pid = 0;
	}

	if ((alive != TH_ALIVE) && (*kill == 0))
	{
		modweb_kill_procs();
		*kill += 1;
	}

	if (check_restart(time(NULL)))
		alive = TH_ZOMBIE;

	return(pid);
}
// ///////////////////////////////////////////////////////////////////// //
_PUBLIC void modweb_wait_procs()
{
	int pid, kill = 0;

	while ((pid = modweb_wait_proc(&kill)) >= 0)
		if_sleep(1000);
}
// ///////////////////////////////////////////////////////////////////// //


#ifdef STANDALONE
// ///////////////////////////////////////////////////////////////////// //
void sighandler(int s)
{
	if (s == SIGPIPE)
		return;

	alive = TH_DEAD;
	fprintf(stdout, "Signal: %d\n", s);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int main(int argc, char **argv)
{
	signal(SIGINT, sighandler);
	signal(SIGTERM, sighandler);
	signal(SIGQUIT, sighandler);
	signal(SIGPIPE, sighandler);
	signal(SIGHUP, sighandler);
	
	verbose(stdout, "Inicia pid: %d\n", getpid());

	if (if_getopt_ini(CONFIG_INI, configs) < 1)
	{
		verbose(stderr, "Falha ao tentar ler: %s\n", CONFIG_INI);
		return(1);
	}

	modweb_start_procs();
	modweb_wait_procs();

	verbose(stdout, "Encerra processo principal. PID: %d\n", getpid());

	if (alive == TH_DEAD)
		return(0);

	return(RESTART_RETURN);
}
// ///////////////////////////////////////////////////////////////////// //
#endif

