#include <ifractal.h>


// ///////////////////////////////////////////////////////////////////// //
int vverbose(FILE *fd, char *source, char *format, va_list *va)
{
	int len = 0;

#ifdef WIN32
	static int log_limit = 0;
	char *buf;
	time_t now = time(NULL);
	struct tm *dt;
	char log[PATH_LEN];
	char dir[PATH_LEN];

	if (log_limit > 10*1024*1024)
		return(0);

	dt = localtime(&now);
	GetCurrentDirectory(PATH_LEN, dir);
	snprintf(log, PATH_LEN, "%s\\log\\monitor_%04d%02d%02d.log", dir, dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday);

	fd = fopen(log, "a");
	if (fd == NULL)
	{
		snprintf(log, PATH_LEN, "c:\\ifractal.log");

		fd = fopen(log, "a");
		if (fd == NULL)
			return(-1);
	}

	len = fprintf(fd, "%02d/%02d/%d %02d:%02d:%02d:",
		dt->tm_mday, dt->tm_mon + 1, dt->tm_year + 1900,
		dt->tm_hour, dt->tm_min, dt->tm_sec);
#endif

	len += fprintf(fd, " ");

	if (source != NULL)
		len += fprintf(fd, "|%s| ", source);

	len += vfprintf(fd, format, *va);

#ifdef WIN32
	buf = (char *) MALLOC(len + 1);
	vsprintf(buf, format, *va);
	fclose(fd);

	FREE(buf);

	log_limit += len;
#else
	fflush(fd);
#endif
	
	return(len);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int verbose(FILE *fd, char *format, ...)
{
	va_list va;
	int len;
	
	va_start(va, format);
	len = vverbose(fd, NULL, format, &va);
	va_end(va);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //
#ifdef WIN32
__declspec(dllexport) int __stdcall verbose_base(char *msg)
#else
int verbose_base(char *msg)
#endif
{
	return(verbose(stdout, "%s\n", msg));
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int verbose2(IF_VERBOSITY vref, IF_VERBOSITY vdef, FILE *fd, char *source, char *format, ...)
{
	va_list va;
	int len = 0;

	if (vdef > vref)
		return(0);

	va_start(va, format);
	len += vverbose(fd, source, format, &va);
	va_end(va);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int verbose_in(IFLOG *log, int def, char *format, ...)
{
	va_list va;
	int len = 0;

	if (log == NULL)
		return(0);

	if (def > log->verbosity)
		return(0);

	va_start(va, format);
	len += vverbose(stdout, log->source, format, &va);
	va_end(va);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //

