#include <ifractal.h>
#include <ifdevice.h>

#include <vetronic.h>




// ///////////////////////////////////////////////////////////////////// //
int vetronic_init_conn(IFDEVICE *dev)
{
	if (dev->sock < 0)
	{
		dev->sock = openTCP(dev->host, dev->port, 40);
		if (dev->sock < 1)
		{
			dev->sock = -1;
			return(-1);
		}
	}

	return(dev->sock);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
void vetronic_close_conn(IFDEVICE *reader)
{
	if_closesocket(reader->sock);
	reader->sock = -1;
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int vetronic_wait_response(int sock, char *buf, size_t len, int timeout)
{
	int n, to = 0;
	char *p;

	for (p = buf ; ((n = read_timeout(sock, p, 1, 1)) >= 0) && (to < timeout); p++)
	{
		if ((p - buf) >= (len - 1))
			break;

		if (n == 0)
		{
			to++;
			p--; //compensa loop
		}

		if (*p == '\r')
		{
			*(p - 1) = 0;
			break;
		}
	}
	*p = 0;
	
	if (n < 0)
		return(-1);

	return(p - buf);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int vetronic_sendrecv(IFDEVICE *dev, char *msg, char *resp, size_t len, int timeout)
{
	char header[VT_DISPLAY_LEN];
	int n, r;

	if (dev->nro > 99)
		n = snprintf(header, VT_DISPLAY_LEN, "%s;%d;", VT_NUM_SERVER, VT_NUM_READER);
	else
		n = snprintf(header, VT_DISPLAY_LEN, "%s;%d;", VT_NUM_SERVER, dev->nro);

	n = send_bytes(dev->sock, header, n, timeout);
	if (n < 0)
		return(n);

	verboseDEBUG(&(dev->log), "--> %s%s\n", header, msg);
	n = send_bytes(dev->sock, msg, strlen(msg), 1);

	r = vetronic_wait_response(dev->sock, resp, len, timeout);

	if (r > 0)
		verboseDEBUG(&(dev->log), "<-- %s\n", resp);

	return(r);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int vetronic_hello(IFDEVICE *dev)
{
	char buf[PATH_LEN];
	int n;

	verboseDEBUG(&(dev->log), "--> HELLO <--\n");

	n = snprintf(buf, PATH_LEN, "%s;\r", VT_CMD_HELLO);
	n = vetronic_sendrecv(dev, buf, buf, PATH_LEN, 10);
	if (n <= 0)
	{
		verboseDEBUG(&(dev->log), "HELLO timeout\n");
		return(-1);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int vetronic_bye(IFDEVICE *dev)
{
	char msg[VT_DISPLAY_LEN];
	int n;

	if (dev->nro > 99)
		n = snprintf(msg, VT_DISPLAY_LEN, "%s;%d;%s;\r", VT_NUM_SERVER, VT_NUM_READER, VT_CMD_BYE);
	else
		n = snprintf(msg, VT_DISPLAY_LEN, "%s;%d;%s;\r", VT_NUM_SERVER, dev->nro, VT_CMD_BYE);

	verboseDEBUG(&(dev->log), "BYE --> %s\n", msg);
	n = send_bytes(dev->sock, msg, n, 1);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int vetronic_set_time(_IN IFDEVICE *dev, int diff)
{
	int year, mon, day, hour, min, sec;
	time_t now = time(NULL);
	char msg[PATH_LEN];
	char buf[PATH_LEN];
	struct tm *dt;
	int n;

	now += diff * 3600;	
	dt = localtime(&now);
	day = dt->tm_mday;
	mon = dt->tm_mon + 1;
	year = dt->tm_year - 100,
	hour = dt->tm_hour;
	min = dt->tm_min;
	sec = dt->tm_sec;

 	// DD/MM/AAAA HH/MI/SS
	n = snprintf(msg, PATH_LEN, "%s;%02d/%02d/%d %02d:%02d:%02d;\r",
		VT_CMD_SET_DATE, day, mon, year, hour, min, sec);
	
	n = vetronic_sendrecv(dev, msg, buf, PATH_LEN, 10);
		
	return(n);
}
// ///////////////////////////////////////////////////////////////////// //
time_t vetronic_get_time(_IN IFDEVICE *dev)
{
	int dia, mes, ano, hor, min, seg;
	char msg[PATH_LEN];
	char buf[PATH_LEN];
	char *tk[10], *p;
	time_t ret = 0;
	int n;
	
	snprintf(msg, PATH_LEN, "%s;\r", VT_CMD_GET_DATE);
	n = vetronic_sendrecv(dev, msg, buf, PATH_LEN, 10);

	if ((n > 0) && (tokenizer(';', buf, tk, 5) > 3))
	{
		// 13/09/17 10:53:44
		p = tk[3];
		dia = atoi(p);
		p += 3;
		mes = atoi(p);
		p += 3;
		ano = atoi(p);
        
		p += 3;
		hor = atoi(p);
		p += 3;
		min = atoi(p);
		p += 3;
		seg = atoi(p);
        
		struct tm info;
		info.tm_year = 100 + ano;
		info.tm_mon = mes - 1;
		info.tm_mday = dia;
		info.tm_hour = hor;
		info.tm_min = min;
		info.tm_sec = seg;
		info.tm_isdst = -1;
        
		ret = mktime(&info);
	}
		
	return(ret);
}
// ///////////////////////////////////////////////////////////////////// //

// ///////////////////////////////////////////////////////////////////// //
int vetronic_get_qty_off(IFDEVICE *dev)
{
	char msg[PATH_LEN];
	char buf[PATH_LEN];
	char *tk[10];
	int qty, n;

	// Envia comando para ler a qtd de registros off
	snprintf(msg, PATH_LEN, "%s;\r", VT_CMD_QTY_OFF_UNREAD);
	n = vetronic_sendrecv(dev, msg, buf, PATH_LEN, 15);
	if ((n > 0) && (tokenizer(';', buf, tk, 10) > 4))
		qty = atoi(tk[4]);
	else
		qty = -1;
	
	return(qty);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * vetronic_get_unread_off(IFDEVICE *dev)
{
	char *list[] = {"nro_cartao",NULL, "canal",NULL, "datahora",NULL, "sentido", NULL, NULL,NULL};
	JSON_VALUE *evt, *events = NULL;
	char buf[PATH_LEN];
	char datahora[PATH_LEN] = "DD/MM/AAAA HH:MI:SS";
	char *tk[40];
	int n;

	events = json_array_new(2);
	do
	{
		// Envia comando para ler registros off
		snprintf(buf, PATH_LEN, "%s;\r", VT_CMD_GET_OFF_UNREAD);
		n = vetronic_sendrecv(dev, buf, buf, PATH_LEN, 15);
		if (n <= 0)
			break;

		// Verifica se existem caracteres invalidos
		for (n = 0 ; buf[n] != 0 ; n++)
			if (buf[n] < 0)
				continue;
        
		if ((n = tokenizer(';', buf, tk, 40)) < 4)
			break;

		// Verifica se eh o ultimo registro
		if (atoi(tk[4]) == 2)
			break;

		if (n < 11)
		{
			verboseWARN(&(dev->log), "Falha na coleta...\n");
			break;
		}

		// Elimina ZEROs a esquerda
		while (tk[5][0] == '0')
			tk[5] += 1;

		list[1] = tk[5];
		list[3] = tk[9];

		snprintf(datahora, PATH_LEN, "20%c%c-%c%c-%c%c %s:00", 
			tk[6][6], tk[6][7],	// ano
			tk[6][3], tk[6][4],	// mes
			tk[6][0], tk[6][1],	// dia
			tk[7]);
		list[5] = datahora;
		list[7] = tk[10];
		evt = json_object_new_list(list);

		json_array_add(events, evt);
	} while(1);
	
	vetronic_bye(dev);

	return(events);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
void adjust_message(char *msg, VT_RESPONSE *response)
{
	char *p;

	strncpy(response->msg1, msg, VT_DISPLAY_LEN);

	if (strlen(msg) > (VT_DISPLAY_LEN - 1))
		strncpy(response->msg2, msg + VT_DISPLAY_LEN - 1, VT_DISPLAY_LEN);

	// Limpa mensagens
	for (p = response->msg1 ; *p != 0 ; p++)
		if ((*p < ' ') || (*p > 'z'))
			*p = ' ';

	for (p = response->msg2 ; *p != 0 ; p++)
		if ((*p < ' ') || (*p > 'z'))
			*p = ' ';

	if (strlen(response->msg1) > 16)
		response->msg1[16] = 0;

	if (strlen(response->msg2) > 16)
		response->msg2[16] = 0;
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int password_response(char *aux, char **request)
{
	int len;

	len = snprintf(aux, BUFFER_LEN, 
		"%s;%s;%s; DIGITE A SENHA ;4;\r",
		VT_NUM_SERVER,
		request[VT_EVT_SOLIC_REM],
		VT_EVT_SOLIC_PASS);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //
int no_password_response(char *aux, char **request, JSON_VALUE *json_response, VT_RESPONSE *response)
{
	int len;

	len = snprintf(aux, PATH_LEN, 
		"%s;%s;0;%d;%s;%c;%c;%16s%16s;3;\r",
		VT_NUM_SERVER,
		request[VT_EVT_SOLIC_REM],
		VT_EVT_RESPOSTA_SOLIC,
		request[VT_EVT_SOLIC_ID],
		response->sentido,
		response->auth,
		response->msg1,
		response->msg2);

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //
void decode_response(IFDEVICE *dev, VT_RESPONSE *response, JSON_VALUE *json_response)
{
	char *msg = json_get_string(json_response);
	char *tk[IFDEVICE_RESPONSE_LEN];
	int l = tokenizer('|', msg, tk, IFDEVICE_RESPONSE_LEN);

	//response->sentido = 'I'; 	// irrelevante
	response->auth = 'B';
	response->password[0] = 0;

	if (l < 7)
		adjust_message("ACESSO          NEGADO          ", response);

	response->sentido = tk[IFDEVICE_RESPONSE_TURN][0];
	response->sentido = dev->last.turn;
	dev->last.user_id = atoi(tk[IFDEVICE_RESPONSE_COD_PESSOA]);
	dev->last.card_id = atoi(tk[IFDEVICE_RESPONSE_COD_CARTAO]);
	dev->last.access_id = atoi(tk[IFDEVICE_RESPONSE_ACCESS_CODE]);

	response->auth = tk[IFDEVICE_RESPONSE_AUTH][0];
	snprintf(response->msg1, VT_DISPLAY_LEN, "%s", tk[IFDEVICE_RESPONSE_MSG1]);
	snprintf(response->msg2, VT_DISPLAY_LEN, "%s", tk[IFDEVICE_RESPONSE_MSG2]);
}
// ///////////////////////////////////////////////////////////////////// //
int action_handler(_INOUT char *aux, _IN char **request, _IN VT_RESPONSE *response)
{
	int len;
	int acao = VT_EVT_ACAO_BLOQUEIA;
	char *msg1, *msg2;

	len = 0;
	msg1 = " Senha Invalida ";
	msg2 = "";
	switch (atoi(request[VT_EVT_SOLIC_ID]))
	{
		case VT_EVT_ACAO_PASS:
			if (strncmp(response->password, request[5], VT_ID_LEN) == 0)
			{
				acao = VT_EVT_ACAO_LIBERA;
				msg1 = response->msg1;
				msg2 = response->msg2;
			}

			len = snprintf(aux, BUFFER_LEN, 
				"%s;%s;0;%d;%d;%16s;%16s;%c;3000;\r",
				VT_NUM_SERVER,
				request[VT_EVT_SOLIC_REM],
				VT_EVT_ACAO,
				acao, msg1, msg2, response->sentido);

			break;
	}

	return(len);
}
// ///////////////////////////////////////////////////////////////////// //
int VT_process_online(IFDEVICE *dev, char *buf, IFDEVICE4J_online_callback getUser, void *context)
{
	char *tk[VT_EVT_SOLIC_LEN + 1];
	JSON_VALUE *json_response;
	VT_RESPONSE response;
	char aux[PATH_LEN];
	int len = 0, i;
	
	// Inicializa tokens
	for (i = 0 ; i < VT_EVT_SOLIC_LEN ; i++)
		tk[i] = "-1";

	verboseDEBUG(&(dev->log), "online request: %s\n", buf);
	tokenizer(';', buf, tk, VT_EVT_SOLIC_LEN + 1);

	if (atoi(tk[VT_EVT_SOLIC_CLASS]) != 0)
		return(1);

	switch(atoi(tk[VT_EVT_SOLIC_EVE]))
	{
		case VT_EVT_ACAO:
			verboseDEBUG(&(dev->log), "action_handler\n");
			len = action_handler(aux, tk, &response);
			break;

		case VT_EVT_OFF_PENDENTE:
			verboseINFO(&(dev->log), "Registros pendentes: %s\n", tk[VT_EVT_SOLIC_ID]);
			return(1);

		case VT_EVT_SOLIC_ACESSO:
			purgeZeros(tk[VT_EVT_SOLIC_ID]);
			strncpy(dev->last.card, tk[VT_EVT_SOLIC_ID], IFDEVICE_CARD_MAX);
			snprintf(aux, sizeof(aux), "%s;%s;%s", tk[VT_EVT_SOLIC_ID], tk[VT_EVT_SOLIC_SEN], tk[VT_EVT_SOLIC_CAN]);
			dev->last.turn = tk[VT_EVT_SOLIC_SEN][0];
			verboseDEBUG(&(dev->log), "Solicita acesso: %s\n", tk[VT_EVT_SOLIC_ID]);
			json_response = getUser(1, (char **) aux, context, "getUserOnline");
			decode_response(dev, &response, json_response);

			//if (check_pass(dev->config))
			//	len = password_response(aux, tk);
			//else
				len = no_password_response(aux, tk, json_response, &response);

			json_value_free(json_response);
			break;

		case VT_EVT_GIRO_COMPLETO:
			snprintf(aux, sizeof(aux), "%c;%d;%d;%d", tk[4][0], dev->last.card_id, dev->last.user_id, dev->last.access_id);
			json_response = getUser(1, (char **) aux, context, "turnConfirmation");
			verboseDEBUG(&(dev->log), "Giro %c '%s'\n", tk[4][0], json_get_string(json_response));
			json_value_free(json_response);
			break;

		case VT_EVT_SOLIC_TIMEOUT:
			verboseDEBUG(&(dev->log), "Giro Timeout\n");
			break;

		default:
			verboseWARN(&(dev->log), "Solicitacao desconhecida.\n");
			break;
	}

	if (len > 0)
	{
		verboseDEBUG(&(dev->log), "Response: (%d) '%s'\n", len, aux);
		send_bytes(dev->sock, aux, len, 1);
	}

	return(0);
}
// ///////////////////////////////////////////////////////////////////// //
int VT_online(IFDEVICE4J *dev, IFDEVICE4J_online_callback getUser, void *context)
{
	char buf[PATH_LEN], *p;
	time_t now = time(NULL);
	time_t last = now;
	time_t diff;
	int len, r;

	// Le linha terminada em '\r'
	for(p = buf ; (len = read_timeout(dev->sock, p, 1, 1)) >= 0 ; )
	{
		now = time(NULL);
		if (len == 0)
		{
			diff = now - last;
			if (diff > 60)
				return(2);

			verboseDEBUG(&(dev->log), "%ld\n", 60 - diff);
			continue;
		}

		if (*p++ != '\r')
			continue;

		last = now;

		p--;
		*p = 0;
		r = VT_process_online(dev, buf, getUser, context);
		if (r)
			break;

		p = buf;
	}

	return(-1);
}
// ///////////////////////////////////////////////////////////////////// //


// ///////////////////////////////////////////////////////////////////// //
int vetronic_addResult(JSON_VALUE *res, JSON_VALUE *reg, char *resp)
{
	char *format = "%s - %s | %s";
	char msg[PATH_LEN];
	JSON_VALUE *evt = json_object_new(1);
	char *cod = json_object_get_string(reg, "cod");
	char *codigo = json_object_get_string(reg, "codigo");
	char *nome = json_object_get_string(reg, "nome");
	time_t now = time(NULL);
	struct tm *dt;
	int n = 0;

	dt = localtime(&now);
	snprintf(msg, sizeof(msg), "%04d-%02d-%02d %02d:%02d:%02d", 
		dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday, dt->tm_hour, dt->tm_min, dt->tm_sec);

	json_object_add(evt, "datahora", json_string_new(msg));

	n = snprintf(msg, sizeof(msg), format, codigo, nome, resp);

	json_object_add(evt, "status", json_string_new(msg));
	json_object_add(evt, "cod", json_string_new(cod));
	json_object_add(evt, "codigo", json_string_new(codigo));
	json_array_add(res, evt);

	return(n);
}
// ///////////////////////////////////////////////////////////////////// //


// Implementacao da Interface ////////////////////////////////////////// //
// ///////////////////////////////////////////////////////////////////// //
time_t VT_getTime(IFDEVICE4J *dev, long sock)
{
	time_t dth = 0;

	if (sock > 0)
		dev->sock = sock;
        
	if (vetronic_hello(dev))
		return(0);

	dth = vetronic_get_time(dev);

	return(dth);
}
// ///////////////////////////////////////////////////////////////////// //
void VT_setTime(IFDEVICE4J *dev, int diff)
{
	vetronic_set_time(dev, diff);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_getEvents(IFDEVICE4J *dev, int nsr)
{
	JSON_VALUE *joffs = vetronic_get_unread_off(dev);
	return(joffs);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_sendUsers(IFDEVICE4J *dev, JSON_VALUE *users)
{
	//1000;0;0;0;0;0;0;0;0;0;0;0;0;1/1/5;0;1/1/5;0;0;0;1/1;0;1/1;1;
	char buf[PATH_LEN];
	JSON_VALUE *u, *res;
	int i, n, len;
	char *cracha;

	// TODO
	return(NULL);

	res = json_array_new(1);
	len = json_array_length(users);
	for (i = 0 ; i < len ; i++)
	{
		u = json_array_index(users, i);
		cracha = json_object_get_string(u, "cracha");

		// TODO
		n = snprintf(buf, PATH_LEN, "%s;%d;%s;;0;0;0;0;0;0;0;0;0;0;0;0;1/1/5;0;1/1/5;0;0;0;1/1;0;1/1;1;\r", 
			VT_CMD_SEND_ID_TAB, i, cracha);

		n = vetronic_sendrecv(dev, buf, buf, PATH_LEN, 5);
		if (n <= 0)
			break;

		vetronic_addResult(res, u, buf);
	}

	return(res);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_getInfo(IFDEVICE4J *dev, long sock)
{
	JSON_VALUE *info = json_object_new(1);
	int qty = 0;

	if (sock > 0)
		dev->sock = sock;

	if (vetronic_hello(dev))
		return(info);
        
	qty = vetronic_get_qty_off(dev);
	json_object_add(info, "qty_off", json_integer_new(qty));
	
	if (qty == 0)
		vetronic_bye(dev);

	return(info);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_getUsers(IFDEVICE4J *dev)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_sendBio(IFDEVICE4J *dev, JSON_VALUE *users)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
JSON_VALUE * VT_getBio(IFDEVICE4J *dev, JSON_VALUE *users)
{
	return(NULL);
}
// ///////////////////////////////////////////////////////////////////// //
void VT_free(IFDEVICE4J *dev)
{
}
// ///////////////////////////////////////////////////////////////////// //
void VT_init(IFDEVICE4J *dev)
{
	dev->getInfo = VT_getInfo;
	dev->getTime = VT_getTime;
	dev->setTime = VT_setTime;
	dev->sendUsers = VT_sendUsers;
	dev->getUsers = VT_getUsers;
	dev->sendBio = VT_sendBio;
	dev->getBio = VT_getBio;
	dev->getEvents = VT_getEvents;
	dev->free = VT_free;
	dev->online = VT_online;
}
// ///////////////////////////////////////////////////////////////////// //


