#include <ifractal.h>

#include <tchar.h>
#include <shellapi.h>

#include <if_sched.h>
#include <server.h>

int modweb_start_proc(char *procname, MODSIIN_CONTEXT *);
BOOL modweb_start_procs();
void modweb_finalize_procs(int);


// Globais
MODSIIN_CONTEXT *modweb_ctx;
extern MODWEB_PROC procs[];
extern IF_VERBOSITY verbosity;
extern IF_GETOPT configs[];
extern char *home_path;

char *proc_name = PROC_NAME;



// //////////////////////////////////////////////////////////////////
_PRIVATE BOOL modweb_init_proc(int i)
{
	char cmd_path[PATH_LEN];
	STARTUPINFO si;
	BOOL ret;

	snprintf(cmd_path, PATH_LEN, "%s %s %s", proc_name, home_path, procs[i].name);
	verbose(stdout, "%s\n", cmd_path);

	GetStartupInfo(&si);			//set startupinfo for the spawned process
	ZeroMemory( &si, sizeof(si) );

	si.cb = sizeof(si);
	si.dwFlags = STARTF_USESTDHANDLES|STARTF_USESHOWWINDOW;
	ZeroMemory( &(procs[i].pi), sizeof(PROCESS_INFORMATION) );
        
	// Start the child process. 
	if( !(ret = CreateProcess(NULL, cmd_path, NULL, NULL, FALSE, CREATE_NO_WINDOW, NULL, home_path, &si, &(procs[i].pi))) ) 
	{
		fprintf(stdout, "%s\n", cmd_path);
		fprintf(stderr, "CreateProcess failed (%d).\n", (int) GetLastError());
	}

	return(ret);
}
// //////////////////////////////////////////////////////////////////
_PUBLIC BOOL modweb_start_procs()
{
	BOOL ret = 0;
	int i;

	for (i = 0 ; procs[i].func != NULL ; i++)
	{
		if (procs[i].pi.hProcess == NULL)
			ret = modweb_init_proc(i);
	}

	return(ret);
}
// //////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////
void modweb_finalize_procs(int exitcode)
{
	int i;

	for (i = 0 ; procs[i].func != NULL ; i++)
	{
		if (procs[i].pi.hProcess == NULL)
			continue;

		verbose(stdout, "Encerra '%s'.\n", procs[i].name);
		TerminateProcess(procs[i].pi.hProcess, exitcode);
	}

	modweb_finalize_subprocs();
}
// //////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////// //
_PRIVATE int modweb_wait_wproc()
{
	DWORD exitCode = 0;
	int i, r; 

	if (check_restart(time(NULL)))
		modweb_finalize_procs(RESTART_RETURN);

	for (i = 0 ; procs[i].func != NULL ; i++)
	{
		if (procs[i].pi.hProcess == NULL)
		{
			if_sleep(50);
			continue;
		}

		if (WaitForSingleObject( procs[i].pi.hProcess, 50 ) == WAIT_TIMEOUT)
			continue;

		r = GetExitCodeProcess(procs[i].pi.hProcess, &exitCode);
		if (r == 0)
		{
			DWORD dw = GetLastError();
			verbose(stdout, "Falha (%s) - GetExitCodeProcess (%d)\n", procs[i].name, dw);
			exitCode = EXIT_RETURN;
		}
		else
		{
			verbose(stdout, "(%s) - GetExitCodeProcess = %d (%d)\n", procs[i].name, exitCode, r);
		}

		if (exitCode == STILL_ACTIVE)
			continue;

		verbose(stdout, "%s %s encerrado (%d)\n", proc_name, procs[i].name, exitCode);

		if (exitCode == EXIT_RETURN)
		{
			CloseHandle( procs[i].pi.hProcess );
			procs[i].pi.hProcess = NULL;
                        
			CloseHandle( procs[i].pi.hThread );

			modweb_finalize_procs(EXIT_RETURN);
			verbose(stdout, "Encerra SIIN.\n");
		}
		else if (exitCode == RESTART_RETURN)
		{
			if_sleep(10*1000);
			modweb_init_proc(i);
			verbose(stdout, "Restart SIIN.\n");
		}
		else if (exitCode == 255)
		{
			if_sleep(30*1000);
			modweb_init_proc(i);
			verbose(stdout, "Restart SIIN. (255)\n");
		}
		else if (exitCode == 0)
		{
			verbose(stdout, "%s %s Finalizado normalmente.\n", proc_name, procs[i].name);
			procs[i].pi.hProcess = NULL;
		}
		else
		{
			verbose(stdout, "%s %s recuperacao de falha. Verificar.\n", proc_name, procs[i].name);
			if_sleep(60*1000);
			modweb_finalize_procs(RESTART_RETURN);
			modweb_init_proc(i);
		}
	}

	return(1);
}
// ///////////////////////////////////////////////////////////////////// //




#ifdef SERVICE

char *service_name = "iFractal";
char *config_ini = CONFIG_INI;

 
#define WIN_OBS		"\n\nComandos para administracao de servicos no windows.\n" \
			"\tsc [start|stop]\n" \
			"\tsc create \"%s\" binpath= \"%s\\bin\\%s %s\"\n\n" 

SERVICE_STATUS ServiceStatus; 
SERVICE_STATUS_HANDLE hStatus; 
 
void ServiceMain(int argc, char** argv); 
void ControlHandler(DWORD request); 
int InitService();



// ///////////////////////////////////////////////////////////////////// //
_CALLBACK THREAD_STATE modweb_idle(MODSIIN_CONTEXT *ctx, void *user_data)
{
	return(TH_ALIVE);
}
// ///////////////////////////////////////////////////////////////////// //

// //////////////////////////////////////////////////////////////////
_PRIVATE int modweb_start_proc(char *procname, MODSIIN_CONTEXT *ctx)
{
	int i;

	for (i = 0 ; procs[i].func != NULL ; i++)
		if (strcmp(procname, procs[i].name) == 0)
			break;

	if (procs[i].func == NULL)
		return(-1);

	return(procs[i].func(ctx, modweb_idle, procs[i].name));
}
// //////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////
_PRIVATE void modweb_help(char **argv)
{
	int i;

	fprintf(stderr, "\niFractal Desenvolvimento de Software - SIIN (Servico de Integracao Inteligente nas Nuvens)\n");
	fprintf(stderr, "http://www.ifractal.com.br/\n\n");
	fprintf(stderr, "Uso:\nshell$ %s %s [%s", argv[0], home_path, procs[0].name);

	for (i = 1 ; procs[i].func != NULL ; i++)
		fprintf(stderr, "|%s", procs[i].name);

	fprintf(stderr, "]\n");
	fprintf(stderr, WIN_OBS, service_name, home_path, proc_name, home_path);
}
// //////////////////////////////////////////////////////////////////
int main(int argc, char **argv) 
{
	char path[PATH_LEN];

	if (argc < 2)
	{
		modweb_help(argv);
		return(1);
	}

	proc_name = argv[0];
	home_path = argv[1];

	snprintf(path, PATH_LEN, "%s", home_path);
	if (!SetCurrentDirectory(path))
	{
		verbose(stderr, "PATH '%s' invalido.\n", home_path);
		return(2);
	}

	snprintf(path, PATH_LEN, "%s\\%s", home_path, config_ini);
	config_ini = STRDUP(path);

	verbose(stdout, "CONFIG_INI='%s'\n", config_ini);
	verbose(stdout, "HOME_PATH='%s'\n", home_path);

	modweb_ctx = if_modweb_context_new(configs);
	modweb_ctx->alive = TH_ALIVE;

	if (argc > 2)
	{
		modweb_start_proc(argv[2], modweb_ctx);
		return(0);
	}

	SERVICE_TABLE_ENTRY ServiceTable[2];
	ServiceTable[0].lpServiceName = service_name;
	ServiceTable[0].lpServiceProc = (LPSERVICE_MAIN_FUNCTION) ServiceMain;

	ServiceTable[1].lpServiceName = NULL;
	ServiceTable[1].lpServiceProc = NULL;

	// Start the control dispatcher thread for our service
	StartServiceCtrlDispatcher(ServiceTable);
	
	return(0);
}
// //////////////////////////////////////////////////////////////////

// //////////////////////////////////////////////////////////////////
void ServiceMain(int argc, char** argv) 
{
	int error; 

	// Initialize Service 
	error = InitService(); 
	if (error) 
	{
		// Initialization failed
		ServiceStatus.dwCurrentState       = SERVICE_STOPPED; 
		ServiceStatus.dwWin32ExitCode      = -1; 
		SetServiceStatus(hStatus, &ServiceStatus); 
		return; 
	}
 
	// We report the running status to SCM. 
	ServiceStatus.dwCurrentState = SERVICE_RUNNING; 
	SetServiceStatus (hStatus, &ServiceStatus);

	if_sleep(10*1000);
	while (ServiceStatus.dwCurrentState == SERVICE_RUNNING)
	{
		if (!modweb_wait_wproc())
			break;
	}

	verbose(stdout, "Servico %s encerrado.\n", service_name);
		
	return; 
}
// //////////////////////////////////////////////////////////////////

 
// Service initialization ///////////////////////////////////////////
int InitService() 
{ 
	modweb_start_procs();

	ServiceStatus.dwServiceType        = SERVICE_WIN32; 
	ServiceStatus.dwCurrentState       = SERVICE_START_PENDING; 
	ServiceStatus.dwControlsAccepted   = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
	ServiceStatus.dwWin32ExitCode      = 0; 
	ServiceStatus.dwServiceSpecificExitCode = 0; 
	ServiceStatus.dwCheckPoint         = 0; 
	ServiceStatus.dwWaitHint           = 0; 
 
	hStatus = RegisterServiceCtrlHandler(service_name, (LPHANDLER_FUNCTION) ControlHandler); 
	if (hStatus == (SERVICE_STATUS_HANDLE) 0) 
	{ 
		// Registering Control Handler failed
		return(-1); 
	}  

	return(0); 
} 
// //////////////////////////////////////////////////////////////////

// Control handler function /////////////////////////////////////////
void ControlHandler(DWORD request) 
{ 
	switch(request) 
	{ 
		case SERVICE_CONTROL_STOP: 
			modweb_finalize_procs(EXIT_RETURN);

			ServiceStatus.dwWin32ExitCode = 0; 
			ServiceStatus.dwCurrentState  = SERVICE_STOPPED; 
			SetServiceStatus (hStatus, &ServiceStatus);
			return; 
 
		case SERVICE_CONTROL_SHUTDOWN: 
			ServiceStatus.dwWin32ExitCode = 0; 
			ServiceStatus.dwCurrentState  = SERVICE_STOPPED; 
			SetServiceStatus (hStatus, &ServiceStatus);
			return; 
	    
		default:
			break;
	} 
 
	// Report current status
	SetServiceStatus (hStatus,  &ServiceStatus);
 
	return; 
} 
// //////////////////////////////////////////////////////////////////

#endif



#ifdef STANDALONE

#define IDBUTTON 			102
#define ID_TRAY_APP_ICON                5000
#define WM_TRAYICON			( WM_USER + 1 )


#define ID_VIEW_LOG_MENU_ITEM		3000
#define ID_DELETE_LOG_MENU_ITEM		3001
#define ID_EXIT_MENU_ITEM		3002


UINT WM_TASKBARCREATED = 0;


LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

char szClassName[] = "iFractal SIIN";
THREAD_STATE alive = TH_ALIVE;
HINSTANCE g_hInst;
HWND hwnd;
HMENU g_menu;
NOTIFYICONDATA g_notifyIconData;
HICON ifractal_icon;



// ////////////////////////////////////////////////////////
void Minimize()
{
	Shell_NotifyIcon(NIM_ADD, &g_notifyIconData);
	ShowWindow(hwnd, SW_HIDE);
}
// ////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////
void Restore()
{
	Shell_NotifyIcon(NIM_DELETE, &g_notifyIconData);
	ShowWindow(hwnd, SW_SHOW);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
void InitNotifyIconData()
{
	memset( &g_notifyIconData, 0, sizeof( NOTIFYICONDATA ) ) ;

	g_notifyIconData.cbSize = sizeof(NOTIFYICONDATA);
	g_notifyIconData.hWnd = hwnd;
	g_notifyIconData.uID = ID_TRAY_APP_ICON;
	g_notifyIconData.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;

	g_notifyIconData.uCallbackMessage = WM_TRAYICON;
	g_notifyIconData.hIcon = ifractal_icon;

	strcpy(g_notifyIconData.szTip, "iFractal - Modulo SIIN");
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
void on_icon_click(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(wParam)
	{
		case ID_TRAY_APP_ICON:
		break;
	}

	if (lParam == WM_LBUTTONUP)
		Restore();

	else if (lParam == WM_RBUTTONDOWN)
	{
		// Get current mouse position.
		POINT curPoint ;
		GetCursorPos( &curPoint ) ;

		SetForegroundWindow(hwnd); 

		UINT clicked = TrackPopupMenu(
			g_menu,
			TPM_RETURNCMD | TPM_NONOTIFY,
			curPoint.x,
			curPoint.y,
			0,
			hwnd,
			NULL);

		//SendMessage(hwnd, WM_NULL, 0, 0);
		if (clicked == ID_EXIT_MENU_ITEM)
		{
			alive = TH_ZOMBIE;
			PostQuitMessage(0);
		}
	}
}
// ////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////
void onCreate(HWND hwnd)
{
	/*HMENU hMenu, hSubMenu;

	hMenu = CreateMenu();

	hSubMenu = CreatePopupMenu();
	AppendMenu(hSubMenu, MF_STRING, ID_FILE_EXIT, "E&xit");
	AppendMenu(hMenu, MF_STRING | MF_POPUP, (UINT)hSubMenu, "&File");

	hSubMenu = CreatePopupMenu();
	AppendMenu(hSubMenu, MF_STRING, ID_STUFF_GO, "&Go");
	AppendMenu(hMenu, MF_STRING | MF_POPUP, (UINT)hSubMenu, "&Stuff");

	SetMenu(hwnd, hMenu);*/

	g_menu = CreatePopupMenu();
	AppendMenu(g_menu, MF_STRING, ID_EXIT_MENU_ITEM, TEXT("Exit"));
}
// ////////////////////////////////////////////////////////

// ////////////////////////////////////////////////////////
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//PAINTSTRUCT ps;
	//HDC hdc;
	
	if ( message==WM_TASKBARCREATED && !IsWindowVisible( hwnd ) )
	{
		Minimize();
		return 0;
	}

	switch (message) {
		case WM_PAINT:
			//hdc = BeginPaint(hwnd, &ps);
			//TextOut(hdc, 5, 5, msg, strlen(msg));
			//EndPaint(hwnd, &ps);
			break;

		case WM_COMMAND:
			break;

		case WM_TRAYICON:
			on_icon_click(hwnd, message, wParam, lParam);
			break;

		case WM_CLOSE:
			Minimize();
			return 0;
			break;

		case WM_DESTROY:
			PostQuitMessage (0);
			break;

		case WM_CREATE:
			onCreate(hwnd);
			break;
	}

	return DefWindowProc (hwnd, message, wParam, lParam);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
void winit(HINSTANCE hThisInstance, WNDCLASSEX *wincl)
{
	ifractal_icon = LoadImage(NULL, TEXT("bin\\ifractal.ico"), IMAGE_ICON, 0, 0, LR_LOADFROMFILE) ;

	/* The Window structure */
	g_hInst = hThisInstance;
	wincl->hInstance = hThisInstance;
	wincl->lpszClassName = szClassName;
	wincl->lpfnWndProc = WindowProcedure;      /* This function is called by windows */
	wincl->style = CS_DBLCLKS;                 /* Catch double-clicks */
	wincl->cbSize = sizeof (WNDCLASSEX);

	/* Use default icon and mouse-pointer */
	wincl->hIcon = ifractal_icon;
	wincl->hIconSm = ifractal_icon;
	wincl->hCursor = LoadCursor (NULL, IDC_ARROW);
	wincl->lpszMenuName = NULL;            /* No menu */
	wincl->cbClsExtra = 0;                 /* No extra bytes after the window class */
	wincl->cbWndExtra = 0;                 /* structure or the window instance */
	/* Use Windows''s default color as the background of the window */
	wincl->hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);
}
// ////////////////////////////////////////////////////////


// ////////////////////////////////////////////////////////
void setDefaultPath(LPSTR args)
{
	int max = 10;
	char *tk[max];
	char *path;

	tokenizer(' ', args, tk, max);
	if (tk[0][0] == 0)
		path = "..";
	else
		path = tk[0];

	home_path = path;
	SetCurrentDirectory(path);
}
// ////////////////////////////////////////////////////////
_CALLBACK int modweb_check_iter(char *name, int pid, int ppid, int qty_threads, void *user_data)
{
	int *test = (int *) user_data;

	if (strcmp(name, proc_name) == 0)
		*test = 1;

	return(0);
}
// ////////////////////////////////////////////////////////
int modweb_check()
{
	int test = 0;

	fs_proc_iter(modweb_check_iter, &test);

	return(test);
}
// ////////////////////////////////////////////////////////
int WINAPI WinMain (HINSTANCE hThisInstance,
	                HINSTANCE hPrevInstance,
	                LPSTR lpszArgument,
	                int nFunsterStil) 
{
	WNDCLASSEX wincl;
	MSG messages;

	setDefaultPath(lpszArgument);

	if (modweb_check())
	{
		MessageBox(NULL, "Existe outro 'Modulo iFractal' aberto.", NULL, MB_ICONINFORMATION|MB_OK);
		return(1);
	}

	modweb_start_procs();

	winit(hThisInstance, &wincl);
	WM_TASKBARCREATED = RegisterWindowMessageA("TaskbarCreated") ;

	if (!RegisterClassEx (&wincl))
	{
		fprintf(stderr, "register error...\n");
		return(1);
	}

	hwnd = CreateWindowEx (
	       0,                   	// Extended possibilites for variation
	       szClassName,         	// Classname
	       "iFractal - Modulo SIIN",// Title Text
	       WS_OVERLAPPEDWINDOW, 	// default window
	       CW_USEDEFAULT,       	// Windows decides the position
	       CW_USEDEFAULT,       	// where the window ends up on the screen
	       300,                 	// The programs width
	       75,                  	// and height in pixels
	       HWND_DESKTOP,        	// The window is a child-window to desktop
	       NULL,                	// menu
	       hThisInstance,       	// Program Instance handler
	       NULL                 	// No Window Creation data
	       );

	InitNotifyIconData();

	ShowWindow (hwnd, SW_SHOW);
	UpdateWindow(hwnd);

	while (alive == TH_ALIVE)
	{
		if (!modweb_wait_wproc())
			alive = TH_ZOMBIE;

		if (!PeekMessage(&messages, hwnd,  0, 0, PM_REMOVE))
			continue;

		TranslateMessage(&messages);
		DispatchMessage(&messages);
	}

	modweb_finalize_procs(EXIT_RETURN);

	if( !IsWindowVisible( hwnd ) )
		Shell_NotifyIcon(NIM_DELETE, &g_notifyIconData);

	return(messages.wParam);
}
// ////////////////////////////////////////////////////////

#endif



