/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;
import com.nitgen.SDK.BSP.NBioBSPJNI;

public class ScannerNitgen<T>
extends Scanner<T> {
    public static final String name = "Nitgen Fingkey Hamster";
    public static final String library = "fingkey";
    private NBioBSPJNI bsp;
    private NBioBSPJNI.Export exportEngine;
    private NBioBSPJNI.Export.TEMPLATE_DATA SaveWSQData;
    private NBioBSPJNI.FIR_HANDLE hWSQFIR1;
    private NBioBSPJNI.FIR_HANDLE hWSQFIR2;
    private NBioBSPJNI.FIR_HANDLE hSavedFIR;
    private NBioBSPJNI.FIR_PAYLOAD payLoad;
    private static double xS = -0.75;
    private static double yS = 0.1;
    private static double dx = 0.0;
    private static double dy = 0.0;
    private NBioBSPJNI.DEVICE_ENUM_INFO deviceEnumInfo;

    public ScannerNitgen(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public ScannerNitgen(long[] ctx, String[] args, ScannerListener<T> sl) {
        super(ctx, args, sl);
    }

    public Boolean checkError() {
        if (this.bsp.IsErrorOccured()) {
            System.out.println("Erro ao iniciar scanner: " + this.bsp.GetErrorCode());
            return true;
        }
        return false;
    }

    private boolean SetDeviceList() {
        this.deviceEnumInfo = new NBioBSPJNI.DEVICE_ENUM_INFO(this.bsp);
        this.bsp.EnumerateDevice(this.deviceEnumInfo);
        if (this.checkError().booleanValue()) {
            return false;
        }
        int n = this.deviceEnumInfo.DeviceCount;
        if (n == 0) {
            return false;
        }
        Object szValue = "Auto_Detect";
        for (int i = 0; i < n; ++i) {
            szValue = this.deviceEnumInfo.DeviceInfo[i].Name + "(ID: " + this.deviceEnumInfo.DeviceInfo[i].Instance + ")";
        }
        return true;
    }

    @Override
    public int init(int index) {
        return 0;
    }

    @Override
    public String[] getInfo() {
        this.bsp = new NBioBSPJNI();
        this.exportEngine = new NBioBSPJNI.Export(this.bsp);
        NBioBSPJNI.INIT_INFO_0 initInfo0 = new NBioBSPJNI.INIT_INFO_0(this.bsp);
        this.bsp.GetInitInfo(initInfo0);
        if (this.checkError().booleanValue()) {
            return null;
        }
        String[] deviceInfo = new String[]{"Version", this.bsp.GetVersion(), "EnrollImageQuality", "" + initInfo0.EnrollImageQuality, "VerifyImageQuality", "" + initInfo0.VerifyImageQuality, "MaxFingersForEnroll", "" + initInfo0.MaxFingersForEnroll, "SamplesPerFinger", "" + initInfo0.SamplesPerFinger, "DefaultTimeout", "" + initInfo0.DefaultTimeout, "SecurityLevel", "" + (initInfo0.SecurityLevel - 1)};
        if (!this.SetDeviceList()) {
            return null;
        }
        return deviceInfo;
    }

    @Override
    public int terminate() {
        if (this.bsp != null) {
            this.bsp.dispose();
            this.bsp = null;
        }
        return 0;
    }

    @Override
    public int deleteBio(String id) {
        return 0;
    }

    @Override
    public int captureImage(int qty_samples, T user_data) {
        this.listener.onFinished(this, 0, user_data);
        NBioBSPJNI.Export.AUDIT exportAudit = new NBioBSPJNI.Export.AUDIT(this.exportEngine);
        this.SaveWSQData = new NBioBSPJNI.Export.TEMPLATE_DATA(this.exportEngine);
        float fQuality = 0.7f;
        this.exportEngine.ConvertRawToWsq(exportAudit.FingerData[0].Template[0].Data, exportAudit.ImageWidth, exportAudit.ImageHeight, this.SaveWSQData, fQuality);
        return 0;
    }

    @Override
    public int enroll(int qty_frames, String id, byte[] quality, T user_data) {
        return 0;
    }

    @Override
    public String identify(int[] finger, int[] score, T user_data) {
        return "teste";
    }

    @Override
    public int verify(byte[] template, T user_data) {
        return 0;
    }

    @Override
    public int deleteAll() {
        return 0;
    }
}

