/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.ScannerListener;
import com.ifractal.desktop.ScannerNative;
import com.ifractal.utils.Producer;

public abstract class Scanner<T>
extends Producer {
    public static final int SCANNER_RESULT_OK = 0;
    public static final int SCANNER_RESULT_MODULE_ERROR = -1;
    public static final int SCANNER_RESULT_SCANNER_ERROR = -2;
    public static final int SCANNER_RESULT_CAPTURE_ERROR = -3;
    public static final int SCANNER_RESULT_IDENTIFY_DB_ERROR = -4;
    public static final int SCANNER_RESULT_IDENTIFY_ERROR = -5;
    public static final int SCANNER_RESULT_VERIFY_ERROR = -6;
    public static final int SCANNER_RESULT_BIO_NOT_FOUND = -7;
    public static final int SCANNER_RESULT_BIO_NOT_ENROLLED = -8;
    public static final int SCANNER_RESULT_INVALID_PARAMETERS = -9;
    public static final int SCANNER_RESULT_ENROLL_DB_ERROR = -10;
    public static final int SCANNER_RESULT_DELETE_ERROR = -11;
    public static final int SCANNER_RESULT_UP_FIRMWARE_ERROR = -12;
    public static final int SCANNER_RESULT_EXTRACT_ERROR = -13;
    public static final int SCANNER_RESULT_GET_INFO_ERROR = -14;
    public static final int SCANNER_RESULT_BIO_NOT_MATCH = -15;
    public static String[][] scannersJava = new String[][]{{"Dummy Java", "com.ifractal.desktop.ScannerDummy", "dummy"}};
    public static String[][] scanners = null;
    protected ScannerListener<T> listener = null;
    protected String vendor = "";
    protected int index = 0;
    protected int height;
    protected int width;
    protected int quality;
    protected byte[] img;
    protected byte[] template;

    public static final String getErrorMessage(int e) {
        switch (e) {
            case 0: {
                return "OK";
            }
            case -1: {
                return "MODULE_ERROR";
            }
            case -2: {
                return "SCANNER_ERROR";
            }
            case -3: {
                return "CAPTURE_ERROR";
            }
            case -4: {
                return "IDENTIFY_DB_ERROR";
            }
            case -5: {
                return "IDENTIFY_ERROR";
            }
            case -6: {
                return "VERIFY_ERROR";
            }
            case -7: {
                return "BIO_NOT_FOUND";
            }
            case -8: {
                return "BIO_NOT_ENROLLED";
            }
            case -9: {
                return "INVALID_PARAMETERS";
            }
            case -10: {
                return "ENROLL_DB_ERROR";
            }
            case -11: {
                return "DELETE_ERROR";
            }
            case -12: {
                return "UP_FIRMWARE_ERROR";
            }
            case -13: {
                return "EXTRACT_ERROR";
            }
            case -14: {
                return "GET_INFO_ERROR";
            }
        }
        return "Indeterminado";
    }

    public static String[][] getScanners() {
        if (scanners != null) {
            return scanners;
        }
        String[] scannersC = ScannerNative.getVendors();
        if (scannersC == null) {
            scanners = scannersJava;
            return scanners;
        }
        scanners = new String[scannersJava.length + scannersC.length][];
        int i = 0;
        for (String[] stringArray : scannersJava) {
            Scanner.scanners[i++] = stringArray;
        }
        for (String[] stringArray : scannersC) {
            String[] s = stringArray.split("[|]");
            s[1] = "com.ifractal.desktop.ScannerNative";
            Scanner.scanners[i++] = s;
        }
        return scanners;
    }

    public Scanner(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public Scanner(long[] ctx, String[] args, ScannerListener<T> sl) {
        super(ctx, args);
        this.setListener(sl);
    }

    public void setListener(ScannerListener<T> sl) {
        this.listener = sl;
    }

    public String[] enumerate(String vendor) {
        this.vendor = vendor;
        return new String[0];
    }

    protected int init() {
        return this.init(this.index);
    }

    public int init(int index) {
        this.index = index;
        return 0;
    }

    public abstract int terminate();

    public abstract String[] getInfo();

    public abstract int captureImage(int var1, T var2);

    public abstract int enroll(int var1, String var2, byte[] var3, T var4);

    public abstract String identify(int[] var1, int[] var2, T var3);

    public abstract int verify(byte[] var1, T var2);

    public abstract int deleteBio(String var1);

    public abstract int deleteAll();
}

