/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;

public class ScannerNative<T>
extends Scanner<T> {
    protected long ptr = 0L;

    protected static native String[] getVendorsC();

    protected native String[] enumerateC(String var1);

    protected native long initC(String var1);

    protected native int terminateC(long var1);

    protected native int openC(long var1, int var3);

    protected native int closeC(long var1);

    protected native String[] getInfoC(long var1);

    protected native int captureImageC(long var1, ScannerListener<T> var3, int var4, T var5);

    protected native int enrollC(long var1, ScannerListener<T> var3, int var4, String var5, byte[] var6, T var7);

    protected native int verifyC(long var1, ScannerListener<T> var3, byte[] var4, T var5);

    protected native int deleteAllC(long var1);

    protected native int deleteBioC(long var1, String var3);

    public static final String[] getVendors() {
        try {
            System.loadLibrary("scanner");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
        }
        return ScannerNative.getVendorsC();
    }

    public ScannerNative(long[] ctx, String[] args) {
        super(ctx, args);
        ScannerNative.getVendors();
    }

    public ScannerNative(long[] ctx, String[] args, ScannerListener<T> sl) {
        super(ctx, args, sl);
    }

    @Override
    public int init(int index) {
        String v = this.vendor;
        if (v == null) {
            v = "";
        }
        this.ptr = this.initC(this.vendor);
        if (this.ptr == 0L) {
            return -2;
        }
        int r = this.openC(this.ptr, index);
        return r;
    }

    @Override
    public int terminate() {
        int r = 0;
        if (this.ptr != 0L) {
            r = this.terminateC(this.ptr);
        }
        return r;
    }

    @Override
    public String[] enumerate(String vendor) {
        super.enumerate(vendor);
        String[] devs = this.enumerateC(vendor);
        return devs;
    }

    @Override
    public String[] getInfo() {
        String[] r = this.getInfoC(this.ptr);
        return r;
    }

    @Override
    public int captureImage(int qty_samples, T user_data) {
        int r = this.captureImageC(this.ptr, this.listener, qty_samples, user_data);
        return r;
    }

    @Override
    public int enroll(int qty_frames, String id, byte[] quality, T user_data) {
        int r = this.enrollC(this.ptr, this.listener, qty_frames, id, quality, user_data);
        return r;
    }

    @Override
    public String identify(int[] finger, int[] score, T user_data) {
        return "";
    }

    @Override
    public int verify(byte[] template, T user_data) {
        int r = this.verifyC(this.ptr, this.listener, template, user_data);
        return r;
    }

    @Override
    public int deleteBio(String id) {
        int r = this.deleteBioC(this.ptr, id);
        return r;
    }

    @Override
    public int deleteAll() {
        int r = this.deleteAllC(this.ptr);
        return r;
    }
}

