/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ifractal.ifponto.ControlID;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class IDAccess
extends ControlID {
    protected final String LOAD_OBJECTS = "load_objects.fcgi";
    protected final String CREATE_OBJECTS = "create_objects.fcgi";
    protected final String MODIFY_OBJECTS = "modify_objects.fcgi";
    protected final String DESTROY_OBJECTS = "destroy_objects.fcgi";
    protected final String USER_SET_IMAGE_LIST = "user_set_image_list.fcgi";
    protected static final String[] EVENT = new String[]{"---", "Equipamento inv\u00e1lido", "Par\u00e2metros de regra de identifica\u00e7\u00e3o inv\u00e1lidos", "N\u00e3o identificado", "Identifica\u00e7\u00e3o pendente", "Timeout na identifica\u00e7\u00e3o", "Acesso negado", "Acesso autorizado", "Acesso pendente", "Usu\u00e1rio n\u00e3o \u00e9 administrador", "Acesso n\u00e3o identificado", "Acesso atrav\u00e9s de botoeira", "Acesso atrav\u00e9s da interface WEB", "Desist\u00eancia de entrada"};
    protected long ten_minutes = 600L;
    protected long timediff = 0L;

    public IDAccess(JSONObject config) {
        super(config);
    }

    protected int deleteObjects(String obj, String key, long id) {
        JSONObject main = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject objs = new JSONObject();
        main.put((Object)"object", (Object)obj);
        main.put((Object)"where", (Object)where);
        where.put((Object)obj, (Object)objs);
        objs.put((Object)key, (Object)id);
        JSONArray exec_res = this.exec("destroy_objects.fcgi", main.toString());
        if (exec_res == null) {
            return 700;
        }
        return 0;
    }

    protected int insertTemplates(JSONObject juser, final int id) {
        JSONArray res;
        this.sendMessage(2, "entra insertTemplates ");
        if (!juser.containsKey((Object)"templates") || !(juser.get((Object)"templates") instanceof JSONArray)) {
            return 302;
        }
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] q) {
                int user_id = (Integer)pars[0];
                JSONArray valuesBio = (JSONArray)pars[1];
                JSONArray valuesFace = (JSONArray)pars[2];
                for (String k : new String[]{"vendor", "template"}) {
                    if (jtemp.containsKey((Object)k)) continue;
                    return 0;
                }
                String vendor = jtemp.get((Object)"vendor").toString();
                String template = jtemp.get((Object)"template").toString();
                if (template.equals("")) {
                    return 0;
                }
                JSONObject reg = new JSONObject();
                reg.put((Object)"user_id", (Object)user_id);
                if (vendor.equals("idclass")) {
                    reg.put((Object)"id", (Object)((id + 100000) * 100 + q[0]));
                    reg.put((Object)"finger_type", (Object)0);
                    reg.put((Object)"template", jtemp.get((Object)"template"));
                    valuesBio.add((Object)reg);
                    q[0] = q[0] + 1;
                }
                if (vendor.equals("jpg")) {
                    IDAccess.this.sendMessage(2, "antes converter para base64 ");
                    byte[] photo = Util.base642byte(template);
                    IDAccess.this.sendMessage(2, "pos converter para base64 ");
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    IDAccess.this.sendMessage(2, "antes decodeByteArray ");
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])photo, (int)0, (int)photo.length, (BitmapFactory.Options)options);
                    IDAccess.this.sendMessage(2, "pos decodeByteArray ");
                    int height = bitmap.getHeight();
                    int width = bitmap.getWidth();
                    while (height >= 1000 || width >= 1000) {
                        IDAccess.this.sendMessage(2, "antes createScaledBitmap ");
                        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)width * 0.5)), (int)((int)((double)height * 0.5)), (boolean)true);
                        IDAccess.this.sendMessage(2, "pos createScaledBitmap ");
                        height = bitmap.getHeight();
                        width = bitmap.getWidth();
                    }
                    ByteArrayOutputStream blob = new ByteArrayOutputStream();
                    IDAccess.this.sendMessage(2, "antes bitmapCompress ");
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)blob);
                    IDAccess.this.sendMessage(2, "pos bitmapCompress ");
                    photo = blob.toByteArray();
                    IDAccess.this.sendMessage(2, "antes volta para base64 ");
                    template = Util.byte2base64(photo);
                    IDAccess.this.sendMessage(2, "pos volta para base64 ");
                    reg.put((Object)"timestamp", (Object)(System.currentTimeMillis() / 1000L));
                    reg.put((Object)"image", (Object)template);
                    valuesFace.add((Object)reg);
                    q[0] = q[0] + 1;
                }
                return 0;
            }
        };
        boolean ok = false;
        JSONObject mainBio = new JSONObject();
        JSONObject mainFace = new JSONObject();
        JSONArray valuesBio = new JSONArray();
        JSONArray valuesFace = new JSONArray();
        mainBio.put((Object)"object", (Object)"templates");
        mainBio.put((Object)"values", (Object)valuesBio);
        mainFace.put((Object)"match", (Object)true);
        mainFace.put((Object)"user_images", (Object)valuesFace);
        int[] q = new int[]{0};
        Object[] pars = new Object[]{id, valuesBio, valuesFace};
        Util.jsonIter((JSONArray)juser.get((Object)"templates"), iter, pars, q);
        this.sendMessage(2, "pos JSONITER ");
        if (q[0] <= 0) {
            return 302;
        }
        if (valuesBio.size() > 0) {
            res = this.exec("create_objects.fcgi", mainBio.toString());
            if (res == null && valuesFace.size() < 1) {
                return 604;
            }
            if (res != null) {
                ok = true;
            }
        }
        if (valuesFace.size() > 0 && this.modelo.equalsIgnoreCase("idface")) {
            JSONArray results;
            JSONObject result;
            res = this.exec("user_set_image_list.fcgi", mainFace.toString());
            if (res == null) {
                return 607;
            }
            JSONObject ret = (JSONObject)res.get(0);
            if (ret.containsKey((Object)"results") && (result = (JSONObject)(results = (JSONArray)ret.get((Object)"results")).get(0)).containsKey((Object)"success") && !((Boolean)result.get((Object)"success")).booleanValue()) {
                return 607;
            }
            ok = true;
        }
        if (ok) {
            return 0;
        }
        return 604;
    }

    protected int insertCards(JSONObject juser, int id) {
        IfaceJSONIter card_iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jcard, Object[] pars, int[] q) {
                int user_id = (Integer)pars[0];
                JSONArray values = (JSONArray)pars[1];
                JSONObject reg = new JSONObject();
                try {
                    String val = jcard.get((Object)"nro").toString();
                    long value = ControlID.convertRFID_nominal2code(val);
                    reg.put((Object)"user_id", (Object)user_id);
                    reg.put((Object)"id", (Object)value);
                    reg.put((Object)"value", (Object)value);
                    values.add((Object)reg);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return 0;
            }
        };
        JSONObject main = new JSONObject();
        JSONArray values = new JSONArray();
        main.put((Object)"object", (Object)"cards");
        main.put((Object)"values", (Object)values);
        Object[] pars = new Object[]{id, values};
        Util.jsonIter((JSONArray)juser.get((Object)"nro_cartao"), card_iter, pars, null);
        if (values.size() < 1) {
            return 0;
        }
        JSONArray res = this.exec("create_objects.fcgi", main.toString());
        if (res == null) {
            return 601;
        }
        return 0;
    }

    protected int bindTimeSpan(int id) {
        JSONObject main = new JSONObject();
        main.put((Object)"object", (Object)"user_access_rules");
        JSONArray values = new JSONArray();
        main.put((Object)"values", (Object)values);
        JSONObject reg = new JSONObject();
        reg.put((Object)"user_id", (Object)id);
        reg.put((Object)"access_rule_id", (Object)1);
        values.add((Object)reg);
        JSONArray res = this.exec("create_objects.fcgi", main.toString());
        if (res == null) {
            return 606;
        }
        return 0;
    }

    protected int insert(JSONObject juser, int id) {
        JSONObject main = new JSONObject();
        main.put((Object)"object", (Object)"users");
        JSONArray values = new JSONArray();
        main.put((Object)"values", (Object)values);
        JSONObject reg = new JSONObject();
        reg.put((Object)"id", (Object)id);
        reg.put((Object)"registration", (Object)("" + id));
        reg.put((Object)"password", (Object)"");
        reg.put((Object)"salt", (Object)"");
        reg.put((Object)"name", juser.get((Object)"nome"));
        values.add((Object)reg);
        JSONArray res = this.exec("create_objects.fcgi", main.toString());
        if (res == null) {
            return 605;
        }
        int r = this.insertCards(juser, id);
        this.bindTimeSpan(id);
        return r;
    }

    protected int update(JSONObject juser, int id) {
        JSONObject main = new JSONObject();
        JSONObject values = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject users = new JSONObject();
        main.put((Object)"object", (Object)"users");
        main.put((Object)"values", (Object)values);
        main.put((Object)"where", (Object)where);
        where.put((Object)"users", (Object)users);
        values.put((Object)"name", juser.get((Object)"nome"));
        values.put((Object)"registration", (Object)("" + id));
        users.put((Object)"id", (Object)id);
        this.exec("modify_objects.fcgi", main.toString());
        this.deleteObjects("cards", "user_id", id);
        int r = this.insertCards(juser, id);
        return r;
    }

    public JSONArray getUsers(Object[] ctx) {
        long now = new Date().getTime() / 1000L;
        long last = (Long)ctx[1];
        JSONArray users = (JSONArray)ctx[2];
        if (users == null || now - last > this.ten_minutes) {
            users = this.getUsers();
        }
        ctx[1] = now;
        ctx[2] = users;
        return users;
    }

    @Override
    public int updateUser(Object[] ctx, JSONObject juser) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject reg, Object[] pars, int[] q) {
                int codigo = (Integer)pars[0];
                boolean[] exist = (boolean[])pars[1];
                if (!reg.containsKey((Object)"id")) {
                    return 0;
                }
                try {
                    int id = Integer.parseInt(reg.get((Object)"id").toString());
                    if (id != codigo) {
                        return 0;
                    }
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                exist[0] = true;
                return 1;
            }
        };
        for (String key : new String[]{"nome", "codigo", "nro_cartao"}) {
            if (juser.containsKey((Object)key)) continue;
            return 130;
        }
        JSONArray cid_users = this.getUsers(ctx);
        if (cid_users == null) {
            return 1200;
        }
        int r = 0;
        int codigo = Integer.parseInt(juser.get((Object)"codigo").toString());
        boolean[] exist = new boolean[]{false};
        Util.jsonIter(cid_users, iter, new Object[]{codigo, exist}, null);
        r = exist[0] ? this.update(juser, codigo) : this.insert(juser, codigo);
        return r;
    }

    @Override
    public int deleteUser(Object[] ctx, JSONObject juser) {
        long id = Long.parseLong(juser.get((Object)"codigo").toString());
        int r = this.deleteObjects("cards", "user_id", id);
        r = this.deleteObjects("users", "id", id);
        return r;
    }

    @Override
    public int sendUserBio(Object[] ctx, JSONObject juser) {
        this.sendMessage(2, "entra sendUserBio - ");
        if (juser.containsKey((Object)"tipo") && juser.get((Object)"tipo").equals("excluir")) {
            return 302;
        }
        int r = this.updateUser(ctx, juser);
        if (r != 0) {
            this.sendMessage(2, "updateUser error - " + r);
            return r;
        }
        this.sendMessage(2, "updateUser ok " + r);
        int id = Integer.parseInt(juser.get((Object)"codigo").toString());
        r = this.deleteUserBio(ctx, juser);
        r = this.insertTemplates(juser, id);
        this.sendMessage(2, "retorna sendUserBio - " + r);
        return r;
    }

    @Override
    public int deleteUserBio(Object[] ctx, JSONObject juser) {
        long id = Long.parseLong(juser.get((Object)"codigo").toString());
        int r = this.deleteObjects("templates", "user_id", id);
        return r;
    }

    @Override
    public int getUserBio(Object[] ctx, JSONObject juser) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] q) {
                JSONArray jtemps = (JSONArray)pars[0];
                JSONObject reg = new JSONObject();
                String temp = jtemp.get((Object)"template").toString();
                reg.put((Object)"vendor", (Object)"idclass");
                reg.put((Object)"encode", (Object)"b64");
                reg.put((Object)"template", (Object)temp);
                jtemps.add((Object)reg);
                return 0;
            }
        };
        int id = Integer.parseInt(juser.get((Object)"codigo").toString());
        JSONObject req = new JSONObject();
        JSONObject where = new JSONObject();
        JSONObject where_temp = new JSONObject();
        req.put((Object)"object", (Object)"templates");
        req.put((Object)"where", (Object)where);
        where.put((Object)"templates", (Object)where_temp);
        where_temp.put((Object)"user_id", (Object)id);
        JSONArray res = this.exec("load_objects.fcgi", req.toString());
        if (res == null) {
            return 1300;
        }
        if (res.size() < 1) {
            return 0;
        }
        JSONObject e = (JSONObject)res.get(0);
        if (!e.containsKey((Object)"templates")) {
            return 0;
        }
        JSONArray temps = (JSONArray)e.get((Object)"templates");
        JSONArray juser_temps = new JSONArray();
        juser.put((Object)"templates", (Object)juser_temps);
        Util.jsonIter(temps, iter, new Object[]{juser_temps}, null);
        return 0;
    }

    @Override
    public void getInfo(JSONObject jinfo) {
        String[] keys;
        JSONArray res = this.exec("system_information.fcgi", null);
        if (res == null || res.size() < 1) {
            this.sendMessage(2, "Falha ao tentar recuperar info.");
            return;
        }
        JSONObject data = (JSONObject)res.get(0);
        long reftime = 0L;
        for (String key : keys = new String[]{"serial", "version", "time", "network"}) {
            if (!data.containsKey((Object)key)) continue;
            if (key.equals("time")) {
                reftime = (Long)data.get((Object)key);
            }
            jinfo.put((Object)key, data.get((Object)key));
        }
        if (reftime > 0L) {
            this.timediff = new Date().getTime() / 1000L - reftime;
        }
    }

    @Override
    public Date getTime() {
        JSONObject jinfo = new JSONObject();
        this.getInfo(jinfo);
        if (!jinfo.containsKey((Object)"time")) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        long millis = (Long)jinfo.get((Object)"time") * 1000L;
        Date date = new Date(millis - (long)(calendar.get(15) + calendar.get(16)));
        return date;
    }

    @Override
    public boolean setTime(int diff) {
        return this.setTime("set_system_time.fcgi", diff);
    }

    @Override
    public int getEvents(JSONArray offs) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject log, Object[] pars, int[] nsr) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                JSONArray logs = (JSONArray)pars[0];
                JSONObject off = new JSONObject();
                String[] keys = new String[]{"id", "nsr", "user_id", "codigo", "card_value", "cracha", "event", null, "time", null};
                int i = 0;
                while (i + 1 < keys.length) {
                    if (!log.containsKey((Object)keys[i])) {
                        return 0;
                    }
                    i += 2;
                }
                i = 0;
                while (i + 1 < keys.length) {
                    String val;
                    if (keys[i + 1] != null && (val = log.get((Object)keys[i]).toString()) != null && !val.equals("") && !val.equals("0")) {
                        if (keys[i + 1].equals("cracha")) {
                            off.put((Object)keys[i + 1], (Object)ControlID.convertRFID_code2nominal((Long)log.get((Object)keys[i])));
                        } else {
                            off.put((Object)keys[i + 1], (Object)val);
                        }
                    }
                    i += 2;
                }
                nsr[0] = Integer.parseInt(off.get((Object)"nsr").toString());
                long i2 = (Long)log.get((Object)"event");
                if (i2 > (long)EVENT.length || i2 == 3L) {
                    return 0;
                }
                off.put((Object)"sentido", (Object)"I");
                off.put((Object)"event", (Object)EVENT[(int)i2]);
                long t = ((Long)log.get((Object)"time") + IDAccess.this.timediff) * 1000L;
                Date dt = new Date();
                dt.setTime(t);
                off.put((Object)"datahora", (Object)fmt.format(dt));
                logs.add((Object)off);
                return 0;
            }
        };
        if (this.timediff == 0L) {
            this.getInfo(new JSONObject());
        }
        JSONObject req = new JSONObject();
        req.put((Object)"object", (Object)"access_logs");
        JSONObject where = new JSONObject();
        JSONObject id = new JSONObject();
        id.put((Object)">=", (Object)this.getNsr());
        id.put((Object)"<=", (Object)(this.getNsr() + 50));
        where.put((Object)"id", (Object)id);
        JSONObject access_logs = new JSONObject();
        access_logs.put((Object)"access_logs", (Object)where);
        req.put((Object)"where", (Object)access_logs);
        JSONArray res = this.exec("load_objects.fcgi", req.toString());
        if (res == null || res.size() < 1) {
            this.sendMessage(2, "(1) Falha ao tentar recuperar eventos.");
            return -1;
        }
        JSONObject data = (JSONObject)res.get(0);
        if (!data.containsKey((Object)"access_logs")) {
            this.sendMessage(2, "(2) Falha ao tentar recuperar eventos.");
            return -2;
        }
        int[] nsr = new int[]{0};
        this.sendMessage(5, data.get((Object)"access_logs").toString());
        Util.jsonIter((JSONArray)data.get((Object)"access_logs"), iter, new Object[]{offs}, nsr);
        return nsr[0] + 1;
    }

    @Override
    public JSONArray getUsers() {
        JSONObject req = new JSONObject();
        req.put((Object)"object", (Object)"users");
        JSONArray res = this.exec("load_objects.fcgi", req.toString());
        if (res == null || res.size() < 1) {
            this.sendMessage(2, "Falha ao tentar recuperar users.");
            return null;
        }
        JSONObject data = (JSONObject)res.get(0);
        return (JSONArray)data.get((Object)"users");
    }
}

