/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ifractal.ifponto.DeviceExtended;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ZK
extends DeviceExtended<Object> {
    public static final String HTTP_HEADER = "HTTP/1.1 200 OK\r\nServer: iFractal/" + Version.getText() + "\r\nContent-Type: text/plain;charset=UTF-8\r\n";
    public static final String HTTP_HEADER_ERROR = "HTTP/1.1 406 NOT Registred\r\nServer: iFractal/" + Version.getText() + "\r\nContent-Type: text/plain;charset=UTF-8\r\nContent-Length: 11\r\n\r\nregistry=NO";
    public static final int SERVER_PORT = 8088;
    public static final int TIMEOUT = 600;
    protected static int server_port = 8088;
    protected static Thread main_th = null;
    protected static ZK[] listeners = null;
    protected static String ForeignOrigin = "98";
    protected long last = 0L;
    protected int packcnt = 0;
    protected int packidx = 0;
    protected String SN = "";
    protected int session = 0;
    protected int cmdid = (int)(new Date().getTime() % 1000L);
    protected Queue<String> cmdQueue = null;
    protected ArrayList<Integer> confirmList = null;
    protected Queue<String[]> eventsQueue = null;
    protected Queue<String[]> usersQueue = null;
    protected Queue<String[]> bioQueue = null;
    protected String[] info = null;
    protected static Runnable loop = new Runnable(){

        @Override
        public void run() {
            ServerSocket ss = null;
            try {
                ss = new ServerSocket(server_port);
                while (true) {
                    Socket cli = ss.accept();
                    ZK.httpClient(cli);
                }
            }
            catch (IOException e) {
                main_th = null;
                return;
            }
        }
    };

    public static int encodeZKTime(String in) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            Date dt = f.parse(in);
            return ZK.encodeZKTime(dt);
        }
        catch (ParseException pe) {
            return 0;
        }
    }

    public static int encodeZKTime(Date in) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        return ZK.encodeZKTime(cal);
    }

    public static int encodeZKTime(Calendar in) {
        int year = in.get(1);
        int mon = in.get(2) + 1;
        int day = in.get(5);
        int hour = in.get(11);
        int min = in.get(12);
        int sec = in.get(13);
        int tt = ((year - 2000) * 12 * 31 + (mon - 1) * 31 + day - 1) * 86400 + (hour * 60 + min) * 60 + sec;
        return tt;
    }

    public static Date decodeZKTime(int zktime) {
        int sec = zktime % 60;
        int min = (zktime /= 60) % 60;
        int hour = (zktime /= 60) % 24;
        int day = (zktime /= 24) % 31 + 1;
        int mon = (zktime /= 31) % 12;
        int year = (zktime /= 12) + 2000;
        Calendar dt = Calendar.getInstance();
        dt.set(year, mon, day, hour, min, sec);
        return dt.getTime();
    }

    protected static synchronized ZK getDevice(String ip, String sn) {
        for (ZK dev : listeners) {
            if (dev.SN.equals(sn)) {
                return dev;
            }
            if (!dev.ip.equals(ip)) continue;
            return dev;
        }
        return null;
    }

    protected static String[] getFromTo(String tablename) {
        String[] r = new String[]{""};
        if (tablename.equals("user")) {
            r = new String[]{"name", "nome", "pin", "codigo", "cardno", "cracha"};
        }
        return r;
    }

    protected static void fromTo(String[][] table, String tablename) {
        String[] FromTo = ZK.getFromTo(tablename);
        for (String[] line : table) {
            int k = 0;
            while (k + 1 < line.length) {
                int j = 0;
                while (j + 1 < FromTo.length) {
                    if (line[k].equals(FromTo[j])) {
                        line[k] = FromTo[j + 1];
                        break;
                    }
                    j += 2;
                }
                k += 2;
            }
        }
    }

    protected static String[][] splitTable(String query, String s1, String s2) throws UnsupportedEncodingException {
        String[] lns = query.split("\r\n");
        String[][] table = new String[lns.length][];
        int k = 0;
        for (String line : lns) {
            table[k++] = ZK.splitParameters(line, " ", s1, s2);
        }
        return table;
    }

    protected static String[] splitParameters(String query, String s1, String s2) throws UnsupportedEncodingException {
        return ZK.splitParameters(query, null, s1, s2);
    }

    protected static String[] splitParameters(String query, String init, String s1, String s2) throws UnsupportedEncodingException {
        String[] tk;
        LinkedList<String> list = new LinkedList<String>();
        int p = -1;
        if (init != null) {
            p = query.indexOf(init);
        }
        for (String e : tk = query.substring(p + 1).split(s1)) {
            String[] kv = e.split(s2);
            list.add(kv[0]);
            if (kv.length > 1) {
                list.add(kv[1]);
                continue;
            }
            list.add("");
        }
        String[] pars = new String[list.size()];
        for (int i = 0; i < pars.length; ++i) {
            pars[i] = (String)list.get(i);
        }
        return pars;
    }

    protected static String[] getCookies(String[] headers) throws UnsupportedEncodingException {
        for (String e : headers) {
            if (!e.startsWith("Cookie: ")) continue;
            return ZK.splitParameters(e.substring(8), ",", "=");
        }
        return null;
    }

    private static void respond(PrintWriter out, String[] headers, ZK dev, String type, String path, String[] GET, String data) throws IOException {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        String[] cookies = ZK.getCookies(headers);
        Date now = new Date();
        String resp = HTTP_HEADER;
        String content = "OK";
        int sess = -1;
        String token = Util.getValueFromArgs(cookies, "token");
        if (dev != null && token != null && token.length() > 5) {
            dev.session = sess = System.identityHashCode(token);
        }
        if (dev != null && !path.equals("/iclock/cdata")) {
            if (path.equals("/iclock/querydata")) {
                if (data.contains("FirmVer")) {
                    dev.info = ZK.splitParameters(data, ",", "=");
                }
                String[][] table = ZK.splitTable(data, "\t", "=");
                String tablename = Util.getValueFromArgs(GET, "tablename");
                ZK.fromTo(table, tablename);
                if (data.length() >= 4) {
                    if (tablename.equals("user")) {
                        for (String[] e : table) {
                            dev.usersQueue.add(e);
                        }
                    } else if (tablename.equals("transaction")) {
                        for (String[] e : table) {
                            if (dev.eventsQueue.size() <= 100) {
                                dev.eventsQueue.add(e);
                                continue;
                            }
                            break;
                        }
                    } else if (tablename.equals("biodata")) {
                        for (String[] e : table) {
                            if (e == null) continue;
                            dev.bioQueue.add(e);
                        }
                    }
                }
                dev.packcnt = Util.getIntFromArgs(GET, "packcnt");
                dev.packidx = Util.getIntFromArgs(GET, "packidx");
                dev.last = new Date().getTime();
            } else if (path.equals("/iclock/registry")) {
                if (dev.session == 0) {
                    dev.info = ZK.splitParameters(data, ",", "=");
                    dev.session = sess = System.identityHashCode(dev);
                    content = "RegistryCode=" + sess;
                } else {
                    sess = dev.session;
                    content = "registry=OK\r\n";
                }
            } else if (path.equals("/iclock/getrequest")) {
                if (!dev.cmdQueue.isEmpty()) {
                    content = dev.cmdQueue.remove();
                }
            } else if (path.equals("/iclock/push")) {
                sess = dev.session;
                content = "registry=OK\r\n";
                content = content + "ServerVersion=" + Version.getText() + "\r\n";
                content = content + "ServerName=iFractal\r\n";
                content = content + "Realtime=0\r\n";
                content = content + "SessionID=" + sess + "\r\n";
                content = content + "PushProtoVer=3.1.2\r\n";
                content = content + "PushOptionsFlags=0\r\n";
            } else if (!path.equals("/iclock/ping") && path.equals("/iclock/devicecmd")) {
                String[] fields = ZK.splitParameters(data, "&", "=");
                int id = Util.getIntFromArgs(fields, "ID");
                Integer e = null;
                for (Integer i : dev.confirmList) {
                    if (i != id) continue;
                    e = i;
                    break;
                }
                if (e != null) {
                    dev.confirmList.remove(e);
                }
                dev.last = new Date().getTime();
            }
        }
        if (dev != null && dev.session > 0) {
            sess = dev.session;
        }
        if (dev == null || sess < 0) {
            resp = HTTP_HEADER_ERROR;
        } else {
            resp = HTTP_HEADER;
            resp = resp + "Date: " + fmt.format(now) + "\r\n";
            resp = resp + "Content-Length: " + content.length() + "\r\n\r\n";
            resp = resp + content;
        }
        out.println(resp);
    }

    protected static void handler(String ip, PrintWriter out, String[] headers) throws IOException, UnsupportedEncodingException {
        String[] tk = headers[0].split(" ");
        if (tk.length < 3) {
            ZK.respond(out, headers, null, null, null, null, null);
            return;
        }
        String type = tk[0];
        if ((tk = tk[1].split("\\?")).length < 2) {
            ZK.respond(out, headers, null, null, null, null, null);
            return;
        }
        String path = tk[0];
        String query = tk[1];
        String[] GET = ZK.splitParameters(query, "&", "=");
        String sn = Util.getValueFromArgs(GET, "SN");
        ZK dev = null;
        if (sn != null) {
            dev = ZK.getDevice(ip, sn);
        }
        String data = "";
        if (type.equals("POST") && !headers[headers.length - 1].startsWith("Content-Length")) {
            data = headers[headers.length - 1];
        }
        ZK.respond(out, headers, dev, type, path, GET, data);
    }

    protected static void httpClient(final Socket cli) {
        Runnable peer = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = cli.getInputStream();
                    LinkedList<String> headers = new LinkedList<String>();
                    int len = 0;
                    while ((line = Util.readLine(is)) != null && line.length() >= 3) {
                        headers.add(line);
                        String[] tk = line.split(": ");
                        if (!tk[0].equals("Content-Length")) continue;
                        len = Integer.parseInt(tk[1]);
                    }
                    if (len > 0) {
                        int n;
                        int pos = 0;
                        byte[] buf = new byte[len];
                        while ((pos += (n = is.read(buf, pos, len - pos))) < len) {
                        }
                        String cnt = new String(buf);
                        headers.add(cnt);
                    }
                    PrintWriter out = new PrintWriter(cli.getOutputStream(), true);
                    String[] arr = new String[headers.size()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (String)headers.get(i);
                    }
                    if (arr.length > 0) {
                        ZK.handler(cli.getInetAddress().toString().substring(1), out, arr);
                    }
                    is.close();
                    out.close();
                    cli.close();
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (UnsupportedEncodingException uee) {
                    return;
                }
                catch (IOException e) {
                    return;
                }
            }
        };
        Thread th = new Thread(peer);
        th.start();
    }

    private static synchronized void initServer(JSONObject config) {
        if (main_th != null) {
            return;
        }
        try {
            if (config.containsKey((Object)"ZK_PORT")) {
                server_port = Integer.parseInt(config.get((Object)"ZK_PORT").toString());
            }
        }
        catch (NumberFormatException nfe) {
            return;
        }
        System.out.println("Inicia ZK Server em: " + server_port);
        main_th = new Thread(loop);
        main_th.start();
    }

    private static synchronized int addListener(ZK zk) {
        if (listeners == null) {
            listeners = new ZK[]{zk};
            return 1;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!ZK.listeners[i].nro.equals(zk.nro)) continue;
            ZK.listeners[i] = zk;
            return listeners.length;
        }
        int len = listeners.length;
        ZK[] tmp = new ZK[len + 1];
        System.arraycopy(listeners, 0, tmp, 0, len);
        tmp[len] = zk;
        listeners = tmp;
        return listeners.length;
    }

    public ZK(JSONObject c) {
        super(c);
        if (c.containsKey((Object)"SN")) {
            this.SN = c.get((Object)"SN").toString();
        } else {
            this.sendMessage(1, "\"SN\" (Serial Number) n\u00e3o definido.");
        }
        this.cmdQueue = new LinkedList<String>();
        this.confirmList = new ArrayList();
        this.eventsQueue = new LinkedList<String[]>();
        this.usersQueue = new LinkedList<String[]>();
        this.bioQueue = new LinkedList<String[]>();
    }

    protected int waitData() {
        ZK.initServer(this.config);
        long now = new Date().getTime();
        int i = 0;
        try {
            for (i = 0; !(i >= 600 || this.last > now && this.packidx >= this.packcnt && this.confirmList.isEmpty()); ++i) {
                Thread.sleep(1000L);
            }
            if (i >= 600) {
                System.err.println("TIMEOUT!");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return i;
    }

    protected int addCmd(String query) {
        int id = this.cmdid++;
        String cmd = query.startsWith("ACCOUNT") || query.startsWith("GET") ? "C:" + id + ":" + query : "C:" + id + ":DATA " + query;
        this.cmdQueue.add(cmd);
        this.confirmList.add(id);
        return id;
    }

    @Override
    public Date getTime() {
        ZK.addListener(this);
        this.addCmd("GET OPTIONS ~SerialNumber,FirmVer,~DeviceName,LockCount,ReaderCount,AuxInCount,AuxOutCount,MachineType,~IsOnlyRFMachine,~MaxUserCount,~MaxAttLogCount,~MaxFingerCount,~MaxUserFingerCount,MThreshold,NetMask,GATEIPAddress,~ZKFPVersion,SimpleEventType,VerifyStyles,EventTypes,ComPwd");
        this.waitData();
        if (this.session == 0) {
            return null;
        }
        return new Date();
    }

    @Override
    public boolean setTime(int diff) {
        return this.session != 0;
    }

    @Override
    public void getInfo(JSONObject c) {
        ZK.addListener(this);
        this.addCmd("GET OPTIONS ~SerialNumber,FirmVer,~DeviceName,LockCount,ReaderCount,AuxInCount,AuxOutCount,MachineType,~IsOnlyRFMachine,~MaxUserCount,~MaxAttLogCount,~MaxFingerCount,~MaxUserFingerCount,MThreshold,NetMask,GATEIPAddress,~ZKFPVersion,SimpleEventType,VerifyStyles,EventTypes,ComPwd");
        this.waitData();
        if (this.session == 0 || this.info == null) {
            return;
        }
        int k = 0;
        while (k + 1 < this.info.length) {
            c.put((Object)this.info[k], (Object)this.info[k + 1]);
            k += 2;
        }
    }

    @Override
    public JSONArray getUsers() {
        ZK.addListener(this);
        this.addCmd("QUERY tablename=user,fielddesc=*,filter=*");
        this.waitData();
        JSONArray arr = new JSONArray();
        while (!this.usersQueue.isEmpty()) {
            String[] line = this.usersQueue.remove();
            JSONObject e = new JSONObject();
            arr.add((Object)e);
            int k = 0;
            while (k + 1 < line.length) {
                e.put((Object)line[k], (Object)line[k + 1]);
                k += 2;
            }
        }
        return arr;
    }

    @Override
    public int getEvents(JSONArray offs) {
        int nsr = 0;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ZK.addListener(this);
        this.addCmd("ACCOUNT transaction MaxIndex=" + (this.getNsr() - 1));
        this.waitData();
        if (this.session <= 0) {
            return -1;
        }
        String[] fromTo = new String[]{"pin", "codigo", "index", "nsr", "cardno", null, "maskflag", null, "inoutstate", null, "verified", null, "temperature", null, "eventtype", null, "doorid", null};
        while (!this.eventsQueue.isEmpty()) {
            JSONObject reg = new JSONObject();
            String[] e = this.eventsQueue.remove();
            int k = 0;
            while (k + 1 < e.length) {
                String key = e[k];
                String val = e[k + 1];
                if (e[k].equals("eventtype")) {
                    key = "auth";
                    int type = Integer.parseInt(val);
                    val = type >= 0 && type <= 19 || type >= 200 && type <= 253 ? "L" : "B";
                } else if (e[k].equals("time_second")) {
                    int ts = Integer.parseInt(e[k + 1]);
                    Date dt = ZK.decodeZKTime(ts);
                    key = "datahora";
                    val = fmt.format(dt);
                } else if (e[k].equals("index")) {
                    key = "nsr";
                    nsr = Integer.parseInt(val);
                } else {
                    int j = 0;
                    while (j + 1 < fromTo.length) {
                        if (key.equals(fromTo[j])) {
                            if (fromTo[j + 1] == null) {
                                key = null;
                                break;
                            }
                            key = fromTo[j + 1];
                            break;
                        }
                        j += 2;
                    }
                }
                if (key != null && key.equals("codigo") && val.equals("0")) break;
                if (key != null) {
                    reg.put((Object)key, (Object)val);
                }
                k += 2;
            }
            if (reg.isEmpty()) continue;
            offs.add((Object)reg);
        }
        return nsr;
    }

    @Override
    public int getBio(JSONArray jusers) {
        super.getBio(jusers);
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject juser, Object[] pars, int[] c) {
                if (!juser.containsKey((Object)"codigo")) {
                    return 0;
                }
                String[][] tmps = (String[][])pars[0];
                String codigo = juser.get((Object)"codigo").toString();
                JSONArray templates = null;
                if (juser.containsKey((Object)"templates")) {
                    templates = (JSONArray)juser.get((Object)"templates");
                } else {
                    templates = new JSONArray();
                    juser.put((Object)"templates", (Object)templates);
                }
                for (String[] e : tmps) {
                    String tmp;
                    String pin = Util.getValueFromArgs(e, "pin");
                    if (!pin.equals(codigo) || (tmp = Util.getValueFromArgs(e, "tmp")).length() < 2) continue;
                    JSONObject obj = new JSONObject();
                    templates.add((Object)obj);
                    obj.put((Object)"vendor", (Object)"zk_unified");
                    obj.put((Object)"encode", (Object)"b64");
                    obj.put((Object)"template", (Object)tmp);
                }
                return 0;
            }
        };
        int i = 0;
        int qty = this.bioQueue.size();
        String[][] temps = new String[qty][];
        while (!this.bioQueue.isEmpty()) {
            temps[i++] = this.bioQueue.remove();
        }
        Util.jsonIter(jusers, iter, new Object[]{temps}, null);
        return 0;
    }

    @Override
    public Object openContext() {
        ZK.addListener(this);
        ZK.initServer(this.config);
        return main_th;
    }

    @Override
    public void closeContext(Object ctx) {
        this.waitData();
    }

    @Override
    public int updateUser(Object ctx, JSONObject user) {
        int len;
        String cracha = "";
        String[][] reg = new String[][]{{"Pin", "codigo", null}, {"Password", "senha", ""}, {"Group", null, "1"}, {"StartTime", null, "0"}, {"EndTime", null, "0"}, {"Name", "nome", null}, {"Privilege", null, "0"}};
        if (user.containsKey((Object)"cracha") && (len = (cracha = user.get((Object)"cracha").toString()).length()) > 5) {
            cracha = cracha.substring(len - 5);
        }
        String c = "UPDATE user CardNo=" + cracha;
        for (int i = 0; i < reg.length; ++i) {
            String val = reg[i][2];
            if (reg[i][1] != null && user.containsKey((Object)reg[i][1])) {
                val = user.get((Object)reg[i][1]).toString();
            }
            if (val == null) {
                return 130;
            }
            c = c + "\t" + reg[i][0] + "=" + val;
        }
        this.addCmd(c);
        if (!user.containsKey((Object)"codigo")) {
            return 0;
        }
        String pin = user.get((Object)"codigo").toString();
        this.addCmd("UPDATE userauthorize Pin=" + pin + "\tAuthorizeTimezoneId=1\tAuthorizeDoorId=1\tDevID=1");
        return 0;
    }

    @Override
    public int deleteUser(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return 130;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("DELETE user Pin=" + codigo);
        return 0;
    }

    @Override
    public int sendUserBio(Object ctx, JSONObject juser) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] c) {
                String cmd = "";
                String pin = (String)pars[0];
                for (String k : new String[]{"vendor", "template"}) {
                    if (jtemp.containsKey((Object)k)) continue;
                    return 0;
                }
                String vendor = jtemp.get((Object)"vendor").toString();
                String template = jtemp.get((Object)"template").toString();
                if (template.equals("")) {
                    return 0;
                }
                if (vendor.equals("zk_unified")) {
                    cmd = "UPDATE biodata Pin=" + pin;
                    cmd = cmd + "\tNo=0";
                    cmd = cmd + "\tIndex=0";
                    cmd = cmd + "\tValid=1";
                    cmd = cmd + "\tDuress=0";
                    cmd = cmd + "\tType=9";
                    cmd = cmd + "\tMajorVer=58";
                    cmd = cmd + "\tMinorVer=12";
                    cmd = cmd + "\tFormat=0";
                    cmd = cmd + "\tTmp=" + template;
                } else if (vendor.equals("jpg")) {
                    byte[] photo = Util.base642byte(template);
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])photo, (int)0, (int)photo.length, (BitmapFactory.Options)options);
                    int height = bitmap.getHeight();
                    int width = bitmap.getWidth();
                    while (height >= 1000 || width >= 1000) {
                        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)width * 0.5)), (int)((int)((double)height * 0.5)), (boolean)true);
                        height = bitmap.getHeight();
                        width = bitmap.getWidth();
                    }
                    ByteArrayOutputStream blob = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)blob);
                    photo = blob.toByteArray();
                    template = Util.byte2base64(photo);
                    cmd = "UPDATE biophoto PIN=" + pin;
                    cmd = cmd + "\tType=9";
                    cmd = cmd + "\tSize=" + template.length();
                    cmd = cmd + "\tContent=" + template;
                    cmd = cmd + "\tFormat=0";
                } else {
                    return 0;
                }
                ZK.this.addCmd(cmd);
                c[0] = c[0] + 1;
                return 0;
            }
        };
        if (!juser.containsKey((Object)"codigo")) {
            return 130;
        }
        if (!juser.containsKey((Object)"templates") || !(juser.get((Object)"templates") instanceof JSONArray)) {
            return 302;
        }
        String codigo = juser.get((Object)"codigo").toString();
        int[] count = new int[]{0};
        Util.jsonIter((JSONArray)juser.get((Object)"templates"), iter, new Object[]{codigo}, count);
        if (count[0] <= 0) {
            return 302;
        }
        return 0;
    }

    @Override
    public int deleteUserBio(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return 130;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("DELETE biodata Pin=" + codigo);
        return 0;
    }

    @Override
    public int getUserBio(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return 130;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("QUERY tablename=biodata,fielddesc=*,filter=Pin=" + codigo);
        return 0;
    }
}

