/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConnectDB;
import com.ifractal.utils.ConsumerDB;
import com.ifractal.utils.DB;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.SessionDB;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConnectJDBC
extends Producer
implements ConnectDB {
    public static final int SQLITE_CONSTRAINT = 19;
    protected final ConsumerDB consumer;
    protected final String dbname;
    protected final int version;

    public ConnectJDBC(String db, int ver, ConsumerDB cons, Observer obs) {
        super(obs);
        this.dbname = db;
        this.version = ver;
        this.consumer = cons;
        this.init();
    }

    public int getVersion() {
        String content = Util.getContent("version.txt");
        if (content == null) {
            return 0;
        }
        int ver = 0;
        try {
            ver = Integer.parseInt(content.trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return ver;
    }

    public void saveVersion() throws IOException {
        FileWriter fw = new FileWriter("version.txt");
        fw.write(Version.getRevision() + "\n");
        fw.close();
    }

    public boolean init() {
        int last = this.getVersion();
        String sql = null;
        String[] changes = null;
        if (!this.dbname.startsWith("jdbc:sqlite:")) {
            return true;
        }
        String[] file = this.dbname.split(":");
        File f = new File(file[2]);
        if (f.exists()) {
            if (last == 0) {
                this.sendMessage(3, "Vers\u00e3o n\u00e3o encontrada.");
                return true;
            }
            if (this.version == last) {
                this.sendMessage(4, "Sem novas atualiza\u00e7\u00f5es.");
                return true;
            }
            changes = this.consumer.getSQLChangeSchema(last);
        } else {
            sql = this.consumer.getSQLSchema();
        }
        if (sql == null && changes == null) {
            this.sendMessage(3, "Sem atualiza\u00e7\u00f5es.");
            return true;
        }
        try {
            Connection conn = DriverManager.getConnection(this.dbname);
            Statement stmt = conn.createStatement();
            if (sql != null) {
                stmt.executeUpdate(sql);
            }
            if (changes != null) {
                for (String ch : changes) {
                    stmt.executeUpdate(ch);
                }
            }
            stmt.close();
            conn.close();
            this.saveVersion();
        }
        catch (SQLException se) {
            this.sendMessage(1, se.getMessage());
            return false;
        }
        catch (IOException ioe) {
            this.sendMessage(1, ioe.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public SessionDB getNewSession(ConsumerDB consumer, Observer obs) {
        SessionJDBC sess = new SessionJDBC(consumer, this, obs);
        return sess;
    }

    private class SessionJDBC
    extends SessionDB {
        ConsumerDB cons;
        Connection conn;
        String[] stmtkeys;
        PreparedStatement[] pstmts;

        public SessionJDBC(ConsumerDB consumer, ConnectJDBC c, Observer obs) {
            super(obs);
            this.cons = null;
            this.conn = null;
            this.stmtkeys = null;
            this.pstmts = null;
            this.cons = consumer;
        }

        @Override
        public boolean open() {
            try {
                this.conn = DriverManager.getConnection(ConnectJDBC.this.dbname);
                String[] stmts = this.cons.getStatements();
                if (stmts == null) {
                    return true;
                }
                this.pstmts = new PreparedStatement[stmts.length / 2];
                this.stmtkeys = new String[this.pstmts.length];
                int i = 0;
                int k = 0;
                while (i + 1 < stmts.length) {
                    this.stmtkeys[k] = stmts[i + 0];
                    this.pstmts[k] = this.conn.prepareStatement(stmts[i + 1]);
                    i += 2;
                    ++k;
                }
            }
            catch (SQLException se) {
                this.sendMessage(1, se.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            try {
                if (this.conn == null) {
                    return;
                }
                if (this.pstmts != null) {
                    for (PreparedStatement ps : this.pstmts) {
                        ps.close();
                    }
                }
                this.conn.close();
            }
            catch (SQLException se) {
                this.sendMessage(1, se.getMessage());
            }
        }

        @Override
        public synchronized JSONArray execute(String stmtKey, String[] fields, String iStmtKey, String[] iFields) {
            int error = 0;
            JSONArray res = new JSONArray();
            JSONObject ret = new JSONObject();
            if (!this.open()) {
                return res;
            }
            if (stmtKey.startsWith("Select")) {
                res = this.executeQuery(stmtKey, fields);
                this.close();
                return res;
            }
            if (iStmtKey != null && iFields != null) {
                error = this.executeUpsert(stmtKey, iStmtKey, fields, iFields);
            } else if (stmtKey.startsWith("Update") || stmtKey.startsWith("Insert") || stmtKey.startsWith("Delete")) {
                error = this.executeUpdate(stmtKey, fields);
            }
            ret.put((Object)"error", (Object)error);
            res.add((Object)ret);
            this.close();
            return res;
        }

        @Override
        public int executeUpsert(String uStmtKey, String iStmtKey, String[] uFields, String[] iFields) {
            boolean update = false;
            PreparedStatement uPs = this.getStatement(uStmtKey);
            if (uPs == null) {
                return -1;
            }
            try {
                update = DB.executeUpdate(this, uPs, uFields);
                if (update) {
                    return 0;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 19) {
                    return 0;
                }
                this.sendMessage(5, e.getMessage());
                String msg = uStmtKey + "\n";
                for (String s : uFields) {
                    msg = msg + s + "|";
                }
                this.sendMessage(5, msg);
            }
            return this.executeUpdate(iStmtKey, iFields);
        }

        @Override
        public int executeUpdate(String stmtKey, String[] fields) {
            PreparedStatement ps = this.getStatement(stmtKey);
            if (ps == null) {
                return -1;
            }
            try {
                boolean ret = DB.executeUpdate(this, ps, fields);
                if (ret) {
                    return 0;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 19) {
                    this.sendMessage(5, e.getMessage());
                    return 0;
                }
                this.sendMessage(2, e.getMessage());
                String msg = stmtKey + "\n";
                if (fields != null) {
                    for (String s : fields) {
                        msg = msg + s + "|";
                    }
                }
                this.sendMessage(2, msg);
                return e.getErrorCode();
            }
            return -1;
        }

        @Override
        public JSONArray executeQuery(String stmtKey, String[] fields) {
            PreparedStatement ps = this.getStatement(stmtKey);
            if (ps == null) {
                return null;
            }
            JSONArray res = DB.executeQuery(this, ps, fields);
            return res;
        }

        private PreparedStatement getStatement(String key) {
            for (int i = 0; i < this.stmtkeys.length; ++i) {
                if (!this.stmtkeys[i].equals(key)) continue;
                return this.pstmts[i];
            }
            return null;
        }
    }
}

