/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.ifponto.Version;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import org.json.simple.JSONObject;

public abstract class TunnelPeer<T>
extends Producer
implements Runnable {
    public int mod = 0;
    protected T context;
    protected TunnelServer<T> server;
    protected JSONObject info = null;
    protected String id = null;
    protected String chave = null;
    protected TunnelPeer<T> siin = null;
    private long start = 0L;

    public abstract String getIP();

    public abstract int send(String[] var1);

    public abstract void close();

    public TunnelPeer(T ctx, TunnelServer<T> s, Observer obs) {
        super(obs);
        this.context = ctx;
        this.server = s;
        this.refresh();
    }

    public void refresh() {
        this.start = System.currentTimeMillis();
    }

    public long getLifetime() {
        return (System.currentTimeMillis() - this.start) / 1000L;
    }

    public void setSIIN(TunnelPeer<T> s) {
        this.siin = s;
    }

    public void resetContext(T ctx) {
        this.context = ctx;
    }

    public boolean setInfo(JSONObject ji) {
        String[] keys;
        if (ji == null) {
            return false;
        }
        for (String k : keys = new String[]{"modulo", "info", "CHAVE"}) {
            if (ji.containsKey((Object)k)) continue;
            return false;
        }
        JSONObject i = (JSONObject)ji.get((Object)"info");
        if (i == null || !i.containsKey((Object)"id")) {
            return false;
        }
        this.id = i.get((Object)"id").toString();
        this.chave = ji.get((Object)"CHAVE").toString();
        String modulo = ji.get((Object)"modulo").toString();
        if (modulo.equals("SIIN")) {
            this.mod = 1;
        } else if (modulo.equals("Observer")) {
            this.mod = 2;
        }
        this.info = ji;
        return true;
    }

    public JSONObject getInfo() {
        return this.info;
    }

    protected int sendInfo(String[] args, String modulo) {
        JSONObject jdata = new JSONObject();
        JSONObject jinfo = Util.getInfo(androidContext);
        if (args != null) {
            int i = 0;
            while (i + 1 < args.length) {
                jdata.put((Object)args[i], (Object)args[i + 1]);
                i += 2;
            }
        }
        jdata.put((Object)"versao", (Object)Version.getFormatedText());
        jdata.put((Object)"info", (Object)jinfo);
        jdata.put((Object)"modulo", (Object)modulo);
        this.info = jdata;
        int r = this.send(new String[]{"peer", jdata.toString()});
        return r;
    }

    public int sendInfo(JSONObject jinfo) {
        String[] pack = new String[]{"peer", jinfo.toString()};
        int r = this.send(pack);
        return r;
    }

    public int sendObserverInfo(String[] args) {
        return this.sendInfo(args, "Observer");
    }

    public int sendServiceInfo(String[] args) {
        return this.sendInfo(args, "SIIN");
    }
}

