/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.PushDevice;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.HttpServer;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ZK
extends PushDevice<Object> {
    protected static String ForeignOrigin = "98";
    protected Queue<String[]> eventsQueue = new LinkedList<String[]>();
    protected Queue<String[]> usersQueue = new LinkedList<String[]>();
    protected Queue<String[]> bioQueue = new LinkedList<String[]>();
    protected String[] info = null;

    public static int encodeZKTime(String in) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            Date dt = f.parse(in);
            return ZK.encodeZKTime(dt);
        }
        catch (ParseException pe) {
            return 0;
        }
    }

    public static int encodeZKTime(Date in) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        return ZK.encodeZKTime(cal);
    }

    public static int encodeZKTime(Calendar in) {
        int year = in.get(1);
        int mon = in.get(2) + 1;
        int day = in.get(5);
        int hour = in.get(11);
        int min = in.get(12);
        int sec = in.get(13);
        int tt = ((year - 2000) * 12 * 31 + (mon - 1) * 31 + day - 1) * 86400 + (hour * 60 + min) * 60 + sec;
        return tt;
    }

    public static Date decodeZKTime(int zktime) {
        int sec = zktime % 60;
        int min = (zktime /= 60) % 60;
        int hour = (zktime /= 60) % 24;
        int day = (zktime /= 24) % 31 + 1;
        int mon = (zktime /= 31) % 12;
        int year = (zktime /= 12) + 2000;
        Calendar dt = Calendar.getInstance();
        dt.set(year, mon, day, hour, min, sec);
        return dt.getTime();
    }

    protected static String[] getFromTo(String tablename) {
        String[] r = new String[]{""};
        if (tablename.equals("user")) {
            r = new String[]{"name", "nome", "pin", "codigo", "cardno", "cracha"};
        }
        return r;
    }

    protected static void fromTo(String[][] table, String tablename) {
        String[] FromTo = ZK.getFromTo(tablename);
        for (String[] line : table) {
            int k = 0;
            while (k + 1 < line.length) {
                int j = 0;
                while (j + 1 < FromTo.length) {
                    if (line[k].equals(FromTo[j])) {
                        line[k] = FromTo[j + 1];
                        break;
                    }
                    j += 2;
                }
                k += 2;
            }
        }
    }

    private byte[] response(String[] headers, String type, String path, String[] GET, String data) {
        String[] cookies = HttpServer.getCookies(headers);
        String content = "OK";
        int sess = -1;
        String token = Util.getValueFromArgs(cookies, "token");
        if (token != null && token.length() > 5) {
            this.session = sess = System.identityHashCode(token);
        }
        if (!path.equals("/iclock/cdata")) {
            if (path.equals("/iclock/querydata")) {
                if (data.contains("FirmVer")) {
                    this.info = HttpServer.splitParameters(data, ",", "=");
                }
                String[][] table = HttpServer.splitTable(data, "\t", "=");
                String tablename = Util.getValueFromArgs(GET, "tablename");
                ZK.fromTo(table, tablename);
                if (data.length() >= 4) {
                    if (tablename.equals("user")) {
                        for (String[] e : table) {
                            this.usersQueue.add(e);
                        }
                    } else if (tablename.equals("transaction")) {
                        for (String[] e : table) {
                            if (this.eventsQueue.size() <= 100) {
                                this.eventsQueue.add(e);
                                continue;
                            }
                            break;
                        }
                    } else if (tablename.equals("biodata")) {
                        for (String[] e : table) {
                            if (e == null) continue;
                            this.bioQueue.add(e);
                        }
                    }
                }
                this.packcnt = Util.getIntFromArgs(GET, "packcnt");
                this.packidx = Util.getIntFromArgs(GET, "packidx");
                this.last = new Date().getTime();
            } else if (path.equals("/iclock/registry")) {
                if (this.session == 0) {
                    this.info = HttpServer.splitParameters(data, ",", "=");
                    this.session = sess = System.identityHashCode(this);
                    content = "RegistryCode=" + sess;
                } else {
                    sess = this.session;
                    content = "registry=OK\r\n";
                }
            } else if (path.equals("/iclock/getrequest")) {
                if (!this.cmdQueue.isEmpty()) {
                    content = (String)this.cmdQueue.remove();
                }
            } else if (path.equals("/iclock/push")) {
                sess = this.session;
                content = "registry=OK\r\n";
                content = content + "ServerVersion=" + Version.getText() + "\r\n";
                content = content + "ServerName=iFractal\r\n";
                content = content + "Realtime=0\r\n";
                content = content + "SessionID=" + sess + "\r\n";
                content = content + "PushProtoVer=3.1.2\r\n";
                content = content + "PushOptionsFlags=0\r\n";
            } else if (!path.equals("/iclock/ping") && path.equals("/iclock/devicecmd")) {
                String[] fields = HttpServer.splitParameters(data, "&", "=");
                int id = Util.getIntFromArgs(fields, "ID");
                Integer e = null;
                for (Integer i : this.confirmList) {
                    if (i != id) continue;
                    e = i;
                    break;
                }
                if (e != null) {
                    this.confirmList.remove(e);
                }
                this.last = new Date().getTime();
            }
        }
        if (this.session > 0) {
            sess = this.session;
        }
        if (sess < 0) {
            return this.makeResponse(null);
        }
        return this.makeResponse(content);
    }

    @Override
    public boolean checkDevice(String ip, String[] dataIn) {
        return this.checkDevice(ip, dataIn, "SN");
    }

    @Override
    public byte[] handler(String[] headers, String type, String path, String[] GET, String data) {
        byte[] out = null;
        if (type.equals("POST") && !headers[headers.length - 1].startsWith("Content-Length")) {
            data = headers[headers.length - 1];
        }
        out = this.response(headers, type, path, GET, data);
        return out;
    }

    public ZK(JSONObject c) {
        super(c);
    }

    protected int addCmd(String query) {
        int id = this.cmdid++;
        String cmd = query.startsWith("ACCOUNT") || query.startsWith("GET") ? "C:" + id + ":" + query : "C:" + id + ":DATA " + query;
        this.cmdQueue.add(cmd);
        this.confirmList.add(id);
        return id;
    }

    @Override
    public Date getTime() {
        HttpServer.addDevice(this);
        this.addCmd("GET OPTIONS ~SerialNumber,FirmVer,~DeviceName,LockCount,ReaderCount,AuxInCount,AuxOutCount,MachineType,~IsOnlyRFMachine,~MaxUserCount,~MaxAttLogCount,~MaxFingerCount,~MaxUserFingerCount,MThreshold,NetMask,GATEIPAddress,~ZKFPVersion,SimpleEventType,VerifyStyles,EventTypes,ComPwd");
        this.waitData();
        if (this.session == 0) {
            return null;
        }
        return new Date();
    }

    @Override
    public boolean setTime(int diff) {
        return this.session != 0;
    }

    @Override
    public void getInfo(JSONObject c) {
        HttpServer.addDevice(this);
        this.addCmd("GET OPTIONS ~SerialNumber,FirmVer,~DeviceName,LockCount,ReaderCount,AuxInCount,AuxOutCount,MachineType,~IsOnlyRFMachine,~MaxUserCount,~MaxAttLogCount,~MaxFingerCount,~MaxUserFingerCount,MThreshold,NetMask,GATEIPAddress,~ZKFPVersion,SimpleEventType,VerifyStyles,EventTypes,ComPwd");
        this.waitData();
        if (this.session == 0 || this.info == null) {
            return;
        }
        int k = 0;
        while (k + 1 < this.info.length) {
            c.put((Object)this.info[k], (Object)this.info[k + 1]);
            k += 2;
        }
    }

    @Override
    public JSONArray getUsers() {
        HttpServer.addDevice(this);
        this.addCmd("QUERY tablename=user,fielddesc=*,filter=*");
        this.waitData();
        JSONArray arr = new JSONArray();
        while (!this.usersQueue.isEmpty()) {
            String[] line = this.usersQueue.remove();
            JSONObject e = new JSONObject();
            arr.add((Object)e);
            int k = 0;
            while (k + 1 < line.length) {
                e.put((Object)line[k], (Object)line[k + 1]);
                k += 2;
            }
        }
        return arr;
    }

    @Override
    public int getEvents(JSONArray offs) {
        int nsr = 0;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HttpServer.addDevice(this);
        this.addCmd("ACCOUNT transaction MaxIndex=" + (this.getNsr() - 1));
        this.waitData();
        if (this.session <= 0) {
            return -1;
        }
        String[] fromTo = new String[]{"pin", "codigo", "index", "nsr", "cardno", null, "maskflag", null, "inoutstate", null, "verified", null, "temperature", null, "eventtype", null, "doorid", null};
        while (!this.eventsQueue.isEmpty()) {
            JSONObject reg = new JSONObject();
            String[] e = this.eventsQueue.remove();
            int k = 0;
            while (k + 1 < e.length) {
                String key = e[k];
                String val = e[k + 1];
                if (e[k].equals("eventtype")) {
                    key = "auth";
                    int type = Integer.parseInt(val);
                    val = type >= 0 && type <= 19 || type >= 200 && type <= 253 ? "L" : "B";
                } else if (e[k].equals("time_second")) {
                    int ts = Integer.parseInt(e[k + 1]);
                    Date dt = ZK.decodeZKTime(ts);
                    key = "datahora";
                    val = fmt.format(dt);
                } else if (e[k].equals("index")) {
                    key = "nsr";
                    nsr = Integer.parseInt(val);
                } else {
                    int j = 0;
                    while (j + 1 < fromTo.length) {
                        if (key.equals(fromTo[j])) {
                            if (fromTo[j + 1] == null) {
                                key = null;
                                break;
                            }
                            key = fromTo[j + 1];
                            break;
                        }
                        j += 2;
                    }
                }
                if (key != null && key.equals("codigo") && val.equals("0")) break;
                if (key != null) {
                    reg.put((Object)key, (Object)val);
                }
                k += 2;
            }
            if (reg.isEmpty()) continue;
            offs.add((Object)reg);
        }
        return nsr;
    }

    @Override
    public int getBio(JSONArray jusers) {
        super.getBio(jusers);
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject juser, Object[] pars, int[] c) {
                if (!juser.containsKey((Object)"codigo")) {
                    return 0;
                }
                String[][] tmps = (String[][])pars[0];
                String codigo = juser.get((Object)"codigo").toString();
                JSONArray templates = null;
                if (juser.containsKey((Object)"templates")) {
                    templates = (JSONArray)juser.get((Object)"templates");
                } else {
                    templates = new JSONArray();
                    juser.put((Object)"templates", (Object)templates);
                }
                for (String[] e : tmps) {
                    String tmp;
                    String pin = Util.getValueFromArgs(e, "pin");
                    if (!pin.equals(codigo) || (tmp = Util.getValueFromArgs(e, "tmp")).length() < 2) continue;
                    JSONObject obj = new JSONObject();
                    templates.add((Object)obj);
                    obj.put((Object)"vendor", (Object)"zk_unified");
                    obj.put((Object)"encode", (Object)"b64");
                    obj.put((Object)"template", (Object)tmp);
                }
                return 0;
            }
        };
        int i = 0;
        int qty = this.bioQueue.size();
        String[][] temps = new String[qty][];
        while (!this.bioQueue.isEmpty()) {
            temps[i++] = this.bioQueue.remove();
        }
        Util.jsonIter(jusers, iter2, new Object[]{temps}, null);
        return 0;
    }

    @Override
    public Object openContext() {
        HttpServer.addDevice(this);
        Thread main_th = HttpServer.initServer(this.config);
        return main_th;
    }

    @Override
    public void closeContext(Object ctx) {
        this.waitData();
    }

    @Override
    public int updateUser(Object ctx, JSONObject user) {
        int len;
        String cracha = "";
        String[][] reg = new String[][]{{"Pin", "codigo", null}, {"Password", "senha", ""}, {"Group", null, "1"}, {"StartTime", null, "0"}, {"EndTime", null, "0"}, {"Name", "nome", null}, {"Privilege", null, "0"}};
        if (user.containsKey((Object)"cracha") && (len = (cracha = user.get((Object)"cracha").toString()).length()) > 5) {
            cracha = cracha.substring(len - 5);
        }
        String c = "UPDATE user CardNo=" + cracha;
        for (int i = 0; i < reg.length; ++i) {
            String val = reg[i][2];
            if (reg[i][1] != null && user.containsKey((Object)reg[i][1])) {
                val = user.get((Object)reg[i][1]).toString();
            }
            if (val == null) {
                return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
            }
            c = c + "\t" + reg[i][0] + "=" + val;
        }
        this.addCmd(c);
        if (!user.containsKey((Object)"codigo")) {
            return 0;
        }
        String pin = user.get((Object)"codigo").toString();
        this.addCmd("UPDATE userauthorize Pin=" + pin + "\tAuthorizeTimezoneId=1\tAuthorizeDoorId=1\tDevID=1");
        return 0;
    }

    @Override
    public int deleteUser(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("DELETE user Pin=" + codigo);
        return 0;
    }

    @Override
    public int sendUserBio(Object ctx, JSONObject juser) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemp, Object[] pars, int[] c) {
                String cmd = "";
                String pin = (String)pars[0];
                for (String k : new String[]{"vendor", "template"}) {
                    if (jtemp.containsKey((Object)k)) continue;
                    return 0;
                }
                String vendor = jtemp.get((Object)"vendor").toString();
                String template = jtemp.get((Object)"template").toString();
                if (template.equals("")) {
                    return 0;
                }
                if (vendor.equals("zk_unified")) {
                    cmd = "UPDATE biodata Pin=" + pin;
                    cmd = cmd + "\tNo=0";
                    cmd = cmd + "\tIndex=0";
                    cmd = cmd + "\tValid=1";
                    cmd = cmd + "\tDuress=0";
                    cmd = cmd + "\tType=9";
                    cmd = cmd + "\tMajorVer=58";
                    cmd = cmd + "\tMinorVer=12";
                    cmd = cmd + "\tFormat=0";
                    cmd = cmd + "\tTmp=" + template;
                } else if (vendor.equals("jpg")) {
                    template = Device.resizePhotoTemplate(template);
                    cmd = "UPDATE biophoto PIN=" + pin;
                    cmd = cmd + "\tType=9";
                    cmd = cmd + "\tSize=" + template.length();
                    cmd = cmd + "\tContent=" + template;
                    cmd = cmd + "\tFormat=0";
                } else {
                    return 0;
                }
                ZK.this.addCmd(cmd);
                c[0] = c[0] + 1;
                return 0;
            }
        };
        if (!juser.containsKey((Object)"codigo")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        if (!juser.containsKey((Object)"templates") || !(juser.get((Object)"templates") instanceof JSONArray)) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        String codigo = juser.get((Object)"codigo").toString();
        int[] count = new int[]{0};
        Util.jsonIter((JSONArray)juser.get((Object)"templates"), iter2, new Object[]{codigo}, count);
        if (count[0] <= 0) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        return 0;
    }

    @Override
    public int deleteUserBio(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("DELETE biodata Pin=" + codigo);
        return 0;
    }

    @Override
    public int getUserBio(Object ctx, JSONObject user) {
        if (!user.containsKey((Object)"codigo")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        String codigo = user.get((Object)"codigo").toString();
        this.addCmd("QUERY tablename=biodata,fielddesc=*,filter=Pin=" + codigo);
        return 0;
    }
}

