/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.IDClass;
import com.ifractal.ifponto.IfpontoDBAcesso;
import com.ifractal.ifponto.PushDevice;
import com.ifractal.utils.Util;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class ControlID
extends PushDevice<IfpontoDBAcesso> {
    protected String session = null;
    protected long last_session = 0L;

    public static long convertRFID_nominal2code(String nominal) {
        long code = 0L;
        try {
            long in = Long.parseLong(nominal);
            int len = nominal.length();
            if (len <= 5) {
                return in;
            }
            long suffix = Long.parseLong(nominal.substring(len - 5));
            long prefix = Long.parseLong(nominal.substring(0, len - 5));
            code = suffix + 0x100000000L * prefix;
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        return code;
    }

    public static String convertRFID_code2nominal(long code) {
        long prefix = code >> 32;
        long suffix = code & 0xFFFFL;
        return "" + prefix + suffix;
    }

    public ControlID(JSONObject config) {
        super(config);
    }

    public ControlID(IfpontoDBAcesso db, JSONObject config) {
        super(db, config);
    }

    protected URL getURL(String ip, String port, String path, String query) throws IOException {
        String proto = "http://";
        if (port.equals("80")) {
            proto = "http://";
        } else if (port.equals("443")) {
            proto = "https://";
        } else if (this instanceof IDClass) {
            proto = "https://";
        }
        String url = proto + ip + ":" + port + "/" + path + "?" + query;
        return new URL(url);
    }

    public void login() throws IOException, ClassCastException {
        JSONArray res;
        URL url;
        JSONObject json = new JSONObject();
        String login = "admin";
        String pass = "admin";
        long now = new Date().getTime();
        if (this.session != null && now - this.last_session < 300000L) {
            url = this.getURL(this.ip, this.port, "session_is_valid.fcgi", "");
            res = Util.sendJsonPost(this, url, "{}");
            if (res == null) {
                return;
            }
            boolean isValid = (Boolean)((JSONObject)res.get(0)).get((Object)"session_is_valid");
            if (isValid) {
                return;
            }
        }
        if (this.config.containsKey((Object)"user") && this.config.containsKey((Object)"pass") && !this.config.get((Object)"user").equals("") && !this.config.get((Object)"pass").equals("")) {
            login = this.config.get((Object)"user").toString();
            pass = this.config.get((Object)"pass").toString();
        }
        json.put((Object)"login", (Object)login);
        json.put((Object)"password", (Object)pass);
        url = this.getURL(this.ip, this.port, "login.fcgi", "");
        res = Util.sendJsonPost(this, url, json.toJSONString());
        if (res == null) {
            return;
        }
        this.session = (String)((JSONObject)res.get(0)).get((Object)"session");
        this.last_session = new Date().getTime();
    }

    protected JSONArray exec(String path, String json) {
        JSONArray res;
        try {
            URL url;
            this.login();
            if (json == null) {
                json = "{}";
            }
            String query = "session=" + this.session;
            if (this.modelo.indexOf("671") > 0) {
                query = "session=" + this.session + "&mode=671";
            }
            if ((res = Util.sendJsonPost(this, url = this.getURL(this.ip, this.port, path, query), json)) == null && this.modelo.indexOf("671") > 0) {
                res = new JSONArray();
                res.add((Object)new JSONObject());
            }
        }
        catch (IOException ioe) {
            this.verboseWARN(ioe.getMessage());
            return null;
        }
        catch (ClassCastException cce) {
            this.verboseWARN(cce.getMessage());
            return null;
        }
        return res;
    }

    protected JSONArray execList(String path, String json) {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.session = null;
        return this.exec(path, json);
    }

    @Override
    public Object openContext() {
        this.session = "";
        return new Object[]{this.session, 0L, null};
    }

    @Override
    public void closeContext(Object ctx) {
    }

    @Override
    public Date getTime() {
        return this.getTime("get_system_date_time.fcgi");
    }

    public Date getTime(String uri) {
        JSONArray res = this.exec(uri, null);
        Calendar c = Calendar.getInstance();
        if (res == null) {
            return null;
        }
        try {
            JSONObject timestamp = (JSONObject)res.get(0);
            if (!timestamp.isEmpty()) {
                c.set(1, (int)((Long)timestamp.get((Object)"year")).longValue());
                c.set(2, (int)((Long)timestamp.get((Object)"month")).longValue() - 1);
                c.set(5, (int)((Long)timestamp.get((Object)"day")).longValue());
                c.set(11, (int)((Long)timestamp.get((Object)"hour")).longValue());
                c.set(12, (int)((Long)timestamp.get((Object)"minute")).longValue());
                c.set(13, (int)((Long)timestamp.get((Object)"second")).longValue());
                c.set(14, 0);
            }
        }
        catch (NumberFormatException nfe) {
            this.verboseWARN(nfe.getMessage());
            return null;
        }
        return c.getTime();
    }

    @Override
    public boolean setTime(int timediff) {
        return this.setTime("set_system_date_time.fcgi", timediff);
    }

    protected JSONObject getSetTimeRequest(int timediff) {
        JSONObject json = new JSONObject();
        Calendar now = Calendar.getInstance();
        now.add(10, timediff);
        json.put((Object)"day", (Object)now.get(5));
        json.put((Object)"month", (Object)(now.get(2) + 1));
        json.put((Object)"year", (Object)now.get(1));
        json.put((Object)"hour", (Object)now.get(11));
        json.put((Object)"minute", (Object)now.get(12));
        json.put((Object)"second", (Object)now.get(13));
        return json;
    }

    public boolean setTime(String Uri, int timediff) {
        JSONObject json = this.getSetTimeRequest(timediff);
        this.exec(Uri, json.toJSONString());
        return true;
    }

    @Override
    public void getInfo(JSONObject config) {
        this.getInfo("get_about.fcgi", config);
    }

    public void getInfo(String uri, JSONObject config) {
        JSONArray arr = this.exec(uri, null);
        if (arr == null) {
            this.verboseDEBUG("arr is null");
            return;
        }
        JSONObject obj = (JSONObject)arr.get(0);
        for (Object key : obj.keySet()) {
            config.put(key, obj.get(key));
        }
    }

    @Override
    protected int getEndIterDelay() {
        return -1;
    }
}

