/*
 * Decompiled with CFR 0.152.
 */
package com.cogent;

import com.cogentsystems.jna.cls.fp.capture.LiveScanDirect;
import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;

public class Cogent<T>
extends Scanner<T> {
    double dpi = 500.0;
    protected static int CAPTURE_TYPE_FLAT = 5;
    protected static int PLAIN_RIGHT_THUMB = 11;
    protected static int RIGHT_THUMB = 1;
    protected static int IMPRESSION_TYPE_PLAIN = 0;
    protected static int IMG_TYPE_IMG = 0;

    public Cogent(long[] ctx, String[] params, ScannerListener<T> sl) {
        super(ctx, params, sl);
    }

    @Override
    public int init(int index) {
        super.init(index);
        int ret = LiveScanDirect.CLS_Initialize();
        if (ret != 0) {
            return 500;
        }
        ret = LiveScanDirect.CLS_SetTransNo((String)"Registro01");
        return ret;
    }

    @Override
    public int terminate() {
        LiveScanDirect.CLS_Clear();
        LiveScanDirect.CLS_Terminate();
        return 0;
    }

    public long init(String[] params) {
        try {
            System.loadLibrary("CLSFPCaptureDLL");
        }
        catch (UnsatisfiedLinkError e) {
            this.sendMessage(2, "Load Library Error: Native code library failed to load. See the chapter on Dynamic Linking Problems in the SWIG Java documentation for help.\nError: " + e.getMessage());
            return 1500L;
        }
        return 0L;
    }

    public long finalize(String[] params) {
        return 0L;
    }

    @Override
    public String[] getInfo() {
        int width = 500;
        int height = 750;
        String[] info = new String[]{"width", "" + width, "height", "" + height, "vendor", "cogent"};
        return info;
    }

    @Override
    public int deleteBio(String id) {
        return 0;
    }

    @Override
    public int deleteAll() {
        return 0;
    }

    @Override
    public int captureImage(int qty_samples, T user_data) {
        int ret = 0;
        IntByReference width = new IntByReference();
        IntByReference height = new IntByReference();
        IntByReference quality = new IntByReference();
        PointerByReference bufferReference = new PointerByReference();
        IntByReference bufferLength = new IntByReference();
        ret = this.init();
        if (ret != 0) {
            return -2;
        }
        ret = LiveScanDirect.CLS_CaptureFP((int)CAPTURE_TYPE_FLAT, (int)PLAIN_RIGHT_THUMB);
        if (ret != 0) {
            this.terminate();
            return -3;
        }
        ret = LiveScanDirect.CLS_GetImageSize((int)RIGHT_THUMB, (IntByReference)width, (IntByReference)height, (int)IMPRESSION_TYPE_PLAIN);
        if (ret != 0) {
            this.terminate();
            return -3;
        }
        this.width = width.getValue();
        this.height = height.getValue();
        ret = LiveScanDirect.CLS_GetImageQuality((int)RIGHT_THUMB, (IntByReference)quality, (int)IMPRESSION_TYPE_PLAIN);
        this.quality = quality.getValue();
        if (ret != 0) {
            this.quality = 10;
        }
        if ((ret = LiveScanDirect.CLS_GetImage((int)IMPRESSION_TYPE_PLAIN, (int)RIGHT_THUMB, (int)IMG_TYPE_IMG, (PointerByReference)bufferReference, (IntByReference)bufferLength)) != 0) {
            this.terminate();
            return -2;
        }
        Pointer bufferPointer = bufferReference.getValue();
        ByteBuffer buffer = ByteBuffer.wrap(bufferPointer.getByteArray(32L, bufferLength.getValue() - 32));
        buffer.limit(bufferLength.getValue() - 32);
        buffer.rewind();
        byte[] tmp = buffer.array();
        this.img = new byte[tmp.length];
        System.arraycopy(tmp, 0, this.img, 0, tmp.length);
        LiveScanDirect.CLS_FreeBuffer((Pointer)bufferPointer);
        this.terminate();
        return 0;
    }

    public long getWidth(String[] params) {
        return this.width;
    }

    public long getHeight(String[] params) {
        return this.height;
    }

    public long getQuality(String[] params) {
        return this.quality;
    }

    @Override
    public int enroll(int qty_samples, String id, byte[] quality, T user_data) {
        return -1;
    }

    @Override
    public String identify(int[] finger, int[] score, T user_data) {
        return null;
    }

    @Override
    public int verify(byte[] template, T user_data) {
        return 0;
    }
}

