/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BatchRequest
extends Verbosity {
    public static final int QUEUE_MAX_SIZE = 200;
    public static final int QUEUE_TIMEOUT = 300;
    public static HashMap<String, BatchRequest> listQueue = null;
    public static HashMap<String, Long> offlineList = null;
    public String filename = "";
    public JSONArray json = null;
    public String nro = "";
    public long start = 0L;
    public State state = State.WAITING;

    public BatchRequest(String ff, JSONArray j) {
        this.filename = ff;
        this.json = j;
        this.nro = BatchRequest.getNro(ff);
        this.start = new Date().getTime() / 1000L;
        if (listQueue == null) {
            listQueue = new HashMap();
        }
        if (offlineList == null) {
            offlineList = new HashMap();
        }
    }

    private static String getNro(String ff) {
        File f = new File(ff);
        String[] tk = f.getName().split("_", 5);
        return tk[1];
    }

    private static synchronized int insertOffline(String nro) {
        long now = new Date().getTime() / 1000L;
        if (offlineList == null) {
            offlineList = new HashMap();
        }
        offlineList.put(nro, new Long(now));
        return offlineList.size();
    }

    private static synchronized boolean checkOffline(String nro) {
        long now = new Date().getTime() / 1000L;
        if (offlineList == null) {
            return false;
        }
        for (Map.Entry<String, Long> e : offlineList.entrySet()) {
            long start = e.getValue();
            if (!e.getKey().equals(nro)) continue;
            long diff = now - start;
            return diff <= 300L;
        }
        return false;
    }

    public static synchronized int clean(String nro) {
        BatchRequest br = null;
        int n = 0;
        if (listQueue == null) {
            return 0;
        }
        BatchRequest.insertOffline(nro);
        for (Map.Entry<String, BatchRequest> bat : listQueue.entrySet()) {
            br = bat.getValue();
            if (!br.nro.equals(nro)) continue;
            br.start = 0L;
            ++n;
        }
        return n;
    }

    public static synchronized int clean() {
        long now = new Date().getTime() / 1000L;
        BatchRequest br = null;
        int i = 0;
        int k = 0;
        if (listQueue == null) {
            return 0;
        }
        String[] keys = new String[listQueue.size()];
        for (Map.Entry<String, BatchRequest> bat : listQueue.entrySet()) {
            br = bat.getValue();
            if (br.state == State.DONE) {
                String key = bat.getKey();
                br.verboseINFO(key + " processado.");
                File f = new File(key);
                if (f.delete()) {
                    br.verboseINFO(key + " removido.");
                } else {
                    br.verboseERROR("Falha ao tentar remover: " + key);
                }
                keys[k++] = key;
                continue;
            }
            if (br.state == State.FAIL) {
                keys[k++] = bat.getKey();
                br.verboseERROR("Falha ao tentar processar: '" + keys[k - 1] + "'.");
                continue;
            }
            if (now - br.start <= 300L) continue;
            keys[k++] = bat.getKey();
            br.verboseWARN("Timeout: '" + keys[k - 1] + "'. diff: " + (now - br.start));
        }
        for (i = 0; i < k; ++i) {
            listQueue.remove(keys[i]);
        }
        if (k > 0) {
            Verbosity.println("BatchRequest| Arquivos em espera: " + listQueue.size());
        }
        return listQueue.size();
    }

    private static synchronized BatchRequest getByFilename(String filename) {
        if (listQueue == null) {
            return null;
        }
        for (Map.Entry<String, BatchRequest> e : listQueue.entrySet()) {
            if (!e.getKey().equals(filename)) continue;
            return e.getValue();
        }
        return null;
    }

    private static void addCracha(JSONObject user) {
        JSONArray nro_cartao = (JSONArray)user.get((Object)"nro_cartao");
        String nro = "0";
        for (JSONObject cartao : nro_cartao) {
            if (cartao.containsKey((Object)"ativo") && cartao.get((Object)"ativo").toString().equals("0") || !cartao.containsKey((Object)"nro")) continue;
            nro = cartao.get((Object)"nro").toString();
            break;
        }
        user.put((Object)"cracha", (Object)nro);
    }

    public static void cleanASCII(JSONArray jlist) {
        IfaceJSONIter callback = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject reg, Object[] params, int[] count) {
                if (reg.containsKey((Object)"nome") && reg.get((Object)"nome") != null) {
                    String nome = reg.get((Object)"nome").toString();
                    reg.put((Object)"nome", (Object)nome.replaceAll("([^\\p{ASCII}]|\t|(  ))", ""));
                } else {
                    reg.put((Object)"nome", (Object)"");
                }
                if (reg.containsKey((Object)"nro_cartao")) {
                    BatchRequest.addCracha(reg);
                }
                return 0;
            }
        };
        Util.jsonIter(jlist, callback, null, null);
    }

    public static synchronized BatchRequest put(Verbosity verb, String filename) {
        BatchRequest br = BatchRequest.getByFilename(filename);
        if (br != null) {
            return br;
        }
        if (listQueue != null && listQueue.size() > 200) {
            BatchRequest.clean();
            return null;
        }
        if (BatchRequest.checkOffline(BatchRequest.getNro(filename))) {
            verb.verboseWARN("Ignora '" + filename + "' - Equipamento OFFLINE.");
            return null;
        }
        JSONArray json = Util.loadJSONArrayFile(verb, filename);
        if (json == null) {
            return null;
        }
        verb.verboseINFO("Entra na fila: '" + filename + "'");
        BatchRequest.cleanASCII(json);
        br = new BatchRequest(filename, json);
        listQueue.put(filename, br);
        return br;
    }

    public static synchronized BatchRequest getByNro(String nro, String type) {
        BatchRequest br = null;
        if (listQueue == null) {
            return null;
        }
        for (Map.Entry<String, BatchRequest> cli : listQueue.entrySet()) {
            br = cli.getValue();
            if (br.state != State.WAITING || !nro.equals("") && !br.nro.equals(nro) || br.filename.indexOf(type) <= 0) continue;
            br.state = State.PROCESSING;
            return br;
        }
        return null;
    }

    public static enum State {
        WAITING,
        PROCESSING,
        DONE,
        FAIL,
        IGNORE;

    }
}

