/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.text.format.Formatter;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Verbosity;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Util {
    public static final String TYPE_RC4 = "RC4";
    public static final String TYPE_AES = "AES";

    public static JSONObject getInfo(Object androidContext) {
        JSONObject jinfo = new JSONObject();
        JSONArray jifaces = new JSONArray();
        jinfo.put((Object)"unixtime", (Object)(new Date().getTime() / 1000L));
        jinfo.put((Object)"model", (Object)System.getProperty("os.arch"));
        jinfo.put((Object)"vendor", (Object)System.getProperty("java.vm.name"));
        jinfo.put((Object)"so", (Object)(System.getProperty("os.name") + " " + System.getProperty("os.version")));
        jinfo.put((Object)"ifaces", (Object)jifaces);
        try {
            Class.forName("android.os.Build");
            Context ctx = (Context)androidContext;
            String id = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
            jinfo.put((Object)"hostname", (Object)Build.MODEL);
            jinfo.put((Object)"platform", (Object)"Android");
            jinfo.put((Object)"version", (Object)System.getProperty("os.version"));
            jinfo.put((Object)"so", (Object)System.getProperty("os.name"));
            jinfo.put((Object)"id", (Object)id);
            jinfo.put((Object)"macaddress", (Object)id);
            jinfo.put((Object)"model", (Object)Build.HARDWARE);
            jinfo.put((Object)"device", (Object)Build.DEVICE);
            jinfo.put((Object)"product", (Object)Build.PRODUCT);
            jinfo.put((Object)"manufacturer", (Object)Build.MANUFACTURER);
            WifiManager wifiManager = (WifiManager)ctx.getSystemService("wifi");
            String ipAddress = Formatter.formatIpAddress((int)wifiManager.getConnectionInfo().getIpAddress());
            JSONObject iface = new JSONObject();
            iface.put((Object)"ip", (Object)ipAddress);
            jifaces.add((Object)iface);
            return jinfo;
        }
        catch (ClassNotFoundException ctx) {
            try {
                jinfo.put((Object)"hostname", (Object)InetAddress.getLocalHost().getHostName());
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    String smac = "";
                    byte[] mac = netint.getHardwareAddress();
                    JSONObject iface = new JSONObject();
                    jifaces.add((Object)iface);
                    if (mac != null) {
                        int i;
                        for (i = 0; i < mac.length; ++i) {
                            smac = smac + String.format("%02X", mac[i]);
                        }
                        jinfo.put((Object)"macaddress", (Object)smac);
                        jinfo.put((Object)"id", (Object)smac);
                        smac = String.format("%02X", mac[0]);
                        for (i = 1; i < mac.length; ++i) {
                            smac = smac + String.format(":%02X", mac[i]);
                        }
                    }
                    iface.put((Object)"macaddress", (Object)smac);
                    iface.put((Object)"display", (Object)netint.getDisplayName());
                    iface.put((Object)"name", (Object)netint.getName());
                    Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                    for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                        if (inetAddress.toString().indexOf(":") > 0) continue;
                        iface.put((Object)"ip", (Object)inetAddress.toString().substring(1));
                    }
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
            catch (SocketException e) {
                e.printStackTrace();
                return null;
            }
            return jinfo;
        }
    }

    public static void fillObject(JSONObject obj, String[] key_val) {
        if (obj == null || key_val == null) {
            return;
        }
        int i = 0;
        while (i + 1 < key_val.length) {
            if (!obj.containsKey((Object)key_val[i])) {
                obj.put((Object)key_val[i], (Object)key_val[i + 1]);
            }
            i += 2;
        }
    }

    public static String[] fillStringArray(JSONObject obj, String[] keys, String[] values) {
        if (keys == null) {
            return null;
        }
        int v_len = 0;
        if (values != null) {
            v_len = values.length;
        }
        String[] out = new String[keys.length];
        int j = 0;
        String val = "";
        for (int i = 0; i < keys.length && i < out.length; ++i) {
            if (keys[i] == null) {
                if (j < v_len) {
                    out[i] = values[j++];
                    continue;
                }
                out[i] = "";
                continue;
            }
            if (obj.containsKey((Object)keys[i])) {
                if (obj.get((Object)keys[i]) == null) {
                    val = "";
                } else {
                    val = obj.get((Object)keys[i]).toString();
                    if (val == null) {
                        val = "";
                    }
                }
            }
            out[i] = val;
        }
        return out;
    }

    public static byte[] getBytesFromArgs(String[] args, String key) {
        String val = Util.getValueFromArgs(args, key);
        if (val == null) {
            return null;
        }
        return Util.hex2byte(val);
    }

    public static double getDoubleFromArgs(String[] args, String key) {
        String val = Util.getValueFromArgs(args, key);
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public static long getLongFromArgs(String[] args, String key) {
        String val = Util.getValueFromArgs(args, key);
        if (val == null) {
            return 0L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public static int getIntFromArgs(String[] args, String key) {
        String val = Util.getValueFromArgs(args, key);
        if (val == null) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static Object getJSONFromArgs(String[] args, String key) {
        JSONParser parser = new JSONParser();
        String val = Util.getValueFromArgs(args, key);
        if (val == null) {
            return null;
        }
        try {
            Object jobj = parser.parse(val);
            return jobj;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static String getValueFromArgs(String[] args, String key) {
        if (args == null || key == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i] != null && args[i].equals(key)) {
                return args[i + 1];
            }
            i += 2;
        }
        return null;
    }

    public static String[] setValueInArgs(String[] args, String key, String value) {
        if (args == null || key == null) {
            return null;
        }
        int i = 0;
        String[] out = args;
        String old = Util.getValueFromArgs(args, key);
        if (old == null) {
            out = new String[args.length + 2];
            out[i++] = key;
            out[i++] = value;
            for (String e : args) {
                out[i++] = e;
            }
        } else {
            int j = 0;
            while (j + 1 < out.length) {
                if (out[j].equals(key)) {
                    out[j + 1] = value;
                }
                j += 2;
            }
        }
        return out;
    }

    public static boolean checkKeysInArgs(String[] args, String[] keys) {
        if (args == null || keys == null) {
            return false;
        }
        for (String k : keys) {
            boolean found = false;
            for (int i = 0; i < args.length; i += 2) {
                if (!args[i].equals(k)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean loadLibrary(JSONObject jconf) throws UnsatisfiedLinkError {
        String lib = "";
        if (jconf == null || !jconf.containsKey((Object)"library")) {
            Verbosity.println("library indefinida.");
            return false;
        }
        lib = jconf.get((Object)"library").toString();
        System.loadLibrary(lib);
        return true;
    }

    public static String getContent(String file) {
        String data = null;
        try {
            FileInputStream is = new FileInputStream(file);
            data = Util.getContent(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Arquivo nao encontrado: '" + file + "'");
        }
        catch (IOException ioe) {
            System.err.println("Falha ao tentar ler: " + file);
        }
        return data;
    }

    public static String getContent(InputStream is) {
        StringBuilder sb = new StringBuilder();
        String json = null;
        try {
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String line = buf.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = buf.readLine();
            }
            buf.close();
            json = sb.toString();
        }
        catch (IOException ioe) {
            System.err.println("Falha ao tentar ler stream.");
        }
        return json;
    }

    public static String getResponse(HttpURLConnection con, String linefeed) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            if (linefeed == null) continue;
            response.append(linefeed);
        }
        in.close();
        return response.toString();
    }

    public static String sendFORM(Producer prod, URL url, String[] args) {
        String ret = null;
        if (args == null) {
            ret = Util.sendPOST(prod, url, null, "application/x-www-form-urlencoded");
            return ret;
        }
        String post = "";
        int i = 0;
        while (i + 1 < args.length) {
            if (i > 0) {
                post = post + "&";
            }
            try {
                post = post + URLEncoder.encode(args[i], StandardCharsets.UTF_8.toString());
                post = post + "=" + URLEncoder.encode(args[i + 1], StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException uee) {
                prod.sendMessage(2, uee.getMessage());
                return null;
            }
            i += 2;
        }
        ret = Util.sendPOST(prod, url, post.getBytes(), "application/x-www-form-urlencoded");
        return ret;
    }

    public static String sendPOST(Producer prod, URL url, byte[] data, String contentType) {
        try {
            Util.IgnoreSSL();
        }
        catch (Exception e) {
            prod.sendMessage(1, e.getMessage());
            return null;
        }
        String resp = null;
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(60000);
            con.setRequestProperty("User-Agent", "iFractal SIIN");
            con.setRequestProperty("Content-Type", contentType);
            if (data == null) {
                con.setRequestMethod("GET");
            } else {
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Length", "" + data.length);
                con.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data);
                wr.flush();
                wr.close();
            }
            int retcode = con.getResponseCode();
            resp = Util.getResponse(con, "\n");
            if (retcode != 200) {
                prod.sendMessage(2, "Falha ao tentar acessar: " + url + " (" + retcode + ")");
                resp = null;
            }
            con.disconnect();
        }
        catch (IOException ioe) {
            prod.sendMessage(2, ioe.getMessage());
            return null;
        }
        return resp;
    }

    public static URL getURL(String protocol, String address, String port, String resource) {
        String url = String.format("%s://%s:%s/%s", protocol, address, port, resource);
        try {
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void IgnoreSSL() throws Exception {
        X509TrustManager ignore = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        };
        SSLContext _ssl = SSLContext.getInstance("SSL");
        _ssl.init(null, new TrustManager[]{ignore}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(_ssl.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public static byte[] getFromFile(String name) {
        try {
            return Files.readAllBytes(Paths.get(name, new String[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String unixTimestamp2Timestamp(Long unix_timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        calendar.setTimeInMillis(unix_timestamp * 1000L);
        return String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", calendar);
    }

    public static String join(String delimiter, String[] s) {
        String r = "";
        for (String each : s) {
            r = r + each + delimiter;
        }
        return r.substring(0, r.length() - 1);
    }

    public static byte[] hex2byte(String hex) {
        if (hex == null || hex.length() % 2 != 0) {
            return null;
        }
        byte[] bin = new byte[hex.length() / 2];
        for (int i = 0; i < bin.length; ++i) {
            for (char c : new char[]{hex.charAt(2 * i), hex.charAt(2 * i + 1)}) {
                if (c < '0') {
                    return null;
                }
                if (c > '9' && c < 'A') {
                    return null;
                }
                if (c > 'F' && c < 'a') {
                    return null;
                }
                if (c <= 'f') continue;
                return null;
            }
            String pair = hex.substring(2 * i, 2 * i + 2);
            bin[i] = (byte)Integer.valueOf(pair, 16).intValue();
        }
        return bin;
    }

    public static String byte2hex(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (byte h : b) {
            sb.append(String.format("%02X", h));
        }
        return sb.toString();
    }

    public static byte[] base642byte(String b64) {
        byte[] data = Base64.decodeBase64((byte[])b64.getBytes());
        if (data == null) {
            return null;
        }
        return data;
    }

    public static String byte2base64(byte[] data) {
        String out = new String(Base64.encodeBase64((byte[])data));
        return out;
    }

    public static int jsonIter(JSONArray array, IfaceJSONIter callback, Object[] context, int[] count) {
        JSONObject elem;
        int r;
        if (array == null) {
            return 0;
        }
        Iterator iter = array.iterator();
        int n = 0;
        while (iter.hasNext() && (r = callback.perform(elem = (JSONObject)iter.next(), context, count)) == 0) {
            ++n;
        }
        return n;
    }

    public static boolean saveJSONArray(Verbosity verb, JSONArray json, String filename) {
        try {
            FileWriter fw = new FileWriter(filename);
            String aux = json.toString();
            fw.write(aux, 0, aux.length());
            fw.close();
        }
        catch (IOException ioe) {
            verb.verboseERROR("Falha ao tentar salvar: '" + filename + "'.");
            verb.verboseERROR(ioe.getMessage());
            return false;
        }
        return true;
    }

    public static JSONArray loadJSONArrayFile(Producer prod, String filename) {
        JSONParser parser = new JSONParser();
        JSONArray json = null;
        try {
            FileReader fr = new FileReader(filename);
            json = (JSONArray)parser.parse((Reader)fr);
            fr.close();
        }
        catch (FileNotFoundException fnfe) {
            prod.sendMessage(2, "Erro ao tentar abrir: '" + filename + "'");
        }
        catch (IOException ioe) {
            prod.sendMessage(2, "Erro ao tentar abrir: '" + filename + "'\n" + ioe.getMessage());
        }
        catch (ParseException pe) {
            prod.sendMessage(2, "Erro ao tentar ler JSON: " + pe.getMessage());
        }
        catch (ClassCastException cce) {
            prod.sendMessage(2, "Erro ao tentar ler JSON: " + filename + "'");
            prod.sendMessage(2, cce.getMessage());
        }
        return json;
    }

    public static byte[] bufferedImage2byte(BufferedImage source, String formatName) {
        byte[] imgOut = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)source, formatName, baos);
            imgOut = baos.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println("Error bufferedImage2byte");
            System.err.println(ioe.getMessage());
        }
        return imgOut;
    }

    public static BufferedImage byte2bufferedImage(byte[] source) {
        BufferedImage imgOut = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(source);
            imgOut = ImageIO.read(is);
        }
        catch (IOException ioe) {
            System.err.println("Error byte2bufferedImage");
            System.err.println(ioe.getMessage());
        }
        return imgOut;
    }

    public static BufferedImage resizeImage(BufferedImage srcImg, String formatName, double resizePercentage) {
        BufferedImage outputImg = null;
        int newHeight = (int)((double)srcImg.getHeight() * resizePercentage / 100.0);
        int newWidth = (int)((double)srcImg.getWidth() * resizePercentage / 100.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int type = formatName.equals("png") ? 2 : 1;
        outputImg = new BufferedImage(newWidth, newHeight, type);
        Graphics2D graphics2D = outputImg.createGraphics();
        graphics2D.setRenderingHints(hints);
        graphics2D.drawImage(srcImg, 0, 0, newWidth, newHeight, null);
        graphics2D.dispose();
        return outputImg;
    }

    public static byte[] concatArrays(byte[] ... chunks) {
        int i;
        int off = 0;
        int len = 0;
        if (chunks == null || chunks.length < 1) {
            return null;
        }
        if (chunks.length < 2) {
            return chunks[0];
        }
        for (i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            len += chunks[i].length;
        }
        byte[] res = new byte[len];
        for (i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            for (int k = 0; k < chunks[i].length; ++k) {
                res[off++] = chunks[i][k];
            }
        }
        return res;
    }

    public static byte[] processRC4(int mode, String key, byte[] data) {
        if (key == null) {
            return null;
        }
        while (key.length() < 8) {
            key = "0" + key;
        }
        return Util.processRC4(mode, key.getBytes(), data);
    }

    public static byte[] processRC4(int mode, byte[] key, byte[] data) {
        return Util.processEncrypt(mode, key, data, TYPE_RC4, TYPE_RC4);
    }

    public static byte[] processAES(int mode, String key, byte[] data) throws Exception {
        if (key == null) {
            return null;
        }
        while (key.length() < 32) {
            key = "0" + key;
        }
        return Util.processEncrypt(mode, key.getBytes(), data, TYPE_AES, "AES/CBC/PKCS5PADDING");
    }

    public static byte[] processEncrypt(int mode, byte[] key, byte[] data, String algorithm, String transformation) {
        byte[] out = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            if (algorithm.equals(TYPE_AES)) {
                cipher.init(mode, (Key)secretKey, new IvParameterSpec(new byte[16]));
            } else {
                cipher.init(mode, secretKey);
            }
            out = cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            System.err.println(ex.getMessage());
            System.err.println("Falha ao tentar encriptar dados.");
        }
        return out;
    }

    public static boolean isBinary(byte[] bytes) {
        if (bytes == null) {
            return true;
        }
        for (byte b : bytes) {
            if (b < 0 || b >= 32) continue;
            return true;
        }
        return false;
    }

    public static String readLine(InputStream is) throws IOException, InterruptedException {
        return Util.readLine(is, 30);
    }

    public static String readLine(InputStream is, int timeout_in_millis) throws IOException, InterruptedException {
        int off = 0;
        int size = 16;
        byte[] buf = new byte[size];
        long start = new Date().getTime();
        while (true) {
            long now = 0L;
            int n = 0;
            while ((n = is.available()) < 1 && (now = new Date().getTime()) - start <= (long)timeout_in_millis) {
                Thread.sleep(100L);
            }
            if (n < 1) break;
            if (off > size / 2) {
                byte[] tmp = new byte[size *= 2];
                System.arraycopy(buf, 0, tmp, 0, off);
                buf = tmp;
            }
            if ((n = is.read(buf, off, 1)) < 1 || buf[off] == 10) break;
            if (buf[off] == 13) continue;
            ++off;
        }
        if (off <= 0) {
            return null;
        }
        String ret = new String(buf, 0, off);
        return ret;
    }

    public static void main(String[] args) throws MalformedURLException {
        String msg = "Teste RC4";
        String key = "71b3a2fb36fdbf97b591046722bf1feffcA7";
        byte[] cipher = Util.processRC4(1, key, msg.getBytes());
        byte[] orig = Util.processRC4(2, key, cipher);
        System.out.println(key);
        System.out.println(cipher);
        System.out.println(new String(orig));
        JSONObject jinfo = Util.getInfo(null);
        System.out.println(jinfo);
    }
}

